Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

/** @babel */

var _atom = require('atom');

var _ctags = require('ctags');

var _ctags2 = _interopRequireDefault(_ctags);

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var handlerPath = require.resolve('./load-tags-handler');

var wordAtCursor = function wordAtCursor(text, cursorIndex, wordSeparator, noStripBefore) {
  var beforeCursor = text.slice(0, cursorIndex);
  var afterCursor = text.slice(cursorIndex);
  var beforeCursorWordBegins = noStripBefore ? 0 : beforeCursor.lastIndexOf(wordSeparator) + 1;
  var afterCursorWordEnds = afterCursor.indexOf(wordSeparator);
  if (afterCursorWordEnds === -1) {
    afterCursorWordEnds = afterCursor.length;
  }
  return beforeCursor.slice(beforeCursorWordBegins) + afterCursor.slice(0, afterCursorWordEnds);
};

exports['default'] = {
  find: function find(editor, callback) {
    var symbol = undefined;
    var symbols = [];

    if (symbol = editor.getSelectedText()) {
      symbols.push(symbol);
    }

    if (!symbols.length) {
      (function () {
        var nonWordCharacters = undefined;
        var cursor = editor.getLastCursor();
        var cursorPosition = cursor.getBufferPosition();
        var scope = cursor.getScopeDescriptor();
        var rubyScopes = scope.getScopesArray().filter(function (s) {
          return (/^source\.ruby($|\.)/.test(s)
          );
        });

        var wordRegExp = rubyScopes.length ? (nonWordCharacters = atom.config.get('editor.nonWordCharacters', { scope: scope }),
        // Allow special handling for fully-qualified ruby constants
        nonWordCharacters = nonWordCharacters.replace(/:/g, ''), new RegExp('[^\\s' + _underscorePlus2['default'].escapeRegExp(nonWordCharacters) + ']+([!?]|\\s*=>?)?|[<=>]+', 'g')) : cursor.wordRegExp();

        var addSymbol = function addSymbol(symbol) {
          if (rubyScopes.length) {
            // Normalize assignment syntax
            if (/\s+=?$/.test(symbol)) {
              symbols.push(symbol.replace(/\s+=$/, '='));
            }
            // Strip away assignment & hashrocket syntax
            symbols.push(symbol.replace(/\s+=>?$/, ''));
          } else {
            symbols.push(symbol);
          }
        };

        // Can't use `getCurrentWordBufferRange` here because we want to select
        // the last match of the potential 2 matches under cursor.
        editor.scanInBufferRange(wordRegExp, cursor.getCurrentLineBufferRange(), function (_ref) {
          var range = _ref.range;
          var match = _ref.match;

          if (range.containsPoint(cursorPosition)) {
            symbol = match[0];
            if (rubyScopes.length && symbol.indexOf(':') > -1) {
              var cursorWithinSymbol = cursorPosition.column - range.start.column;
              // Add fully-qualified ruby constant up until the cursor position
              addSymbol(wordAtCursor(symbol, cursorWithinSymbol, ':', true));
              // Additionally, also look up the bare word under cursor
              addSymbol(wordAtCursor(symbol, cursorWithinSymbol, ':'));
            } else {
              addSymbol(symbol);
            }
          }
        });
      })();
    }

    if (!symbols.length) {
      process.nextTick(function () {
        callback(null, []);
      });
    }

    _async2['default'].map(atom.project.getPaths(), function (projectPath, done) {
      var tagsFile = (0, _getTagsFile2['default'])(projectPath);
      var foundTags = [];
      var foundErr = null;
      var detectCallback = function detectCallback() {
        done(foundErr, foundTags);
      };
      if (!tagsFile) {
        return detectCallback();
      }
      // Find the first symbol in the list that matches a tag
      return _async2['default'].detectSeries(symbols, function (symbol, doneDetect) {
        _ctags2['default'].findTags(tagsFile, symbol, function (err, tags) {
          if (!tags) {
            tags = [];
          }
          if (err) {
            foundErr = err;
            doneDetect(false);
          } else if (tags.length) {
            for (var tag of Array.from(tags)) {
              tag.directory = projectPath;
            }
            foundTags = tags;
            doneDetect(true);
          } else {
            doneDetect(false);
          }
        });
      }, detectCallback);
    }, function (err, foundTags) {
      callback(err, _underscorePlus2['default'].flatten(foundTags));
    });
  },

  getAllTags: function getAllTags(callback) {
    var projectTags = [];
    var task = _atom.Task.once(handlerPath, atom.project.getPaths(), function () {
      return callback(projectTags);
    });
    task.on('tags', function (tags) {
      projectTags.push.apply(projectTags, _toConsumableArray(tags));
    });
    return task;
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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