Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _highlights = require('highlights');

var _highlights2 = _interopRequireDefault(_highlights);

var CodeBlock = (function () {
  function CodeBlock(props) {
    _classCallCheck(this, CodeBlock);

    this.highlighter = new _highlights2['default']({ registry: atom.grammars, scopePrefix: 'syntax--' });
    this.wrapperElement = document.createElement('div');
    this.update(props);
  }

  _createClass(CodeBlock, [{
    key: 'update',
    value: function update(_ref) {
      var cssClass = _ref.cssClass;
      var grammarScopeName = _ref.grammarScopeName;
      var code = _ref.code;

      this.wrapperElement.innerHTML = this.highlighter.highlightSync({ fileContents: code, scopeName: grammarScopeName });
      this.element = this.wrapperElement.children[0];
      this.element.classList.remove('editor'); // The `editor` class messes things up as `.editor` has absolutely positioned lines
      this.element.classList.add(cssClass);
      var fontFamily = atom.config.get('editor.fontFamily');
      if (fontFamily) {
        this.element.style.fontFamily = fontFamily;
      }
    }
  }]);

  return CodeBlock;
})();

exports['default'] = CodeBlock;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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