(function() {
  var SelectionCountView, _;

  _ = require('underscore-plus');

  module.exports = SelectionCountView = (function() {
    function SelectionCountView() {
      var ref;
      this.element = document.createElement('status-bar-selection');
      this.element.classList.add('selection-count', 'inline-block');
      this.tooltipElement = document.createElement('div');
      this.tooltipDisposable = atom.tooltips.add(this.element, {
        item: this.tooltipElement
      });
      this.formatString = (ref = atom.config.get('status-bar.selectionCountFormat')) != null ? ref : '(%L, %C)';
      if (atom.workspace.onDidChangeActiveTextEditor) {
        this.activeItemSubscription = atom.workspace.onDidChangeActiveTextEditor((function(_this) {
          return function() {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      } else {
        this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
          return function() {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      }
      this.subscribeToConfig();
      this.subscribeToActiveTextEditor();
    }

    SelectionCountView.prototype.destroy = function() {
      var ref, ref1;
      this.activeItemSubscription.dispose();
      if ((ref = this.selectionSubscription) != null) {
        ref.dispose();
      }
      if ((ref1 = this.configSubscription) != null) {
        ref1.dispose();
      }
      return this.tooltipDisposable.dispose();
    };

    SelectionCountView.prototype.subscribeToConfig = function() {
      var ref;
      if ((ref = this.configSubscription) != null) {
        ref.dispose();
      }
      return this.configSubscription = atom.config.observe('status-bar.selectionCountFormat', (function(_this) {
        return function(value) {
          _this.formatString = value != null ? value : '(%L, %C)';
          return _this.scheduleUpdateCount();
        };
      })(this));
    };

    SelectionCountView.prototype.subscribeToActiveTextEditor = function() {
      var activeEditor, ref, selectionsMarkerLayer;
      if ((ref = this.selectionSubscription) != null) {
        ref.dispose();
      }
      activeEditor = this.getActiveTextEditor();
      selectionsMarkerLayer = activeEditor != null ? activeEditor.selectionsMarkerLayer : void 0;
      this.selectionSubscription = selectionsMarkerLayer != null ? selectionsMarkerLayer.onDidUpdate(this.scheduleUpdateCount.bind(this)) : void 0;
      return this.scheduleUpdateCount();
    };

    SelectionCountView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    SelectionCountView.prototype.scheduleUpdateCount = function() {
      if (!this.scheduledUpdate) {
        this.scheduledUpdate = true;
        return atom.views.updateDocument((function(_this) {
          return function() {
            _this.updateCount();
            return _this.scheduledUpdate = false;
          };
        })(this));
      }
    };

    SelectionCountView.prototype.updateCount = function() {
      var count, lineCount, range, ref, ref1;
      count = (ref = this.getActiveTextEditor()) != null ? ref.getSelectedText().length : void 0;
      range = (ref1 = this.getActiveTextEditor()) != null ? ref1.getSelectedBufferRange() : void 0;
      lineCount = range != null ? range.getRowCount() : void 0;
      if ((range != null ? range.end.column : void 0) === 0) {
        lineCount -= 1;
      }
      if (count > 0) {
        this.element.textContent = this.formatString.replace('%L', lineCount).replace('%C', count);
        return this.tooltipElement.textContent = (_.pluralize(lineCount, 'line')) + ", " + (_.pluralize(count, 'character')) + " selected";
      } else {
        this.element.textContent = '';
        return this.tooltipElement.textContent = '';
      }
    };

    return SelectionCountView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
