/// <reference path="../typings/main.d.ts" />
import * as natural from "natural";
export declare enum TokenCheckStatus {
    Unknown = 0,
    Correct = 1,
    Incorrect = 2,
}
export interface TokenStatus {
    start: number;
    end: number;
    token: string;
    status: TokenCheckStatus;
}
export declare abstract class SpellingManager {
    add(token: string): void;
    isCorrect(token: string): boolean;
    check(token: string): TokenCheckStatus;
    suggest(token: string): string[];
}
export declare class TokenSpellingManager extends SpellingManager {
    maximumDistance: number;
    sensitive: any;
    insensitive: any;
    add(token: string | string[]): void;
    addCaseSensitive(token: string): void;
    addCaseInsensitive(token: string): void;
    check(token: string): TokenCheckStatus;
    list(): string[];
    remove(token: string): void;
    removeCaseSensitive(token: string): void;
    removeCaseInsensitive(token: string): void;
    suggest(input: string): string[];
}
export declare class BufferSpellingChecker {
    constructor(spellingManager: SpellingManager, tokenizer?: natural.Tokenizer);
    private spellingManager;
    private tokenizer;
    check(buffer: string): TokenStatus[];
}
