Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var SnippetsAvailable = (function () {
  function SnippetsAvailable(snippets) {
    var _this = this;

    _classCallCheck(this, SnippetsAvailable);

    this.panel = null;
    this.snippets = snippets;
    this.selectListView = new _atomSelectList2['default']({
      items: [],
      filterKeyForItem: function filterKeyForItem(snippet) {
        return snippet.searchText;
      },
      elementForItem: function elementForItem(snippet) {
        var li = document.createElement('li');
        li.classList.add('two-lines');

        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = snippet.prefix;
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line');
        secondaryLine.textContent = snippet.name;
        li.appendChild(secondaryLine);

        return li;
      },
      didConfirmSelection: function didConfirmSelection(snippet) {
        for (var cursor of _this.editor.getCursors()) {
          _this.snippets.insert(snippet.bodyText, _this.editor, cursor);
        }
        _this.cancel();
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.cancel();
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('available-snippets');
    this.element = this.selectListView.element;
  }

  _createClass(SnippetsAvailable, [{
    key: 'toggle',
    value: _asyncToGenerator(function* (editor) {
      this.editor = editor;
      if (this.panel != null) {
        this.cancel();
      } else {
        this.selectListView.reset();
        yield this.populate();
        this.attach();
      }
    })
  }, {
    key: 'cancel',
    value: function cancel() {
      this.editor = null;

      if (this.panel != null) {
        this.panel.destroy();
        this.panel = null;
      }

      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'populate',
    value: function populate() {
      var snippets = _underscorePlus2['default'].values(this.snippets.getSnippets(this.editor));
      for (var snippet of snippets) {
        snippet.searchText = _underscorePlus2['default'].compact([snippet.prefix, snippet.name]).join(' ');
      }
      return this.selectListView.update({ items: snippets });
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.panel = atom.workspace.addModalPanel({ item: this });
      this.selectListView.focus();
    }
  }]);

  return SnippetsAvailable;
})();

exports['default'] = SnippetsAvailable;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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