Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _roaster = require('roaster');

var _roaster2 = _interopRequireDefault(_roaster);

var ATTRIBUTES_TO_REMOVE = ['onabort', 'onblur', 'onchange', 'onclick', 'ondbclick', 'onerror', 'onfocus', 'onkeydown', 'onkeypress', 'onkeyup', 'onload', 'onmousedown', 'onmousemove', 'onmouseover', 'onmouseout', 'onmouseup', 'onreset', 'onresize', 'onscroll', 'onselect', 'onsubmit', 'onunload'];

function sanitize(html) {
  var temporaryContainer = document.createElement('div');
  temporaryContainer.innerHTML = html;

  for (var script of temporaryContainer.querySelectorAll('script')) {
    script.remove();
  }

  for (var element of temporaryContainer.querySelectorAll('*')) {
    for (var attribute of ATTRIBUTES_TO_REMOVE) {
      element.removeAttribute(attribute);
    }
  }

  for (var checkbox of temporaryContainer.querySelectorAll('input[type="checkbox"]')) {
    checkbox.setAttribute('disabled', true);
  }

  return temporaryContainer.innerHTML;
}

// Displays the readme for a package, if it has one
// TODO Decide to keep this or current button-to-new-tab view

var PackageReadmeView = (function () {
  function PackageReadmeView(readme) {
    var _this = this;

    _classCallCheck(this, PackageReadmeView);

    this.element = document.createElement('section');
    this.element.classList.add('section');

    var container = document.createElement('div');
    container.classList.add('section-container');

    var heading = document.createElement('div');
    heading.classList.add('section-heading', 'icon', 'icon-book');
    heading.textContent = 'README';
    container.appendChild(heading);

    this.packageReadme = document.createElement('div');
    this.packageReadme.classList.add('package-readme', 'native-key-bindings');
    this.packageReadme.tabIndex = -1;
    container.appendChild(this.packageReadme);
    this.element.appendChild(container);

    (0, _roaster2['default'])(readme || '### No README.', function (err, content) {
      if (err) {
        _this.packageReadme.innerHTML = '<h3>Error parsing README</h3>';
      } else {
        _this.packageReadme.innerHTML = sanitize(content);
      }
    });
  }

  _createClass(PackageReadmeView, [{
    key: 'destroy',
    value: function destroy() {
      this.element.remove();
    }
  }]);

  return PackageReadmeView;
})();

exports['default'] = PackageReadmeView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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