(function() {
  var PackageManager, SettingsView, SnippetsProvider, configUri, openPanel, packageManager, settingsView, statusView, uriRegex;

  SettingsView = null;

  settingsView = null;

  statusView = null;

  PackageManager = require('./package-manager');

  packageManager = null;

  SnippetsProvider = {
    getSnippets: function() {
      return atom.config.scopedSettingsStore.propertySets;
    }
  };

  configUri = 'atom://config';

  uriRegex = /config\/([a-z]+)\/?([a-zA-Z0-9_-]+)?/i;

  openPanel = function(settingsView, panelName, uri) {
    var detail, match, options, panel;
    match = uriRegex.exec(uri);
    panel = match != null ? match[1] : void 0;
    detail = match != null ? match[2] : void 0;
    options = {
      uri: uri
    };
    if (panel === "packages" && (detail != null)) {
      panelName = detail;
      options.pack = {
        name: detail
      };
      if (atom.packages.getLoadedPackage(detail)) {
        options.back = 'Packages';
      }
    }
    return settingsView.showPanel(panelName, options);
  };

  module.exports = {
    activate: function() {
      atom.workspace.addOpener((function(_this) {
        return function(uri) {
          var match, panelName;
          if (uri.startsWith(configUri)) {
            if ((settingsView == null) || settingsView.destroyed) {
              settingsView = _this.createSettingsView({
                uri: uri
              });
            }
            if (match = uriRegex.exec(uri)) {
              panelName = match[1];
              panelName = panelName[0].toUpperCase() + panelName.slice(1);
              openPanel(settingsView, panelName, uri);
            }
            return settingsView;
          }
        };
      })(this));
      atom.commands.add('atom-workspace', {
        'settings-view:open': function() {
          return atom.workspace.open(configUri);
        },
        'settings-view:core': function() {
          return atom.workspace.open(configUri + "/core");
        },
        'settings-view:editor': function() {
          return atom.workspace.open(configUri + "/editor");
        },
        'settings-view:show-keybindings': function() {
          return atom.workspace.open(configUri + "/keybindings");
        },
        'settings-view:change-themes': function() {
          return atom.workspace.open(configUri + "/themes");
        },
        'settings-view:install-packages-and-themes': function() {
          return atom.workspace.open(configUri + "/install");
        },
        'settings-view:view-installed-themes': function() {
          return atom.workspace.open(configUri + "/themes");
        },
        'settings-view:uninstall-themes': function() {
          return atom.workspace.open(configUri + "/themes");
        },
        'settings-view:view-installed-packages': function() {
          return atom.workspace.open(configUri + "/packages");
        },
        'settings-view:uninstall-packages': function() {
          return atom.workspace.open(configUri + "/packages");
        },
        'settings-view:check-for-package-updates': function() {
          return atom.workspace.open(configUri + "/updates");
        }
      });
      if (process.platform === 'win32' && (require('atom').WinShell != null)) {
        atom.commands.add('atom-workspace', {
          'settings-view:system': function() {
            return atom.workspace.open(configUri + "/system");
          }
        });
      }
      if (!localStorage.getItem('hasSeenDeprecatedNotification')) {
        if (packageManager == null) {
          packageManager = new PackageManager();
        }
        return packageManager.getInstalled().then((function(_this) {
          return function(packages) {
            var ref;
            if ((ref = packages.user) != null ? ref.length : void 0) {
              return _this.showDeprecatedNotification(packages);
            }
          };
        })(this));
      }
    },
    deactivate: function() {
      if (settingsView != null) {
        settingsView.destroy();
      }
      if (statusView != null) {
        statusView.destroy();
      }
      settingsView = null;
      packageManager = null;
      return statusView = null;
    },
    consumeStatusBar: function(statusBar) {
      if (packageManager == null) {
        packageManager = new PackageManager();
      }
      return packageManager.getOutdated().then(function(updates) {
        var PackageUpdatesStatusView;
        if (packageManager != null) {
          PackageUpdatesStatusView = require('./package-updates-status-view');
          statusView = new PackageUpdatesStatusView();
          return statusView.initialize(statusBar, packageManager, updates);
        }
      });
    },
    consumeSnippets: function(snippets) {
      if (typeof snippets.getUnparsedSnippets === "function") {
        return SnippetsProvider.getSnippets = snippets.getUnparsedSnippets.bind(snippets);
      }
    },
    createSettingsView: function(params) {
      if (SettingsView == null) {
        SettingsView = require('./settings-view');
      }
      if (packageManager == null) {
        packageManager = new PackageManager();
      }
      params.packageManager = packageManager;
      params.snippetsProvider = SnippetsProvider;
      return settingsView = new SettingsView(params);
    },
    showDeprecatedNotification: function(packages) {
      var deprecatedPackages, have, notification, pack, packageText, were;
      localStorage.setItem('hasSeenDeprecatedNotification', true);
      deprecatedPackages = packages.user.filter(function(arg) {
        var name, version;
        name = arg.name, version = arg.version;
        return atom.packages.isDeprecatedPackage(name, version);
      });
      if (!deprecatedPackages.length) {
        return;
      }
      were = 'were';
      have = 'have';
      packageText = 'packages';
      if (packages.length === 1) {
        packageText = 'package';
        were = 'was';
        have = 'has';
      }
      return notification = atom.notifications.addWarning(deprecatedPackages.length + " " + packageText + " " + have + " deprecations and " + were + " not loaded.", {
        description: 'This message will show only one time. Deprecated packages can be viewed in the settings view.',
        detail: ((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = deprecatedPackages.length; i < len; i++) {
            pack = deprecatedPackages[i];
            results.push(pack.name);
          }
          return results;
        })()).join(', '),
        dismissable: true,
        buttons: [
          {
            text: 'View Deprecated Packages',
            onDidClick: function() {
              atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:view-installed-packages');
              return notification.dismiss();
            }
          }
        ]
      });
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
