(function() {
  var BufferedProcess, DEV_PACKAGE_PATH, fs, os, path, semver,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  os = require('os');

  fs = require('fs');

  path = require('path');

  semver = require('semver');

  BufferedProcess = require('atom').BufferedProcess;


  /*
  A collection of methods for retrieving information about the user's system for
  bug report purposes.
   */

  DEV_PACKAGE_PATH = path.join('dev', 'packages');

  module.exports = {

    /*
    Section: System Information
     */
    getPlatform: function() {
      return os.platform();
    },
    getOSVersion: function() {
      return new Promise((function(_this) {
        return function(resolve, reject) {
          switch (_this.getPlatform()) {
            case 'darwin':
              return resolve(_this.macVersionText());
            case 'win32':
              return resolve(_this.winVersionText());
            case 'linux':
              return resolve(_this.linuxVersionText());
            default:
              return resolve((os.platform()) + " " + (os.release()));
          }
        };
      })(this));
    },
    macVersionText: function() {
      return this.macVersionInfo().then(function(info) {
        if (!(info.ProductName && info.ProductVersion)) {
          return 'Unknown macOS version';
        }
        return info.ProductName + " " + info.ProductVersion;
      });
    },
    macVersionInfo: function() {
      return new Promise(function(resolve, reject) {
        var plistBuddy, stdout;
        stdout = '';
        plistBuddy = new BufferedProcess({
          command: '/usr/libexec/PlistBuddy',
          args: ['-c', 'Print ProductVersion', '-c', 'Print ProductName', '/System/Library/CoreServices/SystemVersion.plist'],
          stdout: function(output) {
            return stdout += output;
          },
          exit: function() {
            var ProductName, ProductVersion, ref;
            ref = stdout.trim().split('\n'), ProductVersion = ref[0], ProductName = ref[1];
            return resolve({
              ProductVersion: ProductVersion,
              ProductName: ProductName
            });
          }
        });
        return plistBuddy.onWillThrowError(function(arg) {
          var handle;
          handle = arg.handle;
          handle();
          return resolve({});
        });
      });
    },
    linuxVersionText: function() {
      return this.linuxVersionInfo().then(function(info) {
        if (info.DistroName && info.DistroVersion) {
          return info.DistroName + " " + info.DistroVersion;
        } else {
          return (os.platform()) + " " + (os.release());
        }
      });
    },
    linuxVersionInfo: function() {
      return new Promise(function(resolve, reject) {
        var lsbRelease, stdout;
        stdout = '';
        lsbRelease = new BufferedProcess({
          command: 'lsb_release',
          args: ['-ds'],
          stdout: function(output) {
            return stdout += output;
          },
          exit: function(exitCode) {
            var DistroName, DistroVersion, ref;
            ref = stdout.trim().split(' '), DistroName = ref[0], DistroVersion = ref[1];
            return resolve({
              DistroName: DistroName,
              DistroVersion: DistroVersion
            });
          }
        });
        return lsbRelease.onWillThrowError(function(arg) {
          var handle;
          handle = arg.handle;
          handle();
          return resolve({});
        });
      });
    },
    winVersionText: function() {
      return new Promise(function(resolve, reject) {
        var data, systemInfo;
        data = [];
        systemInfo = new BufferedProcess({
          command: 'systeminfo',
          stdout: function(oneLine) {
            return data.push(oneLine);
          },
          exit: function() {
            var info, res;
            info = data.join('\n');
            info = (res = /OS.Name.\s+(.*)$/im.exec(info)) ? res[1] : 'Unknown Windows version';
            return resolve(info);
          }
        });
        return systemInfo.onWillThrowError(function(arg) {
          var handle;
          handle = arg.handle;
          handle();
          return resolve('Unknown Windows version');
        });
      });
    },

    /*
    Section: Installed Packages
     */
    getNonCorePackages: function() {
      return new Promise(function(resolve, reject) {
        var devPackageNames, nonCorePackages, pack;
        nonCorePackages = atom.packages.getAvailablePackageMetadata().filter(function(p) {
          return !atom.packages.isBundledPackage(p.name);
        });
        devPackageNames = atom.packages.getAvailablePackagePaths().filter(function(p) {
          return p.includes(DEV_PACKAGE_PATH);
        }).map(function(p) {
          return path.basename(p);
        });
        return resolve((function() {
          var i, len, ref, results;
          results = [];
          for (i = 0, len = nonCorePackages.length; i < len; i++) {
            pack = nonCorePackages[i];
            results.push(pack.name + " " + pack.version + " " + ((ref = pack.name, indexOf.call(devPackageNames, ref) >= 0) ? '(dev)' : ''));
          }
          return results;
        })());
      });
    },
    getLatestAtomData: function() {
      var githubHeaders;
      githubHeaders = new Headers({
        accept: 'application/vnd.github.v3+json',
        contentType: "application/json"
      });
      return fetch('https://atom.io/api/updates', {
        headers: githubHeaders
      }).then(function(r) {
        if (r.ok) {
          return r.json();
        } else {
          return Promise.reject(r.statusCode);
        }
      });
    },
    checkAtomUpToDate: function() {
      return this.getLatestAtomData().then(function(latestAtomData) {
        var installedVersion, latestVersion, ref, upToDate;
        installedVersion = (ref = atom.getVersion()) != null ? ref.replace(/-.*$/, '') : void 0;
        latestVersion = latestAtomData.name;
        upToDate = (installedVersion != null) && semver.gte(installedVersion, latestVersion);
        return {
          upToDate: upToDate,
          latestVersion: latestVersion,
          installedVersion: installedVersion
        };
      });
    },
    getPackageVersion: function(packageName) {
      var pack;
      pack = atom.packages.getLoadedPackage(packageName);
      return pack != null ? pack.metadata.version : void 0;
    },
    getPackageVersionShippedWithAtom: function(packageName) {
      return require(path.join(atom.getLoadSettings().resourcePath, 'package.json')).packageDependencies[packageName];
    },
    getLatestPackageData: function(packageName) {
      var githubHeaders;
      githubHeaders = new Headers({
        accept: 'application/vnd.github.v3+json',
        contentType: "application/json"
      });
      return fetch("https://atom.io/api/packages/" + packageName, {
        headers: githubHeaders
      }).then(function(r) {
        if (r.ok) {
          return r.json();
        } else {
          return Promise.reject(r.statusCode);
        }
      });
    },
    checkPackageUpToDate: function(packageName) {
      return this.getLatestPackageData(packageName).then((function(_this) {
        return function(latestPackageData) {
          var installedVersion, isCore, latestVersion, upToDate, versionShippedWithAtom;
          installedVersion = _this.getPackageVersion(packageName);
          upToDate = (installedVersion != null) && semver.gte(installedVersion, latestPackageData.releases.latest);
          latestVersion = latestPackageData.releases.latest;
          versionShippedWithAtom = _this.getPackageVersionShippedWithAtom(packageName);
          if (isCore = versionShippedWithAtom != null) {
            upToDate = (installedVersion != null) && semver.gte(installedVersion, versionShippedWithAtom);
          }
          return {
            isCore: isCore,
            upToDate: upToDate,
            latestVersion: latestVersion,
            installedVersion: installedVersion,
            versionShippedWithAtom: versionShippedWithAtom
          };
        };
      })(this));
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
