Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var REBUILDING = 'rebuilding';
var REBUILD_FAILED = 'rebuild-failed';
var REBUILD_SUCCEEDED = 'rebuild-succeeded';

var IncompatiblePackagesComponent = (function () {
  function IncompatiblePackagesComponent(packageManager) {
    var _this = this;

    _classCallCheck(this, IncompatiblePackagesComponent);

    this.rebuildStatuses = new Map();
    this.rebuildFailureOutputs = new Map();
    this.rebuildInProgress = false;
    this.rebuiltPackageCount = 0;
    this.packageManager = packageManager;
    this.loaded = false;
    _etch2['default'].initialize(this);

    if (this.packageManager.getActivePackages().length > 0) {
      this.populateIncompatiblePackages();
    } else {
      global.setImmediate(this.populateIncompatiblePackages.bind(this));
    }

    this.element.addEventListener('click', function (event) {
      if (event.target === _this.refs.rebuildButton) {
        _this.rebuildIncompatiblePackages();
      } else if (event.target === _this.refs.reloadButton) {
        atom.reload();
      } else if (event.target.classList.contains('view-settings')) {
        atom.workspace.open('atom://config/packages/' + event.target['package'].name);
      }
    });
  }

  _createClass(IncompatiblePackagesComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      if (!this.loaded) {
        return _etch2['default'].dom(
          'div',
          { className: 'incompatible-packages padded' },
          'Loading...'
        );
      }

      return _etch2['default'].dom(
        'div',
        { className: 'incompatible-packages padded native-key-bindings', tabIndex: '-1' },
        this.renderHeading(),
        this.renderIncompatiblePackageList()
      );
    }
  }, {
    key: 'renderHeading',
    value: function renderHeading() {
      if (this.incompatiblePackages.length > 0) {
        if (this.rebuiltPackageCount > 0) {
          var alertClass = this.rebuiltPackageCount === this.incompatiblePackages.length ? 'alert-success icon-check' : 'alert-warning icon-bug';

          return _etch2['default'].dom(
            'div',
            { className: 'alert icon ' + alertClass },
            this.rebuiltPackageCount,
            ' of ',
            this.incompatiblePackages.length,
            ' packages were rebuilt successfully. Reload Atom to activate them.',
            _etch2['default'].dom(
              'button',
              { ref: 'reloadButton', className: 'btn pull-right' },
              'Reload Atom'
            )
          );
        } else {
          return _etch2['default'].dom(
            'div',
            { className: 'alert alert-danger icon icon-bug' },
            'Some installed packages could not be loaded because they contain native modules that were compiled for an earlier version of Atom.',
            _etch2['default'].dom(
              'button',
              { ref: 'rebuildButton', className: 'btn pull-right', disabled: this.rebuildInProgress },
              'Rebuild Packages'
            )
          );
        }
      } else {
        return _etch2['default'].dom(
          'div',
          { className: 'alert alert-success icon icon-check' },
          'None of your packages contain incompatible native modules.'
        );
      }
    }
  }, {
    key: 'renderIncompatiblePackageList',
    value: function renderIncompatiblePackageList() {
      return _etch2['default'].dom(
        'div',
        null,
        this.incompatiblePackages.map(this.renderIncompatiblePackage.bind(this))
      );
    }
  }, {
    key: 'renderIncompatiblePackage',
    value: function renderIncompatiblePackage(pack) {
      var rebuildStatus = this.rebuildStatuses.get(pack);

      return _etch2['default'].dom(
        'div',
        { className: 'incompatible-package' },
        this.renderRebuildStatusIndicator(rebuildStatus),
        _etch2['default'].dom(
          'button',
          { className: 'btn view-settings icon icon-gear pull-right', 'package': pack },
          'Package Settings'
        ),
        _etch2['default'].dom(
          'h4',
          { className: 'heading' },
          pack.name,
          ' ',
          pack.metadata.version
        ),
        rebuildStatus ? this.renderRebuildOutput(pack) : this.renderIncompatibleModules(pack)
      );
    }
  }, {
    key: 'renderRebuildStatusIndicator',
    value: function renderRebuildStatusIndicator(rebuildStatus) {
      if (rebuildStatus === REBUILDING) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-info pull-right icon icon-gear' },
          'Rebuilding'
        );
      } else if (rebuildStatus === REBUILD_SUCCEEDED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-success pull-right icon icon-check' },
          'Rebuild Succeeded'
        );
      } else if (rebuildStatus === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-error pull-right icon icon-x' },
          'Rebuild Failed'
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderRebuildOutput',
    value: function renderRebuildOutput(pack) {
      if (this.rebuildStatuses.get(pack) === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'pre',
          null,
          this.rebuildFailureOutputs.get(pack)
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIncompatibleModules',
    value: function renderIncompatibleModules(pack) {
      return _etch2['default'].dom(
        'ul',
        null,
        pack.incompatibleModules.map(function (nativeModule) {
          return _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom(
              'div',
              { className: 'icon icon-file-binary' },
              nativeModule.name,
              '@',
              nativeModule.version || 'unknown',
              ' – ',
              _etch2['default'].dom(
                'span',
                { className: 'text-warning' },
                nativeModule.error
              )
            )
          );
        })
      );
    }
  }, {
    key: 'populateIncompatiblePackages',
    value: function populateIncompatiblePackages() {
      this.incompatiblePackages = this.packageManager.getLoadedPackages().filter(function (pack) {
        return !pack.isCompatible();
      });

      for (var pack of this.incompatiblePackages) {
        var buildFailureOutput = pack.getBuildFailureOutput();
        if (buildFailureOutput) {
          this.setPackageStatus(pack, REBUILD_FAILED);
          this.setRebuildFailureOutput(pack, buildFailureOutput);
        }
      }

      this.loaded = true;
      _etch2['default'].update(this);
    }
  }, {
    key: 'rebuildIncompatiblePackages',
    value: _asyncToGenerator(function* () {
      this.rebuildInProgress = true;
      var rebuiltPackageCount = 0;
      for (var pack of this.incompatiblePackages) {
        this.setPackageStatus(pack, REBUILDING);

        var _ref = yield pack.rebuild();

        var code = _ref.code;
        var stderr = _ref.stderr;

        if (code === 0) {
          this.setPackageStatus(pack, REBUILD_SUCCEEDED);
          rebuiltPackageCount++;
        } else {
          this.setRebuildFailureOutput(pack, stderr);
          this.setPackageStatus(pack, REBUILD_FAILED);
        }
      }
      this.rebuildInProgress = false;
      this.rebuiltPackageCount = rebuiltPackageCount;
      _etch2['default'].update(this);
    })
  }, {
    key: 'setPackageStatus',
    value: function setPackageStatus(pack, status) {
      this.rebuildStatuses.set(pack, status);
      _etch2['default'].update(this);
    }
  }, {
    key: 'setRebuildFailureOutput',
    value: function setRebuildFailureOutput(pack, output) {
      this.rebuildFailureOutputs.set(pack, output);
      _etch2['default'].update(this);
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Incompatible Packages';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return _viewUri2['default'];
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'package';
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return { deserializer: 'IncompatiblePackagesComponent' };
    }
  }]);

  return IncompatiblePackagesComponent;
})();

exports['default'] = IncompatiblePackagesComponent;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9ob21lL3RyYXZpcy9idWlsZC9hdG9tL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvaW5jb21wYXRpYmxlLXBhY2thZ2VzL2xpYi9pbmNvbXBhdGlibGUtcGFja2FnZXMtY29tcG9uZW50LmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7OztvQkFHOEIsTUFBTTs7b0JBQ25CLE1BQU07Ozs7dUJBRUYsWUFBWTs7OztBQUNqQyxJQUFNLFVBQVUsR0FBRyxZQUFZLENBQUE7QUFDL0IsSUFBTSxjQUFjLEdBQUcsZ0JBQWdCLENBQUE7QUFDdkMsSUFBTSxpQkFBaUIsR0FBRyxtQkFBbUIsQ0FBQTs7SUFFeEIsNkJBQTZCO0FBQ3BDLFdBRE8sNkJBQTZCLENBQ25DLGNBQWMsRUFBRTs7OzBCQURWLDZCQUE2Qjs7QUFFOUMsUUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLEdBQUcsRUFBQSxDQUFBO0FBQzlCLFFBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLEdBQUcsRUFBQSxDQUFBO0FBQ3BDLFFBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUE7QUFDOUIsUUFBSSxDQUFDLG1CQUFtQixHQUFHLENBQUMsQ0FBQTtBQUM1QixRQUFJLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQTtBQUNwQyxRQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQTtBQUNuQixzQkFBSyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUE7O0FBRXJCLFFBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7QUFDdEQsVUFBSSxDQUFDLDRCQUE0QixFQUFFLENBQUE7S0FDcEMsTUFBTTtBQUNMLFlBQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLDRCQUE0QixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFBO0tBQ2xFOztBQUVELFFBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLFVBQUMsS0FBSyxFQUFLO0FBQ2hELFVBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxNQUFLLElBQUksQ0FBQyxhQUFhLEVBQUU7QUFDNUMsY0FBSywyQkFBMkIsRUFBRSxDQUFBO09BQ25DLE1BQU0sSUFBSSxLQUFLLENBQUMsTUFBTSxLQUFLLE1BQUssSUFBSSxDQUFDLFlBQVksRUFBRTtBQUNsRCxZQUFJLENBQUMsTUFBTSxFQUFFLENBQUE7T0FDZCxNQUFNLElBQUksS0FBSyxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQyxFQUFFO0FBQzNELFlBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSw2QkFBMkIsS0FBSyxDQUFDLE1BQU0sV0FBUSxDQUFDLElBQUksQ0FBRyxDQUFBO09BQzNFO0tBQ0YsQ0FBQyxDQUFBO0dBQ0g7O2VBekJrQiw2QkFBNkI7O1dBMkJ6QyxrQkFBRyxFQUFFOzs7V0FFTCxrQkFBRztBQUNSLFVBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFO0FBQ2hCLGVBQU87O1lBQUssU0FBUyxFQUFDLDhCQUE4Qjs7U0FBaUIsQ0FBQTtPQUN0RTs7QUFFRCxhQUNFOztVQUFLLFNBQVMsRUFBQyxrREFBa0QsRUFBQyxRQUFRLEVBQUMsSUFBSTtRQUM1RSxJQUFJLENBQUMsYUFBYSxFQUFFO1FBQ3BCLElBQUksQ0FBQyw2QkFBNkIsRUFBRTtPQUNqQyxDQUNQO0tBQ0Y7OztXQUVhLHlCQUFHO0FBQ2YsVUFBSSxJQUFJLENBQUMsb0JBQW9CLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtBQUN4QyxZQUFJLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxDQUFDLEVBQUU7QUFDaEMsY0FBSSxVQUFVLEdBQ1osQUFBQyxJQUFJLENBQUMsbUJBQW1CLEtBQUssSUFBSSxDQUFDLG9CQUFvQixDQUFDLE1BQU0sR0FDMUQsMEJBQTBCLEdBQzFCLHdCQUF3QixDQUFBOztBQUU5QixpQkFDRTs7Y0FBSyxTQUFTLEVBQUUsYUFBYSxHQUFHLFVBQVUsQUFBQztZQUN4QyxJQUFJLENBQUMsbUJBQW1COztZQUFNLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNOztZQUcvRDs7Z0JBQVEsR0FBRyxFQUFDLGNBQWMsRUFBQyxTQUFTLEVBQUMsZ0JBQWdCOzthQUU1QztXQUNMLENBQ1A7U0FDRixNQUFNO0FBQ0wsaUJBQ0U7O2NBQUssU0FBUyxFQUFDLGtDQUFrQzs7WUFJL0M7O2dCQUFRLEdBQUcsRUFBQyxlQUFlLEVBQUMsU0FBUyxFQUFDLGdCQUFnQixFQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsaUJBQWlCLEFBQUM7O2FBRS9FO1dBQ0wsQ0FDUDtTQUNGO09BQ0YsTUFBTTtBQUNMLGVBQ0U7O1lBQUssU0FBUyxFQUFDLHFDQUFxQzs7U0FFOUMsQ0FDUDtPQUNGO0tBQ0Y7OztXQUU2Qix5Q0FBRztBQUMvQixhQUNFOzs7UUFDRSxJQUFJLENBQUMsb0JBQW9CLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7T0FDbkUsQ0FDUjtLQUNGOzs7V0FFeUIsbUNBQUMsSUFBSSxFQUFFO0FBQy9CLFVBQUksYUFBYSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFBOztBQUVsRCxhQUNFOztVQUFLLFNBQVMsRUFBRSxzQkFBc0IsQUFBQztRQUNwQyxJQUFJLENBQUMsNEJBQTRCLENBQUMsYUFBYSxDQUFDO1FBQ2pEOztZQUFRLFNBQVMsRUFBQyw2Q0FBNkMsRUFBQyxXQUFTLElBQUksQUFBQzs7U0FBMEI7UUFDeEc7O1lBQUksU0FBUyxFQUFDLFNBQVM7VUFDcEIsSUFBSSxDQUFDLElBQUk7O1VBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPO1NBQy9CO1FBRUgsYUFBYSxHQUNYLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsR0FDOUIsSUFBSSxDQUFDLHlCQUF5QixDQUFDLElBQUksQ0FBQztPQUVwQyxDQUNQO0tBQ0Y7OztXQUU0QixzQ0FBQyxhQUFhLEVBQUU7QUFDM0MsVUFBSSxhQUFhLEtBQUssVUFBVSxFQUFFO0FBQ2hDLGVBQ0U7O1lBQUssU0FBUyxFQUFDLDRDQUE0Qzs7U0FFckQsQ0FDUDtPQUNGLE1BQU0sSUFBSSxhQUFhLEtBQUssaUJBQWlCLEVBQUU7QUFDOUMsZUFDRTs7WUFBSyxTQUFTLEVBQUMsZ0RBQWdEOztTQUV6RCxDQUNQO09BQ0YsTUFBTSxJQUFJLGFBQWEsS0FBSyxjQUFjLEVBQUU7QUFDM0MsZUFDRTs7WUFBSyxTQUFTLEVBQUMsMENBQTBDOztTQUVuRCxDQUNQO09BQ0YsTUFBTTtBQUNMLGVBQU8sRUFBRSxDQUFBO09BQ1Y7S0FDRjs7O1dBRW1CLDZCQUFDLElBQUksRUFBRTtBQUN6QixVQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLGNBQWMsRUFBRTtBQUNyRCxlQUFPOzs7VUFBTSxJQUFJLENBQUMscUJBQXFCLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQztTQUFPLENBQUE7T0FDekQsTUFBTTtBQUNMLGVBQU8sRUFBRSxDQUFBO09BQ1Y7S0FDRjs7O1dBRXlCLG1DQUFDLElBQUksRUFBRTtBQUMvQixhQUNFOzs7UUFDRSxJQUFJLENBQUMsbUJBQW1CLENBQUMsR0FBRyxDQUFDLFVBQUMsWUFBWTtpQkFDeEM7OztZQUNFOztnQkFBSyxTQUFTLEVBQUMsdUJBQXVCO2NBQ25DLFlBQVksQ0FBQyxJQUFJOztjQUFHLFlBQVksQ0FBQyxPQUFPLElBQUksU0FBUzs7Y0FBSTs7a0JBQU0sU0FBUyxFQUFDLGNBQWM7Z0JBQUUsWUFBWSxDQUFDLEtBQUs7ZUFBUTthQUNoSDtXQUNIO1NBQUEsQ0FDTjtPQUNHLENBQ1A7S0FDRjs7O1dBRTRCLHdDQUFHO0FBQzlCLFVBQUksQ0FBQyxvQkFBb0IsR0FDdkIsSUFBSSxDQUFDLGNBQWMsQ0FDaEIsaUJBQWlCLEVBQUUsQ0FDbkIsTUFBTSxDQUFDLFVBQUEsSUFBSTtlQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksRUFBRTtPQUFBLENBQUMsQ0FBQTs7QUFFekMsV0FBSyxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsb0JBQW9CLEVBQUU7QUFDMUMsWUFBSSxrQkFBa0IsR0FBRyxJQUFJLENBQUMscUJBQXFCLEVBQUUsQ0FBQTtBQUNyRCxZQUFJLGtCQUFrQixFQUFFO0FBQ3RCLGNBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsY0FBYyxDQUFDLENBQUE7QUFDM0MsY0FBSSxDQUFDLHVCQUF1QixDQUFDLElBQUksRUFBRSxrQkFBa0IsQ0FBQyxDQUFBO1NBQ3ZEO09BQ0Y7O0FBRUQsVUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUE7QUFDbEIsd0JBQUssTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQ2xCOzs7NkJBRWlDLGFBQUc7QUFDbkMsVUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQTtBQUM3QixVQUFJLG1CQUFtQixHQUFHLENBQUMsQ0FBQTtBQUMzQixXQUFLLElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxvQkFBb0IsRUFBRTtBQUMxQyxZQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFBOzttQkFDbEIsTUFBTSxJQUFJLENBQUMsT0FBTyxFQUFFOztZQUFwQyxJQUFJLFFBQUosSUFBSTtZQUFFLE1BQU0sUUFBTixNQUFNOztBQUNqQixZQUFJLElBQUksS0FBSyxDQUFDLEVBQUU7QUFDZCxjQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLGlCQUFpQixDQUFDLENBQUE7QUFDOUMsNkJBQW1CLEVBQUUsQ0FBQTtTQUN0QixNQUFNO0FBQ0wsY0FBSSxDQUFDLHVCQUF1QixDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQTtBQUMxQyxjQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLGNBQWMsQ0FBQyxDQUFBO1NBQzVDO09BQ0Y7QUFDRCxVQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFBO0FBQzlCLFVBQUksQ0FBQyxtQkFBbUIsR0FBRyxtQkFBbUIsQ0FBQTtBQUM5Qyx3QkFBSyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDbEI7OztXQUVnQiwwQkFBQyxJQUFJLEVBQUUsTUFBTSxFQUFFO0FBQzlCLFVBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQTtBQUN0Qyx3QkFBSyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDbEI7OztXQUV1QixpQ0FBQyxJQUFJLEVBQUUsTUFBTSxFQUFFO0FBQ3JDLFVBQUksQ0FBQyxxQkFBcUIsQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBQzVDLHdCQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUNsQjs7O1dBRVEsb0JBQUc7QUFDVixhQUFPLHVCQUF1QixDQUFBO0tBQy9COzs7V0FFTSxrQkFBRztBQUNSLGtDQUFlO0tBQ2hCOzs7V0FFVyx1QkFBRztBQUNiLGFBQU8sU0FBUyxDQUFBO0tBQ2pCOzs7V0FFUyxxQkFBRztBQUNYLGFBQU8sRUFBQyxZQUFZLEVBQUUsK0JBQStCLEVBQUMsQ0FBQTtLQUN2RDs7O1NBdk5rQiw2QkFBNkI7OztxQkFBN0IsNkJBQTZCIiwiZmlsZSI6Ii9ob21lL3RyYXZpcy9idWlsZC9hdG9tL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvaW5jb21wYXRpYmxlLXBhY2thZ2VzL2xpYi9pbmNvbXBhdGlibGUtcGFja2FnZXMtY29tcG9uZW50LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuLyoqIEBqc3ggZXRjaC5kb20gKi9cblxuaW1wb3J0IHtCdWZmZXJlZFByb2Nlc3N9IGZyb20gJ2F0b20nXG5pbXBvcnQgZXRjaCBmcm9tICdldGNoJ1xuXG5pbXBvcnQgVklFV19VUkkgZnJvbSAnLi92aWV3LXVyaSdcbmNvbnN0IFJFQlVJTERJTkcgPSAncmVidWlsZGluZydcbmNvbnN0IFJFQlVJTERfRkFJTEVEID0gJ3JlYnVpbGQtZmFpbGVkJ1xuY29uc3QgUkVCVUlMRF9TVUNDRUVERUQgPSAncmVidWlsZC1zdWNjZWVkZWQnXG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEluY29tcGF0aWJsZVBhY2thZ2VzQ29tcG9uZW50IHtcbiAgY29uc3RydWN0b3IgKHBhY2thZ2VNYW5hZ2VyKSB7XG4gICAgdGhpcy5yZWJ1aWxkU3RhdHVzZXMgPSBuZXcgTWFwXG4gICAgdGhpcy5yZWJ1aWxkRmFpbHVyZU91dHB1dHMgPSBuZXcgTWFwXG4gICAgdGhpcy5yZWJ1aWxkSW5Qcm9ncmVzcyA9IGZhbHNlXG4gICAgdGhpcy5yZWJ1aWx0UGFja2FnZUNvdW50ID0gMFxuICAgIHRoaXMucGFja2FnZU1hbmFnZXIgPSBwYWNrYWdlTWFuYWdlclxuICAgIHRoaXMubG9hZGVkID0gZmFsc2VcbiAgICBldGNoLmluaXRpYWxpemUodGhpcylcblxuICAgIGlmICh0aGlzLnBhY2thZ2VNYW5hZ2VyLmdldEFjdGl2ZVBhY2thZ2VzKCkubGVuZ3RoID4gMCkge1xuICAgICAgdGhpcy5wb3B1bGF0ZUluY29tcGF0aWJsZVBhY2thZ2VzKClcbiAgICB9IGVsc2Uge1xuICAgICAgZ2xvYmFsLnNldEltbWVkaWF0ZSh0aGlzLnBvcHVsYXRlSW5jb21wYXRpYmxlUGFja2FnZXMuYmluZCh0aGlzKSlcbiAgICB9XG5cbiAgICB0aGlzLmVsZW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCAoZXZlbnQpID0+IHtcbiAgICAgIGlmIChldmVudC50YXJnZXQgPT09IHRoaXMucmVmcy5yZWJ1aWxkQnV0dG9uKSB7XG4gICAgICAgIHRoaXMucmVidWlsZEluY29tcGF0aWJsZVBhY2thZ2VzKClcbiAgICAgIH0gZWxzZSBpZiAoZXZlbnQudGFyZ2V0ID09PSB0aGlzLnJlZnMucmVsb2FkQnV0dG9uKSB7XG4gICAgICAgIGF0b20ucmVsb2FkKClcbiAgICAgIH0gZWxzZSBpZiAoZXZlbnQudGFyZ2V0LmNsYXNzTGlzdC5jb250YWlucygndmlldy1zZXR0aW5ncycpKSB7XG4gICAgICAgIGF0b20ud29ya3NwYWNlLm9wZW4oYGF0b206Ly9jb25maWcvcGFja2FnZXMvJHtldmVudC50YXJnZXQucGFja2FnZS5uYW1lfWApXG4gICAgICB9XG4gICAgfSlcbiAgfVxuXG4gIHVwZGF0ZSAoKSB7fVxuXG4gIHJlbmRlciAoKSB7XG4gICAgaWYgKCF0aGlzLmxvYWRlZCkge1xuICAgICAgcmV0dXJuIDxkaXYgY2xhc3NOYW1lPSdpbmNvbXBhdGlibGUtcGFja2FnZXMgcGFkZGVkJz5Mb2FkaW5nLi4uPC9kaXY+XG4gICAgfVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPSdpbmNvbXBhdGlibGUtcGFja2FnZXMgcGFkZGVkIG5hdGl2ZS1rZXktYmluZGluZ3MnIHRhYkluZGV4PSctMSc+XG4gICAgICAgIHt0aGlzLnJlbmRlckhlYWRpbmcoKX1cbiAgICAgICAge3RoaXMucmVuZGVySW5jb21wYXRpYmxlUGFja2FnZUxpc3QoKX1cbiAgICAgIDwvZGl2PlxuICAgIClcbiAgfVxuXG4gIHJlbmRlckhlYWRpbmcgKCkge1xuICAgIGlmICh0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzLmxlbmd0aCA+IDApIHtcbiAgICAgIGlmICh0aGlzLnJlYnVpbHRQYWNrYWdlQ291bnQgPiAwKSB7XG4gICAgICAgIGxldCBhbGVydENsYXNzID1cbiAgICAgICAgICAodGhpcy5yZWJ1aWx0UGFja2FnZUNvdW50ID09PSB0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzLmxlbmd0aClcbiAgICAgICAgICAgID8gJ2FsZXJ0LXN1Y2Nlc3MgaWNvbi1jaGVjaydcbiAgICAgICAgICAgIDogJ2FsZXJ0LXdhcm5pbmcgaWNvbi1idWcnXG5cbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT17J2FsZXJ0IGljb24gJyArIGFsZXJ0Q2xhc3N9PlxuICAgICAgICAgICAge3RoaXMucmVidWlsdFBhY2thZ2VDb3VudH0gb2Yge3RoaXMuaW5jb21wYXRpYmxlUGFja2FnZXMubGVuZ3RofSBwYWNrYWdlc1xuICAgICAgICAgICAgd2VyZSByZWJ1aWx0IHN1Y2Nlc3NmdWxseS4gUmVsb2FkIEF0b20gdG8gYWN0aXZhdGUgdGhlbS5cblxuICAgICAgICAgICAgPGJ1dHRvbiByZWY9J3JlbG9hZEJ1dHRvbicgY2xhc3NOYW1lPSdidG4gcHVsbC1yaWdodCc+XG4gICAgICAgICAgICAgIFJlbG9hZCBBdG9tXG4gICAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgKVxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYWxlcnQgYWxlcnQtZGFuZ2VyIGljb24gaWNvbi1idWcnPlxuICAgICAgICAgICAgU29tZSBpbnN0YWxsZWQgcGFja2FnZXMgY291bGQgbm90IGJlIGxvYWRlZCBiZWNhdXNlIHRoZXkgY29udGFpbiBuYXRpdmVcbiAgICAgICAgICAgIG1vZHVsZXMgdGhhdCB3ZXJlIGNvbXBpbGVkIGZvciBhbiBlYXJsaWVyIHZlcnNpb24gb2YgQXRvbS5cblxuICAgICAgICAgICAgPGJ1dHRvbiByZWY9J3JlYnVpbGRCdXR0b24nIGNsYXNzTmFtZT0nYnRuIHB1bGwtcmlnaHQnIGRpc2FibGVkPXt0aGlzLnJlYnVpbGRJblByb2dyZXNzfT5cbiAgICAgICAgICAgICAgUmVidWlsZCBQYWNrYWdlc1xuICAgICAgICAgICAgPC9idXR0b24+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIClcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J2FsZXJ0IGFsZXJ0LXN1Y2Nlc3MgaWNvbiBpY29uLWNoZWNrJz5cbiAgICAgICAgICBOb25lIG9mIHlvdXIgcGFja2FnZXMgY29udGFpbiBpbmNvbXBhdGlibGUgbmF0aXZlIG1vZHVsZXMuXG4gICAgICAgIDwvZGl2PlxuICAgICAgKVxuICAgIH1cbiAgfVxuXG4gIHJlbmRlckluY29tcGF0aWJsZVBhY2thZ2VMaXN0ICgpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdj57XG4gICAgICAgIHRoaXMuaW5jb21wYXRpYmxlUGFja2FnZXMubWFwKHRoaXMucmVuZGVySW5jb21wYXRpYmxlUGFja2FnZS5iaW5kKHRoaXMpKVxuICAgICAgfTwvZGl2PlxuICAgIClcbiAgfVxuXG4gIHJlbmRlckluY29tcGF0aWJsZVBhY2thZ2UgKHBhY2spIHtcbiAgICBsZXQgcmVidWlsZFN0YXR1cyA9IHRoaXMucmVidWlsZFN0YXR1c2VzLmdldChwYWNrKVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPXsnaW5jb21wYXRpYmxlLXBhY2thZ2UnfT5cbiAgICAgICAge3RoaXMucmVuZGVyUmVidWlsZFN0YXR1c0luZGljYXRvcihyZWJ1aWxkU3RhdHVzKX1cbiAgICAgICAgPGJ1dHRvbiBjbGFzc05hbWU9J2J0biB2aWV3LXNldHRpbmdzIGljb24gaWNvbi1nZWFyIHB1bGwtcmlnaHQnIHBhY2thZ2U9e3BhY2t9PlBhY2thZ2UgU2V0dGluZ3M8L2J1dHRvbj5cbiAgICAgICAgPGg0IGNsYXNzTmFtZT0naGVhZGluZyc+XG4gICAgICAgICAge3BhY2submFtZX0ge3BhY2subWV0YWRhdGEudmVyc2lvbn1cbiAgICAgICAgPC9oND5cbiAgICAgICAge1xuICAgICAgICAgIHJlYnVpbGRTdGF0dXNcbiAgICAgICAgICA/IHRoaXMucmVuZGVyUmVidWlsZE91dHB1dChwYWNrKVxuICAgICAgICAgIDogdGhpcy5yZW5kZXJJbmNvbXBhdGlibGVNb2R1bGVzKHBhY2spXG4gICAgICAgIH1cbiAgICAgIDwvZGl2PlxuICAgIClcbiAgfVxuXG4gIHJlbmRlclJlYnVpbGRTdGF0dXNJbmRpY2F0b3IgKHJlYnVpbGRTdGF0dXMpIHtcbiAgICBpZiAocmVidWlsZFN0YXR1cyA9PT0gUkVCVUlMRElORykge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J2JhZGdlIGJhZGdlLWluZm8gcHVsbC1yaWdodCBpY29uIGljb24tZ2Vhcic+XG4gICAgICAgICAgUmVidWlsZGluZ1xuICAgICAgICA8L2Rpdj5cbiAgICAgIClcbiAgICB9IGVsc2UgaWYgKHJlYnVpbGRTdGF0dXMgPT09IFJFQlVJTERfU1VDQ0VFREVEKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYmFkZ2UgYmFkZ2Utc3VjY2VzcyBwdWxsLXJpZ2h0IGljb24gaWNvbi1jaGVjayc+XG4gICAgICAgICAgUmVidWlsZCBTdWNjZWVkZWRcbiAgICAgICAgPC9kaXY+XG4gICAgICApXG4gICAgfSBlbHNlIGlmIChyZWJ1aWxkU3RhdHVzID09PSBSRUJVSUxEX0ZBSUxFRCkge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J2JhZGdlIGJhZGdlLWVycm9yIHB1bGwtcmlnaHQgaWNvbiBpY29uLXgnPlxuICAgICAgICAgIFJlYnVpbGQgRmFpbGVkXG4gICAgICAgIDwvZGl2PlxuICAgICAgKVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gJydcbiAgICB9XG4gIH1cblxuICByZW5kZXJSZWJ1aWxkT3V0cHV0IChwYWNrKSB7XG4gICAgaWYgKHRoaXMucmVidWlsZFN0YXR1c2VzLmdldChwYWNrKSA9PT0gUkVCVUlMRF9GQUlMRUQpIHtcbiAgICAgIHJldHVybiA8cHJlPnt0aGlzLnJlYnVpbGRGYWlsdXJlT3V0cHV0cy5nZXQocGFjayl9PC9wcmU+XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnJ1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlckluY29tcGF0aWJsZU1vZHVsZXMgKHBhY2spIHtcbiAgICByZXR1cm4gKFxuICAgICAgPHVsPntcbiAgICAgICAgcGFjay5pbmNvbXBhdGlibGVNb2R1bGVzLm1hcCgobmF0aXZlTW9kdWxlKSA9PlxuICAgICAgICAgIDxsaT5cbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdpY29uIGljb24tZmlsZS1iaW5hcnknPlxuICAgICAgICAgICAgICB7bmF0aXZlTW9kdWxlLm5hbWV9QHtuYXRpdmVNb2R1bGUudmVyc2lvbiB8fCAndW5rbm93bid9IOKAkyA8c3BhbiBjbGFzc05hbWU9J3RleHQtd2FybmluZyc+e25hdGl2ZU1vZHVsZS5lcnJvcn08L3NwYW4+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8L2xpPlxuICAgICAgICApXG4gICAgICB9PC91bD5cbiAgICApXG4gIH1cblxuICBwb3B1bGF0ZUluY29tcGF0aWJsZVBhY2thZ2VzICgpIHtcbiAgICB0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzID1cbiAgICAgIHRoaXMucGFja2FnZU1hbmFnZXJcbiAgICAgICAgLmdldExvYWRlZFBhY2thZ2VzKClcbiAgICAgICAgLmZpbHRlcihwYWNrID0+ICFwYWNrLmlzQ29tcGF0aWJsZSgpKVxuXG4gICAgZm9yIChsZXQgcGFjayBvZiB0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzKSB7XG4gICAgICBsZXQgYnVpbGRGYWlsdXJlT3V0cHV0ID0gcGFjay5nZXRCdWlsZEZhaWx1cmVPdXRwdXQoKVxuICAgICAgaWYgKGJ1aWxkRmFpbHVyZU91dHB1dCkge1xuICAgICAgICB0aGlzLnNldFBhY2thZ2VTdGF0dXMocGFjaywgUkVCVUlMRF9GQUlMRUQpXG4gICAgICAgIHRoaXMuc2V0UmVidWlsZEZhaWx1cmVPdXRwdXQocGFjaywgYnVpbGRGYWlsdXJlT3V0cHV0KVxuICAgICAgfVxuICAgIH1cblxuICAgIHRoaXMubG9hZGVkID0gdHJ1ZVxuICAgIGV0Y2gudXBkYXRlKHRoaXMpXG4gIH1cblxuICBhc3luYyByZWJ1aWxkSW5jb21wYXRpYmxlUGFja2FnZXMgKCkge1xuICAgIHRoaXMucmVidWlsZEluUHJvZ3Jlc3MgPSB0cnVlXG4gICAgbGV0IHJlYnVpbHRQYWNrYWdlQ291bnQgPSAwXG4gICAgZm9yIChsZXQgcGFjayBvZiB0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzKSB7XG4gICAgICB0aGlzLnNldFBhY2thZ2VTdGF0dXMocGFjaywgUkVCVUlMRElORylcbiAgICAgIGxldCB7Y29kZSwgc3RkZXJyfSA9IGF3YWl0IHBhY2sucmVidWlsZCgpXG4gICAgICBpZiAoY29kZSA9PT0gMCkge1xuICAgICAgICB0aGlzLnNldFBhY2thZ2VTdGF0dXMocGFjaywgUkVCVUlMRF9TVUNDRUVERUQpXG4gICAgICAgIHJlYnVpbHRQYWNrYWdlQ291bnQrK1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5zZXRSZWJ1aWxkRmFpbHVyZU91dHB1dChwYWNrLCBzdGRlcnIpXG4gICAgICAgIHRoaXMuc2V0UGFja2FnZVN0YXR1cyhwYWNrLCBSRUJVSUxEX0ZBSUxFRClcbiAgICAgIH1cbiAgICB9XG4gICAgdGhpcy5yZWJ1aWxkSW5Qcm9ncmVzcyA9IGZhbHNlXG4gICAgdGhpcy5yZWJ1aWx0UGFja2FnZUNvdW50ID0gcmVidWlsdFBhY2thZ2VDb3VudFxuICAgIGV0Y2gudXBkYXRlKHRoaXMpXG4gIH1cblxuICBzZXRQYWNrYWdlU3RhdHVzIChwYWNrLCBzdGF0dXMpIHtcbiAgICB0aGlzLnJlYnVpbGRTdGF0dXNlcy5zZXQocGFjaywgc3RhdHVzKVxuICAgIGV0Y2gudXBkYXRlKHRoaXMpXG4gIH1cblxuICBzZXRSZWJ1aWxkRmFpbHVyZU91dHB1dCAocGFjaywgb3V0cHV0KSB7XG4gICAgdGhpcy5yZWJ1aWxkRmFpbHVyZU91dHB1dHMuc2V0KHBhY2ssIG91dHB1dClcbiAgICBldGNoLnVwZGF0ZSh0aGlzKVxuICB9XG5cbiAgZ2V0VGl0bGUgKCkge1xuICAgIHJldHVybiAnSW5jb21wYXRpYmxlIFBhY2thZ2VzJ1xuICB9XG5cbiAgZ2V0VVJJICgpIHtcbiAgICByZXR1cm4gVklFV19VUklcbiAgfVxuXG4gIGdldEljb25OYW1lICgpIHtcbiAgICByZXR1cm4gJ3BhY2thZ2UnXG4gIH1cblxuICBzZXJpYWxpemUgKCkge1xuICAgIHJldHVybiB7ZGVzZXJpYWxpemVyOiAnSW5jb21wYXRpYmxlUGFja2FnZXNDb21wb25lbnQnfVxuICB9XG59XG4iXX0=