'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp, _class3, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _simpleTooltip = require('./simple-tooltip');

var _simpleTooltip2 = _interopRequireDefault(_simpleTooltip);

var _contextMenuInterceptor = require('../context-menu-interceptor');

var _contextMenuInterceptor2 = _interopRequireDefault(_contextMenuInterceptor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let HunkView = (_class = (_temp = _class2 = class HunkView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.lineElements = new WeakMap();
    this.lastMousemoveLine = null;
  }

  render() {
    const hunkSelectedClass = this.props.isSelected ? 'is-selected' : '';
    const hunkModeClass = this.props.hunkSelectionMode ? 'is-hunkMode' : '';

    return _react2.default.createElement(
      'div',
      { className: `github-HunkView ${hunkModeClass} ${hunkSelectedClass}`, ref: e => {
          this.element = e;
        } },
      _react2.default.createElement(
        'div',
        { className: 'github-HunkView-header',
          onMouseDown: e => this.props.mousedownOnHeader(e) },
        _react2.default.createElement(
          'span',
          { className: 'github-HunkView-title' },
          this.props.hunk.getHeader().trim(),
          ' ',
          this.props.hunk.getSectionHeading().trim()
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'github-HunkView-stageButton',
            onClick: this.props.didClickStageButton,
            onMouseDown: event => event.stopPropagation() },
          this.props.stageButtonLabel
        ),
        this.props.unstaged && _react2.default.createElement(
          _simpleTooltip2.default,
          {
            tooltips: this.props.tooltips,
            title: this.props.discardButtonLabel },
          _react2.default.createElement('button', {
            className: 'icon-trashcan github-HunkView-discardButton',
            onClick: this.props.didClickDiscardButton,
            onMouseDown: event => event.stopPropagation()
          })
        )
      ),
      this.props.hunk.getLines().map((line, idx) => _react2.default.createElement(LineView, {
        key: idx,
        line: line,
        isSelected: this.props.selectedLines.has(line),
        registerLineElement: this.registerLineElement,
        mousedown: this.mousedownOnLine,
        mousemove: this.mousemoveOnLine,
        contextMenuOnItem: (e, clickedLine) => this.props.contextMenuOnItem(e, this.props.hunk, clickedLine)
      }))
    );
  }

  mousedownOnLine(event, line) {
    this.props.mousedownOnLine(event, this.props.hunk, line);
  }

  mousemoveOnLine(event, line) {
    if (line !== this.lastMousemoveLine) {
      this.lastMousemoveLine = line;
      this.props.mousemoveOnLine(event, this.props.hunk, line);
    }
  }

  registerLineElement(line, element) {
    this.lineElements.set(line, element);
  }

  componentDidUpdate() {
    const selectedLine = Array.from(this.props.selectedLines)[0];
    if (selectedLine && this.lineElements.get(selectedLine)) {
      // QUESTION: why is this setTimeout needed?
      const element = this.lineElements.get(selectedLine);
      setTimeout(() => {
        element.scrollIntoViewIfNeeded();
      }, 0);
    } else if (this.props.headHunk === this.props.hunk) {
      this.element.scrollIntoViewIfNeeded();
    } else if (this.props.headLine && this.lineElements.has(this.props.headLine)) {
      this.lineElements.get(this.props.headLine).scrollIntoViewIfNeeded();
    }
  }
}, _class2.propTypes = {
  tooltips: _propTypes2.default.object.isRequired,
  hunk: _propTypes2.default.object.isRequired,
  headHunk: _propTypes2.default.object,
  headLine: _propTypes2.default.object,
  isSelected: _propTypes2.default.bool.isRequired,
  selectedLines: _propTypes2.default.instanceOf(Set).isRequired,
  hunkSelectionMode: _propTypes2.default.bool.isRequired,
  stageButtonLabel: _propTypes2.default.string.isRequired,
  discardButtonLabel: _propTypes2.default.string.isRequired,
  unstaged: _propTypes2.default.bool.isRequired,
  mousedownOnHeader: _propTypes2.default.func.isRequired,
  mousedownOnLine: _propTypes2.default.func.isRequired,
  mousemoveOnLine: _propTypes2.default.func.isRequired,
  contextMenuOnItem: _propTypes2.default.func.isRequired,
  didClickStageButton: _propTypes2.default.func.isRequired,
  didClickDiscardButton: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'mousedownOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousedownOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousemoveOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousemoveOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'registerLineElement', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'registerLineElement'), _class.prototype)), _class);
exports.default = HunkView;
let LineView = (_temp2 = _class3 = class LineView extends _react2.default.Component {

  render() {
    const line = this.props.line;
    const oldLineNumber = line.getOldLineNumber() === -1 ? ' ' : line.getOldLineNumber();
    const newLineNumber = line.getNewLineNumber() === -1 ? ' ' : line.getNewLineNumber();
    const lineSelectedClass = this.props.isSelected ? 'is-selected' : '';

    return _react2.default.createElement(
      _contextMenuInterceptor2.default,
      { onWillShowContextMenu: event => this.props.contextMenuOnItem(event, line) },
      _react2.default.createElement(
        'div',
        {
          className: `github-HunkView-line ${lineSelectedClass} is-${line.getStatus()}`,
          onMouseDown: event => this.props.mousedown(event, line),
          onMouseMove: event => this.props.mousemove(event, line),
          ref: e => this.props.registerLineElement(line, e) },
        _react2.default.createElement(
          'div',
          { className: 'github-HunkView-lineNumber is-old' },
          oldLineNumber
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-HunkView-lineNumber is-new' },
          newLineNumber
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-HunkView-lineContent' },
          _react2.default.createElement(
            'span',
            { className: 'github-HunkView-plusMinus' },
            line.getOrigin()
          ),
          _react2.default.createElement(
            'span',
            null,
            line.getText()
          )
        )
      )
    );
  }
}, _class3.propTypes = {
  line: _propTypes2.default.object.isRequired,
  isSelected: _propTypes2.default.bool.isRequired,
  mousedown: _propTypes2.default.func.isRequired,
  mousemove: _propTypes2.default.func.isRequired,
  contextMenuOnItem: _propTypes2.default.func.isRequired,
  registerLineElement: _propTypes2.default.func.isRequired
}, _temp2);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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