'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * `EtchWrapper` is a React component that renders Etch components
 * and correctly manages their lifecycles as the application progresses.
 *
 *    <EtchWrapper type="span" reattachDomNode={true} className="wrapper">
 *      <EtchComponent etchProp={stuff} />
 *    </EtchWrapper>
 *
 * The `type` property specifies the DOM node type to wrap around the
 * Etch component's element, and defaults to 'div'. Any other props you
 * pass to the wrapper component will be applied to the DOM node.
 *
 * `reattachDomNode` determines whether or not to place the wrapped component
 * element back in the React component's DOM node if we find it's missing;
 * this could happen due to changing the `type` property. If you pass the
 * wrapped component element into a method that moves the element, you should
 * specify `false` for this option.
 *
 * The component takes a single JSX child, which describes the type and props
 * of the Etch component to render. Any time this changes, the wrapper will
 * update (or destroy and recreate) the Etch component as necessary.
 *
 * Note that the component cleans up its own DOM node, and calls
 * `component.destroy(false)` (if your component has a `destroy` method)
 * and you should pass the `false` as the second argument to
 * `etch.destroy(this)` (e.g. `etch.destroy(this, false)`) inside your
 * component instance.
 *
 * The component instance is available at `this.getWrappedComponent` if you need
 * to call methods on it from the outside (though you should really consider
 * setting a prop instead. ;)
 */
let EtchWrapper = (_temp = _class = class EtchWrapper extends _react2.default.Component {

  componentDidMount() {
    this.createComponent(this.getWrappedComponentDetails(this.props.children));
  }

  componentWillReceiveProps(newProps) {
    const oldDetails = this.getWrappedComponentDetails(this.props.children);
    const newDetails = this.getWrappedComponentDetails(newProps.children);
    if (oldDetails.type !== newDetails.type) {
      // The wrapped component type changed, so we need to destroy the old
      // component and create a new one of the new type.
      this.destroyComponent();
      this.createComponent(newDetails);
    }
  }

  componentDidUpdate(prevProps) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const oldDetails = _this.getWrappedComponentDetails(prevProps.children);
      const newDetails = _this.getWrappedComponentDetails(_this.props.children);

      if (oldDetails.type === newDetails.type) {
        // We didn't change the wrapped (Etch) component type,
        // so we need to update the instance with the new props.
        yield _this.updateComponent(_this.getWrappedComponentDetails(_this.props.children));
      }

      // If we just recreated our DOM node by changing the node type, we
      // need to reattach the wrapped component's element.
      if (_this.props.reattachDomNode && _this.container && !_this.container.contains(_this.component.element)) {
        _this.container.appendChild(_this.component.element);
      }
    })();
  }

  render() {
    const Type = this.props.type;
    var _props = this.props;

    const type = _props.type,
          children = _props.children,
          reattachDomNode = _props.reattachDomNode,
          props = _objectWithoutProperties(_props, ['type', 'children', 'reattachDomNode']); // eslint-disable-line no-unused-vars


    return _react2.default.createElement(Type, _extends({}, props, { ref: c => {
        this.container = c;
      } }));
  }

  componentWillUnmount() {
    this.destroyComponent();
  }

  getWrappedComponentDetails(ourChildren) {
    // e.g. <EtchWrapper><EtchChild prop={1} other={2}>Hi</EtchChild></EtchWrapper>
    const etchElement = _react2.default.Children.toArray(ourChildren)[0];
    // etchElement === {type: EtchChild, props: {prop: 1, other: 2, children: 'Hi'}}
    const type = etchElement.type,
          props = etchElement.props;
    // type === EtchChild, props === {prop: 1, other: 2, children: 'Hi'}

    const children = props.children,
          remainingProps = _objectWithoutProperties(props, ['children']);
    // children === 'Hi', remainingProps === {prop: 1, other: 2}


    return { type, children, props: remainingProps };
  }

  // For compatability with Atom's ViewProvider
  getElement() {
    return this.container;
  }

  // Etch component interactions

  getWrappedComponent() {
    return this.component;
  }

  createComponent(_ref) {
    let type = _ref.type,
        props = _ref.props,
        children = _ref.children;

    this.component = new type(props, children);
    this.container.appendChild(this.component.element);
  }

  updateComponent(_ref2) {
    let props = _ref2.props,
        children = _ref2.children;

    return this.component.update(props, children);
  }

  destroyComponent() {
    if (this.container.contains(this.component.element)) {
      this.container.removeChild(this.component.element);
    }
    this.component.destroy && this.component.destroy(false);
    delete this.component;
  }
}, _class.propTypes = {
  children: _propTypes2.default.element.isRequired,
  type: _propTypes2.default.string,
  reattachDomNode: _propTypes2.default.bool
}, _class.defaultProps = {
  type: 'div',
  reattachDomNode: true
}, _temp);
exports.default = EtchWrapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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