'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

var _gitShellOutStrategy = require('../git-shell-out-strategy');

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let BranchMenuView = (_class = (_temp = _class2 = class BranchMenuView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      createNew: false,
      checkingOutBranch: null
    };
  }

  componentWillReceiveProps(nextProps) {
    if (this.props.repository !== nextProps.repository) {
      this.setState({ checkingOutBranch: null });
    }
  }

  render() {
    const currentBranchName = this.state.checkingOutBranch || this.props.currentBranch.getName();
    const branchNames = this.props.branches.map(branch => branch.getName());
    if (this.state.checkingOutBranch && branchNames.indexOf(this.state.checkingOutBranch) === -1) {
      branchNames.push(this.state.checkingOutBranch);
    }

    const newBranchEditor = _react2.default.createElement(
      'div',
      { className: 'github-BranchMenuView-item github-BranchMenuView-editor' },
      _react2.default.createElement('atom-text-editor', {
        ref: e => {
          this.editorElement = e;
        },
        mini: true,
        softWrapped: true,
        placeholderText: 'enter new branch name',
        lineNumberGutterVisible: false,
        showInvisibles: false,
        scrollPastEnd: false
      })
    );

    const selectBranchView = _react2.default.createElement(
      'select',
      {
        className: 'github-BranchMenuView-item github-BranchMenuView-select input-select',
        onChange: this.didSelectItem,
        value: currentBranchName },
      this.props.currentBranch.isDetached() && _react2.default.createElement(
        'option',
        { key: 'detached', value: 'detached', disabled: true },
        this.props.currentBranch.getName()
      ),
      branchNames.map(branchName => {
        return _react2.default.createElement(
          'option',
          { key: branchName, value: branchName },
          branchName
        );
      })
    );

    return _react2.default.createElement(
      'div',
      { className: 'github-BranchMenuView' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-BranchMenuView-editor atom-text-editor[mini]' },
        _react2.default.createElement(_commands.Command, { command: 'tool-panel:unfocus', callback: this.cancelCreateNewBranch }),
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancelCreateNewBranch }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.createBranch })
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-BranchMenuView-selector' },
        _react2.default.createElement('span', { className: 'github-BranchMenuView-item icon icon-git-branch' }),
        this.state.createNew ? newBranchEditor : selectBranchView,
        _react2.default.createElement(
          'button',
          { className: 'github-BranchMenuView-item github-BranchMenuView-button btn',
            onClick: this.createBranch },
          ' New Branch '
        )
      )
    );
  }

  didSelectItem(event) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const branchName = event.target.value;
      _this.setState({ checkingOutBranch: branchName });

      try {
        yield _this.props.checkout(branchName);
      } catch (e) {
        _this.setState({ checkingOutBranch: null });
        if (!(e instanceof _gitShellOutStrategy.GitError)) {
          throw e;
        }
        if (e.stdErr.match(/local changes.*would be overwritten/)) {
          const files = e.stdErr.split(/\r?\n/).filter(function (l) {
            return l.startsWith('\t');
          }).map(function (l) {
            return `\`${l.trim()}\``;
          }).join('<br>');
          _this.props.notificationManager.addError('Checkout aborted', {
            description: 'Local changes to the following would be overwritten:<br>' + files + '<br>Please commit your changes or stash them.',
            dismissable: true
          });
        } else {
          _this.props.notificationManager.addError('Checkout aborted', { description: e.stdErr, dismissable: true });
        }
      }
      return null;
    })();
  }

  createBranch() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2.state.createNew) {
        const branchName = _this2.editorElement.getModel().getText().trim();
        try {
          yield _this2.props.checkout(branchName, { createNew: true });
          _this2.setState({ createNew: false, checkingOutBranch: branchName });
        } catch (e) {
          if (!(e instanceof _gitShellOutStrategy.GitError)) {
            throw e;
          }
          if (e.stdErr.match(/branch.*already exists/)) {
            _this2.props.notificationManager.addError('Cannot create branch', {
              description: `\`${branchName}\` already exists. Choose another branch name.`
            });
          } else if (e.stdErr.match(/error: you need to resolve your current index first/)) {
            _this2.props.notificationManager.addError('Cannot create branch', {
              description: 'You must first resolve merge conflicts.',
              dismissable: true
            });
          } else {
            _this2.props.notificationManager.addError('Cannot create branch', { description: e.stdErr, dismissable: true });
          }
          _this2.setState({ createNew: false });
        }
      } else {
        _this2.setState({ createNew: true }, function () {
          return _this2.editorElement.focus();
        });
      }
    })();
  }

  cancelCreateNewBranch() {
    this.setState({ createNew: false });
  }
}, _class2.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object,
  branches: _propTypes2.default.arrayOf(_propTypes3.BranchPropType).isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  checkout: _propTypes2.default.func
}, _class2.defaultProps = {
  checkout: () => Promise.resolve()
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'didSelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didSelectItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createBranch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createBranch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelCreateNewBranch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelCreateNewBranch'), _class.prototype)), _class);
exports.default = BranchMenuView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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