'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const relayEnvironmentPerGithubHost = new Map();

let RelayNetworkLayerManager = class RelayNetworkLayerManager {
  static getEnvironmentForHost(host, token) {
    host = host === 'github.com' ? 'https://api.github.com' : host; // eslint-disable-line no-param-reassign
    const url = host === 'https://api.github.com' ? `${host}/graphql` : `${host}/api/v3/graphql`;
    const config = relayEnvironmentPerGithubHost.get(host) || {};
    let environment = config.environment,
        networkLayer = config.networkLayer;

    if (!environment) {
      environment = new _reactRelay2.default.Environment();
      networkLayer = new _reactRelay2.default.DefaultNetworkLayer(url, {
        headers: {
          Authorization: `bearer ${token}`,
          Accept: 'application/vnd.github.graphql-profiling+json'
        }
      });
      environment.injectNetworkLayer(networkLayer);
      relayEnvironmentPerGithubHost.set(host, { environment, networkLayer });
    } else {
      networkLayer._init.headers = {
        Authorization: `bearer ${token}`
      };
    }
    return environment;
  }
};
exports.default = RelayNetworkLayerManager;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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