'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FOCUS = undefined;

var _desc, _value, _class;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _eventKit = require('event-kit');

var _nsfw = require('nsfw');

var _nsfw2 = _interopRequireDefault(_nsfw);

var _coreDecorators = require('core-decorators');

var _eventLogger = require('./event-logger');

var _eventLogger2 = _interopRequireDefault(_eventLogger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const FOCUS = exports.FOCUS = Symbol('focus');

let WorkspaceChangeObserver = (_class = class WorkspaceChangeObserver {
  constructor(window, workspace, repository) {
    this.window = window;
    this.repository = repository;
    this.workspace = workspace;
    this.observedBuffers = new WeakSet();
    this.emitter = new _eventKit.Emitter();
    this.disposables = new _eventKit.CompositeDisposable();
    this.logger = new _eventLogger2.default('workspace watcher');
    this.started = false;
  }

  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const focusHandler = function (event) {
        if (_this.repository) {
          _this.logger.showFocusEvent();
          _this.didChange([{ special: FOCUS }]);
        }
      };
      _this.window.addEventListener('focus', focusHandler);
      _this.disposables.add(_this.workspace.observeTextEditors(_this.observeTextEditor), new _eventKit.Disposable(function () {
        return _this.window.removeEventListener('focus', focusHandler);
      }));
      yield _this.watchActiveRepositoryGitDirectory();
      _this.started = true;
      return _this;
    })();
  }

  destroy() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.started = false;
      _this2.observedBuffers = new WeakSet();
      _this2.emitter.dispose();
      _this2.disposables.dispose();
      yield _this2.stopCurrentFileWatcher();
    })();
  }

  isStarted() {
    return this.started;
  }

  didChange(payload) {
    this.emitter.emit('did-change', payload);
  }

  didChangeWorkdirOrHead() {
    this.emitter.emit('did-change-workdir-or-head');
  }

  onDidChange(callback) {
    return this.emitter.on('did-change', callback);
  }

  onDidChangeWorkdirOrHead(callback) {
    return this.emitter.on('did-change-workdir-or-head', callback);
  }

  getRepository() {
    return this.repository;
  }

  watchActiveRepositoryGitDirectory() {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const repository = _this3.getRepository();
      const gitDirectoryPath = repository.getGitDirectoryPath();
      if (repository) {
        _this3.currentFileWatcher = yield (0, _nsfw2.default)(gitDirectoryPath, function (events) {
          const filteredEvents = events.filter(function (e) {
            return ['config', 'index', 'HEAD', 'MERGE_HEAD'].includes(e.file || e.newFile) || e.directory.includes(_path2.default.join('.git', 'refs'));
          });
          if (filteredEvents.length) {
            _this3.logger.showEvents(filteredEvents);
            _this3.didChange(filteredEvents);
            const workdirOrHeadEvent = filteredEvents.filter(function (e) {
              return !['config', 'index'].includes(e.file || e.newFile);
            });
            if (workdirOrHeadEvent) {
              _this3.logger.showWorkdirOrHeadEvents();
              _this3.didChangeWorkdirOrHead();
            }
          }
        }, {
          debounceMS: 100,
          errorCallback: function (errors) {
            const workingDirectory = repository.getWorkingDirectoryPath();
            // eslint-disable-next-line no-console
            console.warn(`Error in FileSystemChangeObserver in ${workingDirectory}:`, errors);
            _this3.stopCurrentFileWatcher();
          }
        });
        yield _this3.currentFileWatcher.start();
        _this3.logger.showStarted(gitDirectoryPath);
      }
    })();
  }

  stopCurrentFileWatcher() {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (_this4.currentFileWatcher) {
        yield _this4.currentFileWatcher.stop();
        _this4.currentFileWatcher = null;
        _this4.logger.showStopped();
      }
    })();
  }

  activeRepositoryContainsPath(filePath) {
    const repository = this.getRepository();
    if (filePath && repository) {
      return filePath.indexOf(repository.getWorkingDirectoryPath()) !== -1;
    } else {
      return false;
    }
  }

  observeTextEditor(editor) {
    const buffer = editor.getBuffer();
    if (!this.observedBuffers.has(buffer)) {
      const didChange = () => {
        const fullPath = buffer.getPath();
        const events = [{
          directory: _path2.default.dirname(fullPath),
          file: _path2.default.basename(fullPath)
        }];
        this.logger.showEvents(events);
        this.didChange(events);
      };

      this.observedBuffers.add(buffer);
      const disposables = new _eventKit.CompositeDisposable(buffer.onDidSave(() => {
        if (this.activeRepositoryContainsPath(buffer.getPath())) {
          didChange();
        }
      }), buffer.onDidReload(() => {
        if (this.activeRepositoryContainsPath(buffer.getPath())) {
          didChange();
        }
      }), buffer.onDidDestroy(() => {
        if (this.activeRepositoryContainsPath(buffer.getPath())) {
          didChange();
        }
        disposables.dispose();
      }));
      this.disposables.add(disposables);
    }
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'observeTextEditor', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'observeTextEditor'), _class.prototype)), _class);
exports.default = WorkspaceChangeObserver;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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