'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class;

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let StyleCalculator = (_class = class StyleCalculator {
  constructor(styles, config) {
    this.styles = styles;
    this.config = config;
  }

  startWatching(sourcePath, configsToWatch, getStylesheetFn) {
    const subscriptions = new _eventKit.CompositeDisposable();
    const updateStyles = () => {
      this.updateStyles(sourcePath, getStylesheetFn);
    };
    configsToWatch.forEach(configToWatch => {
      subscriptions.add(this.config.onDidChange(configToWatch, updateStyles));
    });
    updateStyles();
    return subscriptions;
  }

  updateStyles(sourcePath, getStylesheetFn) {
    const stylesheet = getStylesheetFn(this.config);
    this.styles.addStyleSheet(stylesheet, { sourcePath });
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'updateStyles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'updateStyles'), _class.prototype)), _class);
exports.default = StyleCalculator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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