'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.expectedDelegates = undefined;

var _desc, _value, _class;

var _commit = require('../commit');

var _branch = require('../branch');

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const expectedDelegates = exports.expectedDelegates = [];

/**
 * Map of registered subclasses to allow states to transition to one another without circular dependencies.
 * Subclasses of State should call `State.register` to add themselves here.
 */
const stateConstructors = new Map();

/**
 * Methods marked with this decorator on State should be delegated from a Repository to its current state. This will
 * be verified by a unit test in `repository.test.js`.
 */
function shouldDelegate(target, name, descriptor) {
  expectedDelegates.push(name);
  return descriptor;
}

/**
 * Base class for Repository states. Implements default "null" behavior.
 */
let State = (_class = class State {
  constructor(repository) {
    this.repository = repository;
  }

  static register(Subclass) {
    stateConstructors.set(Subclass.name, Subclass);
  }

  // This state has just been entered. Perform any asynchronous initialization that needs to occur.
  start() {
    return Promise.resolve();
  }

  // State probe predicates ////////////////////////////////////////////////////////////////////////////////////////////
  // Allow external callers to identify which state a Repository is in if necessary.

  isLoadingGuess() {
    return false;
  }

  isAbsentGuess() {
    return false;
  }

  isAbsent() {
    return false;
  }

  isLoading() {
    return false;
  }

  isEmpty() {
    return false;
  }

  isPresent() {
    return false;
  }

  isDestroyed() {
    return false;
  }

  // Behavior probe predicates /////////////////////////////////////////////////////////////////////////////////////////
  // Determine specific rendering behavior based on the current state.

  isUndetermined() {
    return false;
  }

  showGitTabInit() {
    return false;
  }

  showGitTabInitInProgress() {
    return false;
  }

  showGitTabLoading() {
    return false;
  }

  showStatusBarTiles() {
    return false;
  }

  hasDirectory() {
    return true;
  }

  // Lifecycle actions /////////////////////////////////////////////////////////////////////////////////////////////////
  // These generally default to rejecting a Promise with an error.

  init() {
    return unsupportedOperationPromise(this, 'init');
  }

  clone(remoteUrl) {
    return unsupportedOperationPromise(this, 'clone');
  }

  destroy() {
    return this.transitionTo('Destroyed');
  }

  refresh() {
    // No-op
  }

  observeFilesystemChange(events) {
    this.repository.refresh();
  }

  // Git operations ////////////////////////////////////////////////////////////////////////////////////////////////////
  // These default to rejecting a Promise with an error stating that the operation is not supported in the current
  // state.

  // Staging and unstaging

  stageFiles(paths) {
    return unsupportedOperationPromise(this, 'stageFiles');
  }

  unstageFiles(paths) {
    return unsupportedOperationPromise(this, 'unstageFiles');
  }

  stageFilesFromParentCommit(paths) {
    return unsupportedOperationPromise(this, 'stageFilesFromParentCommit');
  }

  applyPatchToIndex(patch) {
    return unsupportedOperationPromise(this, 'applyPatchToIndex');
  }

  applyPatchToWorkdir(patch) {
    return unsupportedOperationPromise(this, 'applyPatchToWorkdir');
  }

  // Committing

  commit(message, options) {
    return unsupportedOperationPromise(this, 'commit');
  }

  // Merging

  merge(branchName) {
    return unsupportedOperationPromise(this, 'merge');
  }

  abortMerge() {
    return unsupportedOperationPromise(this, 'abortMerge');
  }

  checkoutSide(side, paths) {
    return unsupportedOperationPromise(this, 'checkoutSide');
  }

  mergeFile(oursPath, commonBasePath, theirsPath, resultPath) {
    return unsupportedOperationPromise(this, 'mergeFile');
  }

  writeMergeConflictToIndex(filePath, commonBaseSha, oursSha, theirsSha) {
    return unsupportedOperationPromise(this, 'writeMergeConflictToIndex');
  }

  // Checkout

  checkout(revision) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return unsupportedOperationPromise(this, 'checkout');
  }

  checkoutPathsAtRevision(paths) {
    let revision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'HEAD';

    return unsupportedOperationPromise(this, 'checkoutPathsAtRevision');
  }

  // Remote interactions

  fetch(branchName) {
    return unsupportedOperationPromise(this, 'fetch');
  }

  pull(branchName) {
    return unsupportedOperationPromise(this, 'pull');
  }

  push(branchName) {
    return unsupportedOperationPromise(this, 'push');
  }

  // Configuration

  setConfig(option, value) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    let replaceAll = _ref.replaceAll;

    return unsupportedOperationPromise(this, 'setConfig');
  }

  unsetConfig(option) {
    return unsupportedOperationPromise(this, 'unsetConfig');
  }

  // Direct blob interactions

  createBlob() {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let filePath = _ref2.filePath,
        stdin = _ref2.stdin;

    return unsupportedOperationPromise(this, 'createBlob');
  }

  expandBlobToFile(absFilePath, sha) {
    return unsupportedOperationPromise(this, 'expandBlobToFile');
  }

  // Discard history

  createDiscardHistoryBlob() {
    return unsupportedOperationPromise(this, 'createDiscardHistoryBlob');
  }

  updateDiscardHistory() {
    return unsupportedOperationPromise(this, 'updateDiscardHistory');
  }

  storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction) {
    let partialDiscardFilePath = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    return unsupportedOperationPromise(this, 'storeBeforeAndAfterBlobs');
  }

  restoreLastDiscardInTempFiles(isSafe) {
    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    return unsupportedOperationPromise(this, 'restoreLastDiscardInTempFiles');
  }

  popDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return unsupportedOperationPromise(this, 'popDiscardHistory');
  }

  clearDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return unsupportedOperationPromise(this, 'clearDiscardHistory');
  }

  discardWorkDirChangesForPaths(paths) {
    return unsupportedOperationPromise(this, 'discardWorkDirChangesForPaths');
  }

  // Accessors /////////////////////////////////////////////////////////////////////////////////////////////////////////
  // When possible, these default to "empty" results when invoked in states that don't have information available, or
  // fail in a way that's consistent with the requested information not being found.

  // Index queries

  getStatusBundle() {
    return Promise.resolve({
      stagedFiles: {},
      unstagedFiles: {},
      mergeConflictFiles: {},
      branch: {
        oid: null,
        head: null,
        upstream: null,
        aheadBehind: { ahead: null, behind: null }
      }
    });
  }

  getStatusesForChangedFiles() {
    return Promise.resolve({
      stagedFiles: [],
      unstagedFiles: [],
      mergeConflictFiles: []
    });
  }

  getStagedChangesSinceParentCommit() {
    return Promise.resolve([]);
  }

  getFilePatchForPath(filePath) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return Promise.resolve(null);
  }

  readFileFromIndex(filePath) {
    return Promise.reject(new Error(`fatal: Path ${filePath} does not exist (neither on disk nor in the index).`));
  }

  // Commit access

  getLastCommit() {
    return Promise.resolve(_commit.nullCommit);
  }

  // Branches

  getBranches() {
    return Promise.resolve([]);
  }

  getCurrentBranch() {
    return Promise.resolve(_branch.nullBranch);
  }

  // Merging and rebasing status

  isMerging() {
    return Promise.resolve(false);
  }

  isRebasing() {
    return Promise.resolve(false);
  }

  // Remotes

  getRemotes() {
    return Promise.resolve([]);
  }

  getAheadCount(branchName) {
    return Promise.resolve(null);
  }

  getBehindCount(branchName) {
    return Promise.resolve(null);
  }

  getConfig(option) {
    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let local = _ref3.local;

    return Promise.resolve(null);
  }

  // Direct blob access

  getBlobContents(sha) {
    return Promise.reject(new Error(`fatal: Not a valid object name ${sha}`));
  }

  // Discard history

  hasDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return false;
  }

  getDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return [];
  }

  getLastHistorySnapshots() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return null;
  }

  // Internal //////////////////////////////////////////////////////////////////////////////////////////////////////////
  // Non-delegated methods that provide subclasses with convenient access to Repository properties.

  git() {
    return this.repository.git;
  }

  workdir() {
    return this.repository.getWorkingDirectoryPath();
  }

  // Call methods on the active Repository state, even if the state has transitioned beneath you.
  // Use this to perform operations within `start()` methods to guard against interrupted state transitions.
  current() {
    return this.repository.state;
  }

  // Return a Promise that will resolve once the state transitions from Loading.
  getLoadPromise() {
    return this.repository.getLoadPromise();
  }

  getRemoteForBranch(branchName) {
    return this.repository.getRemoteForBranch(branchName);
  }

  saveDiscardHistory() {
    return this.repository.saveDiscardHistory();
  }

  // Initiate a transition to another state.
  transitionTo(stateName) {
    const StateConstructor = stateConstructors.get(stateName);
    if (StateConstructor === undefined) {
      throw new Error(`Attempt to transition to unrecognized state ${stateName}`);
    }

    for (var _len = arguments.length, payload = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      payload[_key - 1] = arguments[_key];
    }

    return this.repository.transition(this, StateConstructor, ...payload);
  }

  // Event broadcast

  didDestroy() {
    return this.repository.emitter.emit('did-destroy');
  }

  didUpdate() {
    return this.repository.emitter.emit('did-update');
  }

  // Direct git access
  // Non-delegated git operations for internal use within states.

  directResolveDotGitDir() {
    return Promise.resolve(null);
  }

  directGetConfig(key) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return Promise.resolve(null);
  }

  directGetBlobContents() {
    return Promise.reject(new Error('Not a valid object name'));
  }

  directInit() {
    return Promise.resolve();
  }

  directClone(remoteUrl, options) {
    return Promise.resolve();
  }

  // Deferred operations
  // Direct raw git operations to the current state, even if the state has been changed. Use these methods within
  // start() methods.

  resolveDotGitDir() {
    return this.current().directResolveDotGitDir();
  }

  doInit(workdir) {
    return this.current().directInit();
  }

  doClone(remoteUrl, options) {
    return this.current().directClone(remoteUrl, options);
  }

  // Parse a DiscardHistory payload from the SHA recorded in config.
  loadHistoryPayload() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const historySha = yield _this.current().directGetConfig('atomGithub.historySha');
      if (!historySha) {
        return {};
      }

      let blob;
      try {
        blob = yield _this.current().directGetBlobContents(historySha);
      } catch (e) {
        if (/Not a valid object name/.test(e.stdErr)) {
          return {};
        }

        throw e;
      }

      try {
        return JSON.parse(blob);
      } catch (e) {
        return {};
      }
    })();
  }

  // Debugging assistance.

  toString() {
    return this.constructor.name;
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'isLoadingGuess', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isLoadingGuess'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isAbsentGuess', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isAbsentGuess'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isAbsent', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isAbsent'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isLoading', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isLoading'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isEmpty', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isEmpty'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isPresent', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isPresent'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isDestroyed', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isDestroyed'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isUndetermined', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isUndetermined'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showGitTabInit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showGitTabInit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showGitTabInitInProgress', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showGitTabInitInProgress'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showGitTabLoading', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showGitTabLoading'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showStatusBarTiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showStatusBarTiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasDirectory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'hasDirectory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'init', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'init'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'clone', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'clone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'destroy', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'destroy'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'refresh', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'refresh'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'observeFilesystemChange', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'observeFilesystemChange'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageFilesFromParentCommit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFilesFromParentCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToIndex', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToWorkdir', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToWorkdir'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'merge', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'merge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'abortMerge', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkoutSide', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'checkoutSide'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mergeFile', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'mergeFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'writeMergeConflictToIndex', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'writeMergeConflictToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkout', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'checkout'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkoutPathsAtRevision', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'checkoutPathsAtRevision'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'fetch', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'fetch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'pull', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'pull'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'push', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'push'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setConfig', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'setConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unsetConfig', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'unsetConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createBlob', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'createBlob'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'expandBlobToFile', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'expandBlobToFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createDiscardHistoryBlob', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'createDiscardHistoryBlob'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'updateDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'updateDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'storeBeforeAndAfterBlobs', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'storeBeforeAndAfterBlobs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'restoreLastDiscardInTempFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'restoreLastDiscardInTempFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'popDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'popDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'clearDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'clearDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardWorkDirChangesForPaths', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'discardWorkDirChangesForPaths'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getStatusBundle', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getStatusBundle'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getStatusesForChangedFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getStatusesForChangedFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getStagedChangesSinceParentCommit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getStagedChangesSinceParentCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getFilePatchForPath', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getFilePatchForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'readFileFromIndex', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'readFileFromIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getLastCommit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getLastCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getBranches', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getBranches'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getCurrentBranch', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getCurrentBranch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isMerging', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isMerging'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isRebasing', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isRebasing'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getRemotes', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getRemotes'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getAheadCount', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getAheadCount'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getBehindCount', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getBehindCount'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getConfig', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getBlobContents', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getBlobContents'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'hasDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getLastHistorySnapshots', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getLastHistorySnapshots'), _class.prototype)), _class);
exports.default = State;


function unsupportedOperationPromise(self, opName) {
  return Promise.reject(new Error(`${opName} is not available in ${self} state`));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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