'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _class, _temp;

let HunkLine = (_temp = _class = class HunkLine {

  constructor(text, status, oldLineNumber, newLineNumber, diffLineNumber) {
    this.text = text;
    this.status = status;
    this.oldLineNumber = oldLineNumber;
    this.newLineNumber = newLineNumber;
    this.diffLineNumber = diffLineNumber;
  }

  copy() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let text = _ref.text,
        status = _ref.status,
        oldLineNumber = _ref.oldLineNumber,
        newLineNumber = _ref.newLineNumber;

    return new HunkLine(text || this.getText(), status || this.getStatus(), oldLineNumber || this.getOldLineNumber(), newLineNumber || this.getNewLineNumber());
  }

  getText() {
    return this.text;
  }

  getOldLineNumber() {
    return this.oldLineNumber;
  }

  getNewLineNumber() {
    return this.newLineNumber;
  }

  getStatus() {
    return this.status;
  }

  isChanged() {
    return this.getStatus() === 'added' || this.getStatus() === 'deleted';
  }

  getOrigin() {
    switch (this.getStatus()) {
      case 'added':
        return '+';
      case 'deleted':
        return '-';
      case 'unchanged':
        return ' ';
      case 'nonewline':
        return '\\';
      default:
        return '';
    }
  }

  invert() {
    let invertedStatus;
    switch (this.getStatus()) {
      case 'added':
        invertedStatus = 'deleted';
        break;
      case 'deleted':
        invertedStatus = 'added';
        break;
      case 'unchanged':
        invertedStatus = 'unchanged';
        break;
      case 'nonewline':
        invertedStatus = 'nonewline';
        break;
    }

    return new HunkLine(this.text, invertedStatus, this.newLineNumber, this.oldLineNumber);
  }

  toString() {
    return this.getOrigin() + (this.getStatus() === 'nonewline' ? ' ' : '') + this.getText();
  }
}, _class.statusMap = {
  '+': 'added',
  '-': 'deleted',
  ' ': 'unchanged',
  '\\': 'nonewline'
}, _temp);
exports.default = HunkLine;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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