'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _nsfw = require('nsfw');

var _nsfw2 = _interopRequireDefault(_nsfw);

var _electron = require('electron');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const actionText = new Map();
actionText.set(_nsfw2.default.actions.CREATED, 'created');
actionText.set(_nsfw2.default.actions.DELETED, 'deleted');
actionText.set(_nsfw2.default.actions.MODIFIED, 'modified');
actionText.set(_nsfw2.default.actions.RENAMED, 'renamed');

let headless = null;

let EventLogger = class EventLogger {
  constructor(kind) {
    this.kind = kind;
    this.directory = '<unknown>';
    this.shortDirectory = '<unknown>';

    if (headless === null) {
      headless = !_electron.remote.getCurrentWindow().isVisible();
    }
  }

  showStarted(directory) {
    this.directory = directory;
    this.shortDirectory = _path2.default.basename(directory);

    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('watcher started');
  }

  showEvents(events) {
    if (!this.isEnabled()) {
      return;
    }

    const uniqueRelativeNames = new Set(events.map(event => {
      const fullPath = _path2.default.join(event.directory, event.file || event.newFile);
      return _path2.default.relative(this.directory, fullPath);
    }));

    const fileNames = Array.from(uniqueRelativeNames).slice(0, 3);
    const elipses = uniqueRelativeNames.size > 3 ? '...' : '';
    const summary = `${this.getShortName()}: ${fileNames.join(', ')}${elipses}`;

    /* eslint-disable no-console */
    if (headless) {
      const eventText = events.map(event => {
        const file = event.file ? event.file : `${event.oldFile} => ${event.newFile}`;
        const action = actionText.get(event.action) || `unknown: ${event.action}`;
        return `  ${event.directory} => ${file} (${action})\n`;
      }).join('\n');
      console.log(summary + '\n' + eventText);
    } else {
      console.groupCollapsed(summary);
      console.table(events.map(event => ({
        directory: event.directory,
        file: event.file,
        newFile: event.newFile,
        action: actionText.get(event.action) || `(unknown: ${event.action})`
      })), ['directory', 'action', 'file', 'newFile']);
      console.groupEnd();
    }
    /* eslint-enable no-console */
  }

  showFocusEvent() {
    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('focus triggered');
  }

  showWorkdirOrHeadEvents() {
    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('working directory or HEAD change');
  }

  showStopped() {
    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('stopped');
  }

  isEnabled() {
    return process.env.ATOM_GITHUB_FS_EVENT_LOG || atom.config.get('github.filesystemEventDiagnostics');
  }

  getShortName() {
    return `${this.kind} @ ${this.shortDirectory}`;
  }

  shortLog(line) {
    if (headless) {
      // eslint-disable-next-line no-console
      console.log(`${this.getShortName()}: ${line}`);
      return;
    }

    // eslint-disable-next-line no-console
    console.log('%c%s%c: %s', 'font-weight: bold; color: blue;', this.getShortName(), 'font-weight: normal; color: black;', line);
  }
};
exports.default = EventLogger;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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