'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _markerTools = require('./marker-tools');

let Separator = class Separator {
  constructor(editor, marker) {
    this.editor = editor;
    this.marker = marker;
  }

  getMarker() {
    return this.marker;
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }

  isModified() {
    const currentText = this.editor.getTextInBufferRange(this.getMarker().getBufferRange());
    return !/^=======\r?\n?$/.test(currentText);
  }
};
exports.default = Separator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlcGFyYXRvci5qcyJdLCJuYW1lcyI6WyJTZXBhcmF0b3IiLCJjb25zdHJ1Y3RvciIsImVkaXRvciIsIm1hcmtlciIsImdldE1hcmtlciIsImRlbGV0ZSIsImlzTW9kaWZpZWQiLCJjdXJyZW50VGV4dCIsImdldFRleHRJbkJ1ZmZlclJhbmdlIiwiZ2V0QnVmZmVyUmFuZ2UiLCJ0ZXN0Il0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0lBRXFCQSxTLEdBQU4sTUFBTUEsU0FBTixDQUFnQjtBQUM3QkMsY0FBWUMsTUFBWixFQUFvQkMsTUFBcEIsRUFBNEI7QUFDMUIsU0FBS0QsTUFBTCxHQUFjQSxNQUFkO0FBQ0EsU0FBS0MsTUFBTCxHQUFjQSxNQUFkO0FBQ0Q7O0FBRURDLGNBQVk7QUFDVixXQUFPLEtBQUtELE1BQVo7QUFDRDs7QUFFREUsV0FBUztBQUNQLHFDQUFlLEtBQUtELFNBQUwsRUFBZixFQUFpQyxLQUFLRixNQUF0QztBQUNEOztBQUVESSxlQUFhO0FBQ1gsVUFBTUMsY0FBYyxLQUFLTCxNQUFMLENBQVlNLG9CQUFaLENBQWlDLEtBQUtKLFNBQUwsR0FBaUJLLGNBQWpCLEVBQWpDLENBQXBCO0FBQ0EsV0FBTyxDQUFDLGtCQUFrQkMsSUFBbEIsQ0FBdUJILFdBQXZCLENBQVI7QUFDRDtBQWpCNEIsQztrQkFBVlAsUyIsImZpbGUiOiJzZXBhcmF0b3IuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2RlbGV0ZU1hcmtlcklufSBmcm9tICcuL21hcmtlci10b29scyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFNlcGFyYXRvciB7XG4gIGNvbnN0cnVjdG9yKGVkaXRvciwgbWFya2VyKSB7XG4gICAgdGhpcy5lZGl0b3IgPSBlZGl0b3I7XG4gICAgdGhpcy5tYXJrZXIgPSBtYXJrZXI7XG4gIH1cblxuICBnZXRNYXJrZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMubWFya2VyO1xuICB9XG5cbiAgZGVsZXRlKCkge1xuICAgIGRlbGV0ZU1hcmtlckluKHRoaXMuZ2V0TWFya2VyKCksIHRoaXMuZWRpdG9yKTtcbiAgfVxuXG4gIGlzTW9kaWZpZWQoKSB7XG4gICAgY29uc3QgY3VycmVudFRleHQgPSB0aGlzLmVkaXRvci5nZXRUZXh0SW5CdWZmZXJSYW5nZSh0aGlzLmdldE1hcmtlcigpLmdldEJ1ZmZlclJhbmdlKCkpO1xuICAgIHJldHVybiAhL149PT09PT09XFxyP1xcbj8kLy50ZXN0KGN1cnJlbnRUZXh0KTtcbiAgfVxufVxuIl19