'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _eventKit = require('event-kit');

let ResolutionProgress = class ResolutionProgress {
  constructor() {
    this.emitter = new _eventKit.Emitter();
    this.markerCountByPath = new Map();
  }

  didUpdate() {
    this.emitter.emit('did-update');
  }

  onDidUpdate(cb) {
    return this.emitter.on('did-update', cb);
  }

  reportMarkerCount(path, count) {
    const previous = this.markerCountByPath.get(path);
    this.markerCountByPath.set(path, count);
    if (count !== previous) {
      this.didUpdate();
    }
  }

  getRemaining(path) {
    return this.markerCountByPath.get(path);
  }

  isEmpty() {
    return this.markerCountByPath.size === 0;
  }
};
exports.default = ResolutionProgress;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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