'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
let Position = class Position {
  constructor(name, cssClass) {
    this.name = name.toLowerCase();

    this.cssClass = cssClass;
  }

  getName() {
    return this.name;
  }

  when(actions) {
    const chosen = actions[this.name] || actions.default || (() => {
      throw new Error(`Unexpected conflict side position: ${this.name}`);
    });
    return chosen();
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toString() {
    return `<Position: ${this.name.toUpperCase()}>`;
  }
};
const TOP = exports.TOP = new Position('TOP', 'github-ConflictTop');
const MIDDLE = exports.MIDDLE = new Position('MIDDLE', 'github-ConflictMiddle');
const BOTTOM = exports.BOTTOM = new Position('BOTTOM', 'github-ConflictBottom');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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