'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _dec, _class, _desc, _value, _class2, _class3, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _gitShellOutStrategy = require('../git-shell-out-strategy');

var _observeModel = require('../decorators/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _propTypes3 = require('../prop-types');

var _branchView = require('../views/branch-view');

var _branchView2 = _interopRequireDefault(_branchView);

var _branchMenuView = require('../views/branch-menu-view');

var _branchMenuView2 = _interopRequireDefault(_branchMenuView);

var _pushPullView = require('../views/push-pull-view');

var _pushPullView2 = _interopRequireDefault(_pushPullView);

var _pushPullMenuView = require('../views/push-pull-menu-view');

var _pushPullMenuView2 = _interopRequireDefault(_pushPullMenuView);

var _changedFilesCountView = require('../views/changed-files-count-view');

var _changedFilesCountView2 = _interopRequireDefault(_changedFilesCountView);

var _tooltip = require('../views/tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _commands = require('../views/commands');

var _commands2 = _interopRequireDefault(_commands);

var _branch = require('../models/branch');

var _remote = require('../models/remote');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let StatusBarTileController = (_dec = (0, _observeModel2.default)({
  getModel: props => props.repository,
  fetchData: repository => {
    return (0, _yubikiri2.default)({
      currentBranch: repository.getCurrentBranch(),
      branches: repository.getBranches(),
      statusesForChangedFiles: repository.getStatusesForChangedFiles(),
      currentRemote: (() => {
        var _ref = _asyncToGenerator(function* (query) {
          return repository.getRemoteForBranch((yield query.currentBranch).getName());
        });

        return function currentRemote(_x) {
          return _ref.apply(this, arguments);
        };
      })(),
      aheadCount: (() => {
        var _ref2 = _asyncToGenerator(function* (query) {
          return repository.getAheadCount((yield query.currentBranch).getName());
        });

        return function aheadCount(_x2) {
          return _ref2.apply(this, arguments);
        };
      })(),
      behindCount: (() => {
        var _ref3 = _asyncToGenerator(function* (query) {
          return repository.getBehindCount((yield query.currentBranch).getName());
        });

        return function behindCount(_x3) {
          return _ref3.apply(this, arguments);
        };
      })(),
      originExists: (() => {
        var _ref4 = _asyncToGenerator(function* () {
          const remotes = yield repository.getRemotes();
          return remotes.filter(function (remote) {
            return remote.getName() === 'origin';
          }).length > 0;
        });

        return function originExists() {
          return _ref4.apply(this, arguments);
        };
      })()
    });
  }
}), _dec(_class = (_class2 = (_temp = _class3 = class StatusBarTileController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      inProgress: false,
      pushInProgress: false,
      fetchInProgress: false
    };
  }

  getChangedFilesCount() {
    var _props$statusesForCha = this.props.statusesForChangedFiles;
    const stagedFiles = _props$statusesForCha.stagedFiles,
          unstagedFiles = _props$statusesForCha.unstagedFiles,
          mergeConflictFiles = _props$statusesForCha.mergeConflictFiles;

    const changedFiles = new Set();

    for (const filePath in unstagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in stagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in mergeConflictFiles) {
      changedFiles.add(filePath);
    }

    return changedFiles.size;
  }

  render() {
    let changedFilesCount, mergeConflictsPresent;
    if (this.props.statusesForChangedFiles) {
      changedFilesCount = this.getChangedFilesCount();
      mergeConflictsPresent = Object.keys(this.props.statusesForChangedFiles.mergeConflictFiles).length > 0;
    }

    const repoProps = {
      repository: this.props.repository,
      currentBranch: this.props.currentBranch,
      branches: this.props.branches,
      currentRemote: this.props.currentRemote,
      aheadCount: this.props.aheadCount,
      behindCount: this.props.behindCount,
      changedFilesCount,
      mergeConflictsPresent
    };

    return _react2.default.createElement(
      'div',
      { className: 'github-StatusBarTileController' },
      this.renderTiles(repoProps),
      _react2.default.createElement(_changedFilesCountView2.default, _extends({
        didClick: this.props.toggleGitTab
      }, repoProps))
    );
  }

  renderTiles(repoProps) {
    if (!this.props.repository.showStatusBarTiles()) {
      return null;
    }

    return _react2.default.createElement(
      'span',
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:fetch', callback: this.fetch }),
        _react2.default.createElement(_commands.Command, { command: 'github:pull', callback: this.pull }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:push',
          callback: () => this.push({ force: false, setUpstream: !this.props.currentRemote.isPresent() })
        }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:force-push',
          callback: () => this.push({ force: true, setUpstream: !this.props.currentRemote.isPresent() })
        })
      ),
      _react2.default.createElement(_branchView2.default, _extends({
        ref: e => {
          this.branchView = e;
        },
        workspace: this.props.workspace,
        checkout: this.checkout
      }, repoProps)),
      _react2.default.createElement(
        _tooltip2.default,
        {
          manager: this.props.tooltips,
          target: () => this.branchView,
          trigger: 'click',
          className: 'github-StatusBarTileController-tooltipMenu' },
        _react2.default.createElement(_branchMenuView2.default, _extends({
          workspace: this.props.workspace,
          notificationManager: this.props.notificationManager,
          commandRegistry: this.props.commandRegistry,
          checkout: this.checkout
        }, repoProps))
      ),
      _react2.default.createElement(_pushPullView2.default, _extends({
        ref: e => {
          this.pushPullView = e;
        },
        pushInProgress: this.state.pushInProgress,
        fetchInProgress: this.state.fetchInProgress
      }, repoProps)),
      _react2.default.createElement(
        _tooltip2.default,
        {
          manager: this.props.tooltips,
          target: () => this.pushPullView,
          trigger: 'click',
          className: 'github-StatusBarTileController-tooltipMenu' },
        _react2.default.createElement(_pushPullMenuView2.default, _extends({
          onMarkSpecialClick: this.handleOpenGitTimingsView,
          workspace: this.props.workspace,
          inProgress: this.state.inProgress,
          originExists: !!this.props.originExists,
          push: this.push,
          pull: this.pull,
          fetch: this.fetch
        }, repoProps))
      )
    );
  }

  handleOpenGitTimingsView(e) {
    e && e.preventDefault();
    this.props.workspace.open('atom-github://debug/timings');
  }

  setInProgressWhile(block) {
    var _this = this;

    var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { push: false, pull: false, fetch: false };

    let push = _ref5.push,
        pull = _ref5.pull,
        fetch = _ref5.fetch;

    return new Promise((resolve, reject) => {
      if (this.state.inProgress) {
        resolve();
        return;
      }

      this.setState({ inProgress: true, pushInProgress: push, fetchInProgress: pull || fetch }, _asyncToGenerator(function* () {
        try {
          yield block();
        } catch (e) {
          reject(e);
        } finally {
          _this.setState({ inProgress: false, pushInProgress: false, fetchInProgress: false }, resolve);
        }
      }));
    });
  }

  attemptGitOperation(operation) {
    var _this2 = this;

    let errorTransform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function (error) {
      return { message: error.stdErr };
    };
    return _asyncToGenerator(function* () {
      const operationPromise = operation();
      try {
        return yield operationPromise;
      } catch (error) {
        if (!(error instanceof _gitShellOutStrategy.GitError)) {
          throw error;
        }

        var _errorTransform = errorTransform(error),
            _errorTransform$notif = _errorTransform.notificationMethod;

        const notificationMethod = _errorTransform$notif === undefined ? 'addError' : _errorTransform$notif,
              message = _errorTransform.message,
              description = _errorTransform.description;

        _this2.props.notificationManager[notificationMethod](message || 'Cannot complete remote interaction', { description, dismissable: true });
        return null;
      }
    })();
  }

  checkout(branchName, options) {
    return this.setInProgressWhile(() => this.props.repository.checkout(branchName, options));
  }

  push(_ref7) {
    var _this3 = this;

    let force = _ref7.force,
        setUpstream = _ref7.setUpstream;
    return _asyncToGenerator(function* () {
      yield _this3.attemptGitOperation(function () {
        return _this3.doPush({ force, setUpstream });
      }, function (error) {
        if (/rejected[\s\S]*failed to push/.test(error.stdErr)) {
          return {
            message: 'Push rejected',
            description: 'The tip of your current branch is behind its remote counterpart.' + ' Try pulling before pushing again. Or, to force push, hold `cmd` or `ctrl` while clicking.'
          };
        }

        return { message: 'Unable to push', description: `<pre>${error.stdErr}</pre>` };
      });
    })();
  }

  doPush(options) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (options.force) {
        const choice = _this4.props.confirm({
          message: 'Are you sure you want to force push?',
          detailedMessage: 'This operation could result in losing data on the remote.',
          buttons: ['Force Push', 'Cancel Push']
        });
        if (choice !== 0) {
          return;
        }
      }

      yield _this4.setInProgressWhile(function () {
        return _this4.props.repository.push(_this4.props.currentBranch.getName(), options);
      }, { push: true });
    })();
  }

  pull() {
    var _this5 = this;

    return _asyncToGenerator(function* () {
      yield _this5.attemptGitOperation(function () {
        return _this5.doPull();
      }, function (error) {
        if (/error: Your local changes to the following files would be overwritten by merge/.test(error.stdErr)) {
          const lines = error.stdErr.split('\n');
          const files = lines.slice(3, lines.length - 3).map(function (l) {
            return `\`${l.trim()}\``;
          }).join('<br>');
          return {
            message: 'Pull aborted',
            description: 'Local changes to the following would be overwritten by merge:<br>' + files + '<br>Please commit your changes or stash them before you merge.'
          };
        } else if (/Automatic merge failed; fix conflicts and then commit the result./.test(error.stdOut)) {
          _this5.props.ensureGitTabVisible();
          return {
            notificationMethod: 'addWarning',
            message: 'Merge conflicts',
            description: `Your local changes conflicted with changes made on the remote branch. Resolve the conflicts
              with the Git panel and commit to continue.`
          };
        }

        return { message: 'Unable to pull', description: `<pre>${error.stdErr}</pre>` };
      });
    })();
  }

  doPull() {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      yield _this6.setInProgressWhile(function () {
        return _this6.props.repository.pull(_this6.props.currentBranch.getName());
      }, { pull: true });
    })();
  }

  fetch() {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      yield _this7.attemptGitOperation(function () {
        return _this7.doFetch();
      }, function (error) {
        return {
          message: 'Unable to fetch',
          description: `<pre>${error.stdErr}</pre>`
        };
      });
    })();
  }

  doFetch() {
    var _this8 = this;

    return _asyncToGenerator(function* () {
      yield _this8.setInProgressWhile(function () {
        return _this8.props.repository.fetch(_this8.props.currentBranch.getName());
      }, { fetch: true });
    })();
  }
}, _class3.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  confirm: _propTypes2.default.func.isRequired,
  repository: _propTypes2.default.object.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  branches: _propTypes2.default.arrayOf(_propTypes3.BranchPropType).isRequired,
  currentRemote: _propTypes3.RemotePropType.isRequired,
  aheadCount: _propTypes2.default.number,
  behindCount: _propTypes2.default.number,
  statusesForChangedFiles: _propTypes2.default.object,
  originExists: _propTypes2.default.bool,
  toggleGitTab: _propTypes2.default.func,
  ensureGitTabVisible: _propTypes2.default.func
}, _class3.defaultProps = {
  currentBranch: _branch.nullBranch,
  branches: [],
  currentRemote: _remote.nullRemote,
  toggleGitTab: () => {}
}, _temp), (_applyDecoratedDescriptor(_class2.prototype, 'handleOpenGitTimingsView', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleOpenGitTimingsView'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'checkout', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'checkout'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'push', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'push'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'pull', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'pull'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'fetch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'fetch'), _class2.prototype)), _class2)) || _class);
exports.default = StatusBarTileController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInN0YXR1cy1iYXItdGlsZS1jb250cm9sbGVyLmpzIl0sIm5hbWVzIjpbIlN0YXR1c0JhclRpbGVDb250cm9sbGVyIiwiZ2V0TW9kZWwiLCJwcm9wcyIsInJlcG9zaXRvcnkiLCJmZXRjaERhdGEiLCJjdXJyZW50QnJhbmNoIiwiZ2V0Q3VycmVudEJyYW5jaCIsImJyYW5jaGVzIiwiZ2V0QnJhbmNoZXMiLCJzdGF0dXNlc0ZvckNoYW5nZWRGaWxlcyIsImdldFN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzIiwiY3VycmVudFJlbW90ZSIsInF1ZXJ5IiwiZ2V0UmVtb3RlRm9yQnJhbmNoIiwiZ2V0TmFtZSIsImFoZWFkQ291bnQiLCJnZXRBaGVhZENvdW50IiwiYmVoaW5kQ291bnQiLCJnZXRCZWhpbmRDb3VudCIsIm9yaWdpbkV4aXN0cyIsInJlbW90ZXMiLCJnZXRSZW1vdGVzIiwiZmlsdGVyIiwicmVtb3RlIiwibGVuZ3RoIiwiQ29tcG9uZW50IiwiY29uc3RydWN0b3IiLCJjb250ZXh0Iiwic3RhdGUiLCJpblByb2dyZXNzIiwicHVzaEluUHJvZ3Jlc3MiLCJmZXRjaEluUHJvZ3Jlc3MiLCJnZXRDaGFuZ2VkRmlsZXNDb3VudCIsInN0YWdlZEZpbGVzIiwidW5zdGFnZWRGaWxlcyIsIm1lcmdlQ29uZmxpY3RGaWxlcyIsImNoYW5nZWRGaWxlcyIsIlNldCIsImZpbGVQYXRoIiwiYWRkIiwic2l6ZSIsInJlbmRlciIsImNoYW5nZWRGaWxlc0NvdW50IiwibWVyZ2VDb25mbGljdHNQcmVzZW50IiwiT2JqZWN0Iiwia2V5cyIsInJlcG9Qcm9wcyIsInJlbmRlclRpbGVzIiwidG9nZ2xlR2l0VGFiIiwic2hvd1N0YXR1c0JhclRpbGVzIiwiY29tbWFuZFJlZ2lzdHJ5IiwiZmV0Y2giLCJwdWxsIiwicHVzaCIsImZvcmNlIiwic2V0VXBzdHJlYW0iLCJpc1ByZXNlbnQiLCJlIiwiYnJhbmNoVmlldyIsIndvcmtzcGFjZSIsImNoZWNrb3V0IiwidG9vbHRpcHMiLCJub3RpZmljYXRpb25NYW5hZ2VyIiwicHVzaFB1bGxWaWV3IiwiaGFuZGxlT3BlbkdpdFRpbWluZ3NWaWV3IiwicHJldmVudERlZmF1bHQiLCJvcGVuIiwic2V0SW5Qcm9ncmVzc1doaWxlIiwiYmxvY2siLCJQcm9taXNlIiwicmVzb2x2ZSIsInJlamVjdCIsInNldFN0YXRlIiwiYXR0ZW1wdEdpdE9wZXJhdGlvbiIsIm9wZXJhdGlvbiIsImVycm9yVHJhbnNmb3JtIiwibWVzc2FnZSIsImVycm9yIiwic3RkRXJyIiwib3BlcmF0aW9uUHJvbWlzZSIsIm5vdGlmaWNhdGlvbk1ldGhvZCIsImRlc2NyaXB0aW9uIiwiZGlzbWlzc2FibGUiLCJicmFuY2hOYW1lIiwib3B0aW9ucyIsImRvUHVzaCIsInRlc3QiLCJjaG9pY2UiLCJjb25maXJtIiwiZGV0YWlsZWRNZXNzYWdlIiwiYnV0dG9ucyIsImRvUHVsbCIsImxpbmVzIiwic3BsaXQiLCJmaWxlcyIsInNsaWNlIiwibWFwIiwibCIsInRyaW0iLCJqb2luIiwic3RkT3V0IiwiZW5zdXJlR2l0VGFiVmlzaWJsZSIsImRvRmV0Y2giLCJwcm9wVHlwZXMiLCJvYmplY3QiLCJpc1JlcXVpcmVkIiwiZnVuYyIsImFycmF5T2YiLCJudW1iZXIiLCJib29sIiwiZGVmYXVsdFByb3BzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFFQTs7QUFDQTs7OztBQUNBOztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUFtQnFCQSx1QixXQWpCcEIsNEJBQXNCO0FBQ3JCQyxZQUFVQyxTQUFTQSxNQUFNQyxVQURKO0FBRXJCQyxhQUFXRCxjQUFjO0FBQ3ZCLFdBQU8sd0JBQVM7QUFDZEUscUJBQWVGLFdBQVdHLGdCQUFYLEVBREQ7QUFFZEMsZ0JBQVVKLFdBQVdLLFdBQVgsRUFGSTtBQUdkQywrQkFBeUJOLFdBQVdPLDBCQUFYLEVBSFg7QUFJZEM7QUFBQSxxQ0FBZSxXQUFNQyxLQUFOO0FBQUEsaUJBQWVULFdBQVdVLGtCQUFYLENBQThCLENBQUMsTUFBTUQsTUFBTVAsYUFBYixFQUE0QlMsT0FBNUIsRUFBOUIsQ0FBZjtBQUFBLFNBQWY7O0FBQUE7QUFBQTtBQUFBO0FBQUEsVUFKYztBQUtkQztBQUFBLHNDQUFZLFdBQU1ILEtBQU47QUFBQSxpQkFBZVQsV0FBV2EsYUFBWCxDQUF5QixDQUFDLE1BQU1KLE1BQU1QLGFBQWIsRUFBNEJTLE9BQTVCLEVBQXpCLENBQWY7QUFBQSxTQUFaOztBQUFBO0FBQUE7QUFBQTtBQUFBLFVBTGM7QUFNZEc7QUFBQSxzQ0FBYSxXQUFNTCxLQUFOO0FBQUEsaUJBQWVULFdBQVdlLGNBQVgsQ0FBMEIsQ0FBQyxNQUFNTixNQUFNUCxhQUFiLEVBQTRCUyxPQUE1QixFQUExQixDQUFmO0FBQUEsU0FBYjs7QUFBQTtBQUFBO0FBQUE7QUFBQSxVQU5jO0FBT2RLO0FBQUEsc0NBQWMsYUFBWTtBQUN4QixnQkFBTUMsVUFBVSxNQUFNakIsV0FBV2tCLFVBQVgsRUFBdEI7QUFDQSxpQkFBT0QsUUFBUUUsTUFBUixDQUFlO0FBQUEsbUJBQVVDLE9BQU9ULE9BQVAsT0FBcUIsUUFBL0I7QUFBQSxXQUFmLEVBQXdEVSxNQUF4RCxHQUFpRSxDQUF4RTtBQUNELFNBSEQ7O0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFQYyxLQUFULENBQVA7QUFZRDtBQWZvQixDQUF0QixDLDhDQWlCYyxNQUFNeEIsdUJBQU4sU0FBc0MsZ0JBQU15QixTQUE1QyxDQUFzRDs7QUEwQm5FQyxjQUFZeEIsS0FBWixFQUFtQnlCLE9BQW5CLEVBQTRCO0FBQzFCLFVBQU16QixLQUFOLEVBQWF5QixPQUFiOztBQUVBLFNBQUtDLEtBQUwsR0FBYTtBQUNYQyxrQkFBWSxLQUREO0FBRVhDLHNCQUFnQixLQUZMO0FBR1hDLHVCQUFpQjtBQUhOLEtBQWI7QUFLRDs7QUFFREMseUJBQXVCO0FBQUEsZ0NBQ29DLEtBQUs5QixLQUFMLENBQVdPLHVCQUQvQztBQUFBLFVBQ2R3QixXQURjLHlCQUNkQSxXQURjO0FBQUEsVUFDREMsYUFEQyx5QkFDREEsYUFEQztBQUFBLFVBQ2NDLGtCQURkLHlCQUNjQSxrQkFEZDs7QUFFckIsVUFBTUMsZUFBZSxJQUFJQyxHQUFKLEVBQXJCOztBQUVBLFNBQUssTUFBTUMsUUFBWCxJQUF1QkosYUFBdkIsRUFBc0M7QUFDcENFLG1CQUFhRyxHQUFiLENBQWlCRCxRQUFqQjtBQUNEO0FBQ0QsU0FBSyxNQUFNQSxRQUFYLElBQXVCTCxXQUF2QixFQUFvQztBQUNsQ0csbUJBQWFHLEdBQWIsQ0FBaUJELFFBQWpCO0FBQ0Q7QUFDRCxTQUFLLE1BQU1BLFFBQVgsSUFBdUJILGtCQUF2QixFQUEyQztBQUN6Q0MsbUJBQWFHLEdBQWIsQ0FBaUJELFFBQWpCO0FBQ0Q7O0FBRUQsV0FBT0YsYUFBYUksSUFBcEI7QUFDRDs7QUFFREMsV0FBUztBQUNQLFFBQUlDLGlCQUFKLEVBQXVCQyxxQkFBdkI7QUFDQSxRQUFJLEtBQUt6QyxLQUFMLENBQVdPLHVCQUFmLEVBQXdDO0FBQ3RDaUMsMEJBQW9CLEtBQUtWLG9CQUFMLEVBQXBCO0FBQ0FXLDhCQUF3QkMsT0FBT0MsSUFBUCxDQUFZLEtBQUszQyxLQUFMLENBQVdPLHVCQUFYLENBQW1DMEIsa0JBQS9DLEVBQW1FWCxNQUFuRSxHQUE0RSxDQUFwRztBQUNEOztBQUVELFVBQU1zQixZQUFZO0FBQ2hCM0Msa0JBQVksS0FBS0QsS0FBTCxDQUFXQyxVQURQO0FBRWhCRSxxQkFBZSxLQUFLSCxLQUFMLENBQVdHLGFBRlY7QUFHaEJFLGdCQUFVLEtBQUtMLEtBQUwsQ0FBV0ssUUFITDtBQUloQkkscUJBQWUsS0FBS1QsS0FBTCxDQUFXUyxhQUpWO0FBS2hCSSxrQkFBWSxLQUFLYixLQUFMLENBQVdhLFVBTFA7QUFNaEJFLG1CQUFhLEtBQUtmLEtBQUwsQ0FBV2UsV0FOUjtBQU9oQnlCLHVCQVBnQjtBQVFoQkM7QUFSZ0IsS0FBbEI7O0FBV0EsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLGdDQUFmO0FBQ0csV0FBS0ksV0FBTCxDQUFpQkQsU0FBakIsQ0FESDtBQUVFO0FBQ0Usa0JBQVUsS0FBSzVDLEtBQUwsQ0FBVzhDO0FBRHZCLFNBRU1GLFNBRk47QUFGRixLQURGO0FBU0Q7O0FBRURDLGNBQVlELFNBQVosRUFBdUI7QUFDckIsUUFBSSxDQUFDLEtBQUs1QyxLQUFMLENBQVdDLFVBQVgsQ0FBc0I4QyxrQkFBdEIsRUFBTCxFQUFpRDtBQUMvQyxhQUFPLElBQVA7QUFDRDs7QUFFRCxXQUNFO0FBQUE7QUFBQTtBQUNFO0FBQUE7QUFBQSxVQUFVLFVBQVUsS0FBSy9DLEtBQUwsQ0FBV2dELGVBQS9CLEVBQWdELFFBQU8sZ0JBQXZEO0FBQ0UsMkRBQVMsU0FBUSxjQUFqQixFQUFnQyxVQUFVLEtBQUtDLEtBQS9DLEdBREY7QUFFRSwyREFBUyxTQUFRLGFBQWpCLEVBQStCLFVBQVUsS0FBS0MsSUFBOUMsR0FGRjtBQUdFO0FBQ0UsbUJBQVEsYUFEVjtBQUVFLG9CQUFVLE1BQU0sS0FBS0MsSUFBTCxDQUFVLEVBQUNDLE9BQU8sS0FBUixFQUFlQyxhQUFhLENBQUMsS0FBS3JELEtBQUwsQ0FBV1MsYUFBWCxDQUF5QjZDLFNBQXpCLEVBQTdCLEVBQVY7QUFGbEIsVUFIRjtBQU9FO0FBQ0UsbUJBQVEsbUJBRFY7QUFFRSxvQkFBVSxNQUFNLEtBQUtILElBQUwsQ0FBVSxFQUFDQyxPQUFPLElBQVIsRUFBY0MsYUFBYSxDQUFDLEtBQUtyRCxLQUFMLENBQVdTLGFBQVgsQ0FBeUI2QyxTQUF6QixFQUE1QixFQUFWO0FBRmxCO0FBUEYsT0FERjtBQWFFO0FBQ0UsYUFBS0MsS0FBSztBQUFFLGVBQUtDLFVBQUwsR0FBa0JELENBQWxCO0FBQXNCLFNBRHBDO0FBRUUsbUJBQVcsS0FBS3ZELEtBQUwsQ0FBV3lELFNBRnhCO0FBR0Usa0JBQVUsS0FBS0M7QUFIakIsU0FJTWQsU0FKTixFQWJGO0FBbUJFO0FBQUE7QUFBQTtBQUNFLG1CQUFTLEtBQUs1QyxLQUFMLENBQVcyRCxRQUR0QjtBQUVFLGtCQUFRLE1BQU0sS0FBS0gsVUFGckI7QUFHRSxtQkFBUSxPQUhWO0FBSUUscUJBQVUsNENBSlo7QUFLRTtBQUNFLHFCQUFXLEtBQUt4RCxLQUFMLENBQVd5RCxTQUR4QjtBQUVFLCtCQUFxQixLQUFLekQsS0FBTCxDQUFXNEQsbUJBRmxDO0FBR0UsMkJBQWlCLEtBQUs1RCxLQUFMLENBQVdnRCxlQUg5QjtBQUlFLG9CQUFVLEtBQUtVO0FBSmpCLFdBS01kLFNBTE47QUFMRixPQW5CRjtBQWdDRTtBQUNFLGFBQUtXLEtBQUs7QUFBRSxlQUFLTSxZQUFMLEdBQW9CTixDQUFwQjtBQUF3QixTQUR0QztBQUVFLHdCQUFnQixLQUFLN0IsS0FBTCxDQUFXRSxjQUY3QjtBQUdFLHlCQUFpQixLQUFLRixLQUFMLENBQVdHO0FBSDlCLFNBSU1lLFNBSk4sRUFoQ0Y7QUFzQ0U7QUFBQTtBQUFBO0FBQ0UsbUJBQVMsS0FBSzVDLEtBQUwsQ0FBVzJELFFBRHRCO0FBRUUsa0JBQVEsTUFBTSxLQUFLRSxZQUZyQjtBQUdFLG1CQUFRLE9BSFY7QUFJRSxxQkFBVSw0Q0FKWjtBQUtFO0FBQ0UsOEJBQW9CLEtBQUtDLHdCQUQzQjtBQUVFLHFCQUFXLEtBQUs5RCxLQUFMLENBQVd5RCxTQUZ4QjtBQUdFLHNCQUFZLEtBQUsvQixLQUFMLENBQVdDLFVBSHpCO0FBSUUsd0JBQWMsQ0FBQyxDQUFDLEtBQUszQixLQUFMLENBQVdpQixZQUo3QjtBQUtFLGdCQUFNLEtBQUtrQyxJQUxiO0FBTUUsZ0JBQU0sS0FBS0QsSUFOYjtBQU9FLGlCQUFPLEtBQUtEO0FBUGQsV0FRTUwsU0FSTjtBQUxGO0FBdENGLEtBREY7QUF5REQ7O0FBR0RrQiwyQkFBeUJQLENBQXpCLEVBQTRCO0FBQzFCQSxTQUFLQSxFQUFFUSxjQUFGLEVBQUw7QUFDQSxTQUFLL0QsS0FBTCxDQUFXeUQsU0FBWCxDQUFxQk8sSUFBckIsQ0FBMEIsNkJBQTFCO0FBQ0Q7O0FBRURDLHFCQUFtQkMsS0FBbkIsRUFBMEY7QUFBQTs7QUFBQSxvRkFBMUMsRUFBQ2YsTUFBTSxLQUFQLEVBQWNELE1BQU0sS0FBcEIsRUFBMkJELE9BQU8sS0FBbEMsRUFBMEM7O0FBQUEsUUFBL0RFLElBQStELFNBQS9EQSxJQUErRDtBQUFBLFFBQXpERCxJQUF5RCxTQUF6REEsSUFBeUQ7QUFBQSxRQUFuREQsS0FBbUQsU0FBbkRBLEtBQW1EOztBQUN4RixXQUFPLElBQUlrQixPQUFKLENBQVksQ0FBQ0MsT0FBRCxFQUFVQyxNQUFWLEtBQXFCO0FBQ3RDLFVBQUksS0FBSzNDLEtBQUwsQ0FBV0MsVUFBZixFQUEyQjtBQUN6QnlDO0FBQ0E7QUFDRDs7QUFFRCxXQUFLRSxRQUFMLENBQWMsRUFBQzNDLFlBQVksSUFBYixFQUFtQkMsZ0JBQWdCdUIsSUFBbkMsRUFBeUN0QixpQkFBaUJxQixRQUFRRCxLQUFsRSxFQUFkLG9CQUF3RixhQUFZO0FBQ2xHLFlBQUk7QUFDRixnQkFBTWlCLE9BQU47QUFDRCxTQUZELENBRUUsT0FBT1gsQ0FBUCxFQUFVO0FBQ1ZjLGlCQUFPZCxDQUFQO0FBQ0QsU0FKRCxTQUlVO0FBQ1IsZ0JBQUtlLFFBQUwsQ0FBYyxFQUFDM0MsWUFBWSxLQUFiLEVBQW9CQyxnQkFBZ0IsS0FBcEMsRUFBMkNDLGlCQUFpQixLQUE1RCxFQUFkLEVBQWtGdUMsT0FBbEY7QUFDRDtBQUNGLE9BUkQ7QUFTRCxLQWZNLENBQVA7QUFnQkQ7O0FBRUtHLHFCQUFOLENBQTBCQyxTQUExQixFQUEwRjtBQUFBOztBQUFBLFFBQXJEQyxjQUFxRCx1RUFBcEM7QUFBQSxhQUFVLEVBQUNDLFNBQVNDLE1BQU1DLE1BQWhCLEVBQVY7QUFBQSxLQUFvQztBQUFBO0FBQ3hGLFlBQU1DLG1CQUFtQkwsV0FBekI7QUFDQSxVQUFJO0FBQ0YsZUFBTyxNQUFNSyxnQkFBYjtBQUNELE9BRkQsQ0FFRSxPQUFPRixLQUFQLEVBQWM7QUFDZCxZQUFJLEVBQUVBLDhDQUFGLENBQUosRUFBa0M7QUFBRSxnQkFBTUEsS0FBTjtBQUFjOztBQURwQyw4QkFHa0RGLGVBQWVFLEtBQWYsQ0FIbEQ7QUFBQSxvREFHUEcsa0JBSE87O0FBQUEsY0FHUEEsa0JBSE8seUNBR2MsVUFIZDtBQUFBLGNBRzBCSixPQUgxQixtQkFHMEJBLE9BSDFCO0FBQUEsY0FHbUNLLFdBSG5DLG1CQUdtQ0EsV0FIbkM7O0FBSWQsZUFBSy9FLEtBQUwsQ0FBVzRELG1CQUFYLENBQStCa0Isa0JBQS9CLEVBQ0VKLFdBQVcsb0NBRGIsRUFFRSxFQUFDSyxXQUFELEVBQWNDLGFBQWEsSUFBM0IsRUFGRjtBQUlBLGVBQU8sSUFBUDtBQUNEO0FBYnVGO0FBY3pGOztBQUdEdEIsV0FBU3VCLFVBQVQsRUFBcUJDLE9BQXJCLEVBQThCO0FBQzVCLFdBQU8sS0FBS2pCLGtCQUFMLENBQXdCLE1BQU0sS0FBS2pFLEtBQUwsQ0FBV0MsVUFBWCxDQUFzQnlELFFBQXRCLENBQStCdUIsVUFBL0IsRUFBMkNDLE9BQTNDLENBQTlCLENBQVA7QUFDRDs7QUFHSy9CLE1BQU4sUUFBaUM7QUFBQTs7QUFBQSxRQUFyQkMsS0FBcUIsU0FBckJBLEtBQXFCO0FBQUEsUUFBZEMsV0FBYyxTQUFkQSxXQUFjO0FBQUE7QUFDL0IsWUFBTSxPQUFLa0IsbUJBQUwsQ0FDSjtBQUFBLGVBQU0sT0FBS1ksTUFBTCxDQUFZLEVBQUMvQixLQUFELEVBQVFDLFdBQVIsRUFBWixDQUFOO0FBQUEsT0FESSxFQUVKLGlCQUFTO0FBQ1AsWUFBSSxnQ0FBZ0MrQixJQUFoQyxDQUFxQ1QsTUFBTUMsTUFBM0MsQ0FBSixFQUF3RDtBQUN0RCxpQkFBTztBQUNMRixxQkFBUyxlQURKO0FBRUxLLHlCQUFhLHFFQUNYO0FBSEcsV0FBUDtBQUtEOztBQUVELGVBQU8sRUFBQ0wsU0FBUyxnQkFBVixFQUE0QkssYUFBYyxRQUFPSixNQUFNQyxNQUFPLFFBQTlELEVBQVA7QUFDRCxPQVpHLENBQU47QUFEK0I7QUFlaEM7O0FBRUtPLFFBQU4sQ0FBYUQsT0FBYixFQUFzQjtBQUFBOztBQUFBO0FBQ3BCLFVBQUlBLFFBQVE5QixLQUFaLEVBQW1CO0FBQ2pCLGNBQU1pQyxTQUFTLE9BQUtyRixLQUFMLENBQVdzRixPQUFYLENBQW1CO0FBQ2hDWixtQkFBUyxzQ0FEdUI7QUFFaENhLDJCQUFpQiwyREFGZTtBQUdoQ0MsbUJBQVMsQ0FBQyxZQUFELEVBQWUsYUFBZjtBQUh1QixTQUFuQixDQUFmO0FBS0EsWUFBSUgsV0FBVyxDQUFmLEVBQWtCO0FBQUU7QUFBUztBQUM5Qjs7QUFFRCxZQUFNLE9BQUtwQixrQkFBTCxDQUF3QixZQUFNO0FBQ2xDLGVBQU8sT0FBS2pFLEtBQUwsQ0FBV0MsVUFBWCxDQUFzQmtELElBQXRCLENBQTJCLE9BQUtuRCxLQUFMLENBQVdHLGFBQVgsQ0FBeUJTLE9BQXpCLEVBQTNCLEVBQStEc0UsT0FBL0QsQ0FBUDtBQUNELE9BRkssRUFFSCxFQUFDL0IsTUFBTSxJQUFQLEVBRkcsQ0FBTjtBQVZvQjtBQWFyQjs7QUFHS0QsTUFBTixHQUFhO0FBQUE7O0FBQUE7QUFDWCxZQUFNLE9BQUtxQixtQkFBTCxDQUNKO0FBQUEsZUFBTSxPQUFLa0IsTUFBTCxFQUFOO0FBQUEsT0FESSxFQUVKLGlCQUFTO0FBQ1AsWUFBSSxpRkFBaUZMLElBQWpGLENBQXNGVCxNQUFNQyxNQUE1RixDQUFKLEVBQXlHO0FBQ3ZHLGdCQUFNYyxRQUFRZixNQUFNQyxNQUFOLENBQWFlLEtBQWIsQ0FBbUIsSUFBbkIsQ0FBZDtBQUNBLGdCQUFNQyxRQUFRRixNQUFNRyxLQUFOLENBQVksQ0FBWixFQUFlSCxNQUFNcEUsTUFBTixHQUFlLENBQTlCLEVBQWlDd0UsR0FBakMsQ0FBcUM7QUFBQSxtQkFBTSxLQUFJQyxFQUFFQyxJQUFGLEVBQVMsSUFBbkI7QUFBQSxXQUFyQyxFQUE2REMsSUFBN0QsQ0FBa0UsTUFBbEUsQ0FBZDtBQUNBLGlCQUFPO0FBQ0x2QixxQkFBUyxjQURKO0FBRUxLLHlCQUFhLHNFQUFzRWEsS0FBdEUsR0FDWDtBQUhHLFdBQVA7QUFLRCxTQVJELE1BUU8sSUFBSSxvRUFBb0VSLElBQXBFLENBQXlFVCxNQUFNdUIsTUFBL0UsQ0FBSixFQUE0RjtBQUNqRyxpQkFBS2xHLEtBQUwsQ0FBV21HLG1CQUFYO0FBQ0EsaUJBQU87QUFDTHJCLGdDQUFvQixZQURmO0FBRUxKLHFCQUFTLGlCQUZKO0FBR0xLLHlCQUFjOztBQUhULFdBQVA7QUFNRDs7QUFFRCxlQUFPLEVBQUNMLFNBQVMsZ0JBQVYsRUFBNEJLLGFBQWMsUUFBT0osTUFBTUMsTUFBTyxRQUE5RCxFQUFQO0FBQ0QsT0F0QkcsQ0FBTjtBQURXO0FBMEJaOztBQUVLYSxRQUFOLEdBQWU7QUFBQTs7QUFBQTtBQUNiLFlBQU0sT0FBS3hCLGtCQUFMLENBQXdCO0FBQUEsZUFBTSxPQUFLakUsS0FBTCxDQUFXQyxVQUFYLENBQXNCaUQsSUFBdEIsQ0FBMkIsT0FBS2xELEtBQUwsQ0FBV0csYUFBWCxDQUF5QlMsT0FBekIsRUFBM0IsQ0FBTjtBQUFBLE9BQXhCLEVBQThGLEVBQUNzQyxNQUFNLElBQVAsRUFBOUYsQ0FBTjtBQURhO0FBRWQ7O0FBR0tELE9BQU4sR0FBYztBQUFBOztBQUFBO0FBQ1osWUFBTSxPQUFLc0IsbUJBQUwsQ0FDSjtBQUFBLGVBQU0sT0FBSzZCLE9BQUwsRUFBTjtBQUFBLE9BREksRUFFSixpQkFBUztBQUNQLGVBQU87QUFDTDFCLG1CQUFTLGlCQURKO0FBRUxLLHVCQUFjLFFBQU9KLE1BQU1DLE1BQU87QUFGN0IsU0FBUDtBQUlELE9BUEcsQ0FBTjtBQURZO0FBVWI7O0FBRUt3QixTQUFOLEdBQWdCO0FBQUE7O0FBQUE7QUFDZCxZQUFNLE9BQUtuQyxrQkFBTCxDQUF3QjtBQUFBLGVBQU0sT0FBS2pFLEtBQUwsQ0FBV0MsVUFBWCxDQUFzQmdELEtBQXRCLENBQTRCLE9BQUtqRCxLQUFMLENBQVdHLGFBQVgsQ0FBeUJTLE9BQXpCLEVBQTVCLENBQU47QUFBQSxPQUF4QixFQUErRixFQUFDcUMsT0FBTyxJQUFSLEVBQS9GLENBQU47QUFEYztBQUVmO0FBalJrRSxDLFVBQzVEb0QsUyxHQUFZO0FBQ2pCNUMsYUFBVyxvQkFBVTZDLE1BQVYsQ0FBaUJDLFVBRFg7QUFFakIzQyx1QkFBcUIsb0JBQVUwQyxNQUFWLENBQWlCQyxVQUZyQjtBQUdqQnZELG1CQUFpQixvQkFBVXNELE1BQVYsQ0FBaUJDLFVBSGpCO0FBSWpCNUMsWUFBVSxvQkFBVTJDLE1BQVYsQ0FBaUJDLFVBSlY7QUFLakJqQixXQUFTLG9CQUFVa0IsSUFBVixDQUFlRCxVQUxQO0FBTWpCdEcsY0FBWSxvQkFBVXFHLE1BQVYsQ0FBaUJDLFVBTlo7QUFPakJwRyxpQkFBZSwyQkFBZW9HLFVBUGI7QUFRakJsRyxZQUFVLG9CQUFVb0csT0FBViw2QkFBa0NGLFVBUjNCO0FBU2pCOUYsaUJBQWUsMkJBQWU4RixVQVRiO0FBVWpCMUYsY0FBWSxvQkFBVTZGLE1BVkw7QUFXakIzRixlQUFhLG9CQUFVMkYsTUFYTjtBQVlqQm5HLDJCQUF5QixvQkFBVStGLE1BWmxCO0FBYWpCckYsZ0JBQWMsb0JBQVUwRixJQWJQO0FBY2pCN0QsZ0JBQWMsb0JBQVUwRCxJQWRQO0FBZWpCTCx1QkFBcUIsb0JBQVVLO0FBZmQsQyxVQWtCWkksWSxHQUFlO0FBQ3BCekcsbUNBRG9CO0FBRXBCRSxZQUFVLEVBRlU7QUFHcEJJLG1DQUhvQjtBQUlwQnFDLGdCQUFjLE1BQU0sQ0FBRTtBQUpGLEM7a0JBbkJIaEQsdUIiLCJmaWxlIjoic3RhdHVzLWJhci10aWxlLWNvbnRyb2xsZXIuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuaW1wb3J0IHtHaXRFcnJvcn0gZnJvbSAnLi4vZ2l0LXNoZWxsLW91dC1zdHJhdGVneSc7XG5pbXBvcnQgT2JzZXJ2ZU1vZGVsRGVjb3JhdG9yIGZyb20gJy4uL2RlY29yYXRvcnMvb2JzZXJ2ZS1tb2RlbCc7XG5pbXBvcnQge0JyYW5jaFByb3BUeXBlLCBSZW1vdGVQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQgQnJhbmNoVmlldyBmcm9tICcuLi92aWV3cy9icmFuY2gtdmlldyc7XG5pbXBvcnQgQnJhbmNoTWVudVZpZXcgZnJvbSAnLi4vdmlld3MvYnJhbmNoLW1lbnUtdmlldyc7XG5pbXBvcnQgUHVzaFB1bGxWaWV3IGZyb20gJy4uL3ZpZXdzL3B1c2gtcHVsbC12aWV3JztcbmltcG9ydCBQdXNoUHVsbE1lbnVWaWV3IGZyb20gJy4uL3ZpZXdzL3B1c2gtcHVsbC1tZW51LXZpZXcnO1xuaW1wb3J0IENoYW5nZWRGaWxlc0NvdW50VmlldyBmcm9tICcuLi92aWV3cy9jaGFuZ2VkLWZpbGVzLWNvdW50LXZpZXcnO1xuaW1wb3J0IFRvb2x0aXAgZnJvbSAnLi4vdmlld3MvdG9vbHRpcCc7XG5pbXBvcnQgQ29tbWFuZHMsIHtDb21tYW5kfSBmcm9tICcuLi92aWV3cy9jb21tYW5kcyc7XG5pbXBvcnQge251bGxCcmFuY2h9IGZyb20gJy4uL21vZGVscy9icmFuY2gnO1xuaW1wb3J0IHtudWxsUmVtb3RlfSBmcm9tICcuLi9tb2RlbHMvcmVtb3RlJztcbmltcG9ydCB5dWJpa2lyaSBmcm9tICd5dWJpa2lyaSc7XG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICdjb3JlLWRlY29yYXRvcnMnO1xuXG5AT2JzZXJ2ZU1vZGVsRGVjb3JhdG9yKHtcbiAgZ2V0TW9kZWw6IHByb3BzID0+IHByb3BzLnJlcG9zaXRvcnksXG4gIGZldGNoRGF0YTogcmVwb3NpdG9yeSA9PiB7XG4gICAgcmV0dXJuIHl1YmlraXJpKHtcbiAgICAgIGN1cnJlbnRCcmFuY2g6IHJlcG9zaXRvcnkuZ2V0Q3VycmVudEJyYW5jaCgpLFxuICAgICAgYnJhbmNoZXM6IHJlcG9zaXRvcnkuZ2V0QnJhbmNoZXMoKSxcbiAgICAgIHN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzOiByZXBvc2l0b3J5LmdldFN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzKCksXG4gICAgICBjdXJyZW50UmVtb3RlOiBhc3luYyBxdWVyeSA9PiByZXBvc2l0b3J5LmdldFJlbW90ZUZvckJyYW5jaCgoYXdhaXQgcXVlcnkuY3VycmVudEJyYW5jaCkuZ2V0TmFtZSgpKSxcbiAgICAgIGFoZWFkQ291bnQ6IGFzeW5jIHF1ZXJ5ID0+IHJlcG9zaXRvcnkuZ2V0QWhlYWRDb3VudCgoYXdhaXQgcXVlcnkuY3VycmVudEJyYW5jaCkuZ2V0TmFtZSgpKSxcbiAgICAgIGJlaGluZENvdW50OiBhc3luYyBxdWVyeSA9PiByZXBvc2l0b3J5LmdldEJlaGluZENvdW50KChhd2FpdCBxdWVyeS5jdXJyZW50QnJhbmNoKS5nZXROYW1lKCkpLFxuICAgICAgb3JpZ2luRXhpc3RzOiBhc3luYyAoKSA9PiB7XG4gICAgICAgIGNvbnN0IHJlbW90ZXMgPSBhd2FpdCByZXBvc2l0b3J5LmdldFJlbW90ZXMoKTtcbiAgICAgICAgcmV0dXJuIHJlbW90ZXMuZmlsdGVyKHJlbW90ZSA9PiByZW1vdGUuZ2V0TmFtZSgpID09PSAnb3JpZ2luJykubGVuZ3RoID4gMDtcbiAgICAgIH0sXG4gICAgfSk7XG4gIH0sXG59KVxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3RhdHVzQmFyVGlsZUNvbnRyb2xsZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHdvcmtzcGFjZTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb21tYW5kUmVnaXN0cnk6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICB0b29sdGlwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbmZpcm06IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgcmVwb3NpdG9yeTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGN1cnJlbnRCcmFuY2g6IEJyYW5jaFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgYnJhbmNoZXM6IFByb3BUeXBlcy5hcnJheU9mKEJyYW5jaFByb3BUeXBlKS5pc1JlcXVpcmVkLFxuICAgIGN1cnJlbnRSZW1vdGU6IFJlbW90ZVByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgYWhlYWRDb3VudDogUHJvcFR5cGVzLm51bWJlcixcbiAgICBiZWhpbmRDb3VudDogUHJvcFR5cGVzLm51bWJlcixcbiAgICBzdGF0dXNlc0ZvckNoYW5nZWRGaWxlczogUHJvcFR5cGVzLm9iamVjdCxcbiAgICBvcmlnaW5FeGlzdHM6IFByb3BUeXBlcy5ib29sLFxuICAgIHRvZ2dsZUdpdFRhYjogUHJvcFR5cGVzLmZ1bmMsXG4gICAgZW5zdXJlR2l0VGFiVmlzaWJsZTogUHJvcFR5cGVzLmZ1bmMsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGN1cnJlbnRCcmFuY2g6IG51bGxCcmFuY2gsXG4gICAgYnJhbmNoZXM6IFtdLFxuICAgIGN1cnJlbnRSZW1vdGU6IG51bGxSZW1vdGUsXG4gICAgdG9nZ2xlR2l0VGFiOiAoKSA9PiB7fSxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzLCBjb250ZXh0KSB7XG4gICAgc3VwZXIocHJvcHMsIGNvbnRleHQpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGluUHJvZ3Jlc3M6IGZhbHNlLFxuICAgICAgcHVzaEluUHJvZ3Jlc3M6IGZhbHNlLFxuICAgICAgZmV0Y2hJblByb2dyZXNzOiBmYWxzZSxcbiAgICB9O1xuICB9XG5cbiAgZ2V0Q2hhbmdlZEZpbGVzQ291bnQoKSB7XG4gICAgY29uc3Qge3N0YWdlZEZpbGVzLCB1bnN0YWdlZEZpbGVzLCBtZXJnZUNvbmZsaWN0RmlsZXN9ID0gdGhpcy5wcm9wcy5zdGF0dXNlc0ZvckNoYW5nZWRGaWxlcztcbiAgICBjb25zdCBjaGFuZ2VkRmlsZXMgPSBuZXcgU2V0KCk7XG5cbiAgICBmb3IgKGNvbnN0IGZpbGVQYXRoIGluIHVuc3RhZ2VkRmlsZXMpIHtcbiAgICAgIGNoYW5nZWRGaWxlcy5hZGQoZmlsZVBhdGgpO1xuICAgIH1cbiAgICBmb3IgKGNvbnN0IGZpbGVQYXRoIGluIHN0YWdlZEZpbGVzKSB7XG4gICAgICBjaGFuZ2VkRmlsZXMuYWRkKGZpbGVQYXRoKTtcbiAgICB9XG4gICAgZm9yIChjb25zdCBmaWxlUGF0aCBpbiBtZXJnZUNvbmZsaWN0RmlsZXMpIHtcbiAgICAgIGNoYW5nZWRGaWxlcy5hZGQoZmlsZVBhdGgpO1xuICAgIH1cblxuICAgIHJldHVybiBjaGFuZ2VkRmlsZXMuc2l6ZTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBsZXQgY2hhbmdlZEZpbGVzQ291bnQsIG1lcmdlQ29uZmxpY3RzUHJlc2VudDtcbiAgICBpZiAodGhpcy5wcm9wcy5zdGF0dXNlc0ZvckNoYW5nZWRGaWxlcykge1xuICAgICAgY2hhbmdlZEZpbGVzQ291bnQgPSB0aGlzLmdldENoYW5nZWRGaWxlc0NvdW50KCk7XG4gICAgICBtZXJnZUNvbmZsaWN0c1ByZXNlbnQgPSBPYmplY3Qua2V5cyh0aGlzLnByb3BzLnN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzLm1lcmdlQ29uZmxpY3RGaWxlcykubGVuZ3RoID4gMDtcbiAgICB9XG5cbiAgICBjb25zdCByZXBvUHJvcHMgPSB7XG4gICAgICByZXBvc2l0b3J5OiB0aGlzLnByb3BzLnJlcG9zaXRvcnksXG4gICAgICBjdXJyZW50QnJhbmNoOiB0aGlzLnByb3BzLmN1cnJlbnRCcmFuY2gsXG4gICAgICBicmFuY2hlczogdGhpcy5wcm9wcy5icmFuY2hlcyxcbiAgICAgIGN1cnJlbnRSZW1vdGU6IHRoaXMucHJvcHMuY3VycmVudFJlbW90ZSxcbiAgICAgIGFoZWFkQ291bnQ6IHRoaXMucHJvcHMuYWhlYWRDb3VudCxcbiAgICAgIGJlaGluZENvdW50OiB0aGlzLnByb3BzLmJlaGluZENvdW50LFxuICAgICAgY2hhbmdlZEZpbGVzQ291bnQsXG4gICAgICBtZXJnZUNvbmZsaWN0c1ByZXNlbnQsXG4gICAgfTtcblxuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1TdGF0dXNCYXJUaWxlQ29udHJvbGxlclwiPlxuICAgICAgICB7dGhpcy5yZW5kZXJUaWxlcyhyZXBvUHJvcHMpfVxuICAgICAgICA8Q2hhbmdlZEZpbGVzQ291bnRWaWV3XG4gICAgICAgICAgZGlkQ2xpY2s9e3RoaXMucHJvcHMudG9nZ2xlR2l0VGFifVxuICAgICAgICAgIHsuLi5yZXBvUHJvcHN9XG4gICAgICAgIC8+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyVGlsZXMocmVwb1Byb3BzKSB7XG4gICAgaWYgKCF0aGlzLnByb3BzLnJlcG9zaXRvcnkuc2hvd1N0YXR1c0JhclRpbGVzKCkpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIHJldHVybiAoXG4gICAgICA8c3Bhbj5cbiAgICAgICAgPENvbW1hbmRzIHJlZ2lzdHJ5PXt0aGlzLnByb3BzLmNvbW1hbmRSZWdpc3RyeX0gdGFyZ2V0PVwiYXRvbS13b3Jrc3BhY2VcIj5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiZ2l0aHViOmZldGNoXCIgY2FsbGJhY2s9e3RoaXMuZmV0Y2h9IC8+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpwdWxsXCIgY2FsbGJhY2s9e3RoaXMucHVsbH0gLz5cbiAgICAgICAgICA8Q29tbWFuZFxuICAgICAgICAgICAgY29tbWFuZD1cImdpdGh1YjpwdXNoXCJcbiAgICAgICAgICAgIGNhbGxiYWNrPXsoKSA9PiB0aGlzLnB1c2goe2ZvcmNlOiBmYWxzZSwgc2V0VXBzdHJlYW06ICF0aGlzLnByb3BzLmN1cnJlbnRSZW1vdGUuaXNQcmVzZW50KCl9KX1cbiAgICAgICAgICAvPlxuICAgICAgICAgIDxDb21tYW5kXG4gICAgICAgICAgICBjb21tYW5kPVwiZ2l0aHViOmZvcmNlLXB1c2hcIlxuICAgICAgICAgICAgY2FsbGJhY2s9eygpID0+IHRoaXMucHVzaCh7Zm9yY2U6IHRydWUsIHNldFVwc3RyZWFtOiAhdGhpcy5wcm9wcy5jdXJyZW50UmVtb3RlLmlzUHJlc2VudCgpfSl9XG4gICAgICAgICAgLz5cbiAgICAgICAgPC9Db21tYW5kcz5cbiAgICAgICAgPEJyYW5jaFZpZXdcbiAgICAgICAgICByZWY9e2UgPT4geyB0aGlzLmJyYW5jaFZpZXcgPSBlOyB9fVxuICAgICAgICAgIHdvcmtzcGFjZT17dGhpcy5wcm9wcy53b3Jrc3BhY2V9XG4gICAgICAgICAgY2hlY2tvdXQ9e3RoaXMuY2hlY2tvdXR9XG4gICAgICAgICAgey4uLnJlcG9Qcm9wc31cbiAgICAgICAgLz5cbiAgICAgICAgPFRvb2x0aXBcbiAgICAgICAgICBtYW5hZ2VyPXt0aGlzLnByb3BzLnRvb2x0aXBzfVxuICAgICAgICAgIHRhcmdldD17KCkgPT4gdGhpcy5icmFuY2hWaWV3fVxuICAgICAgICAgIHRyaWdnZXI9XCJjbGlja1wiXG4gICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVN0YXR1c0JhclRpbGVDb250cm9sbGVyLXRvb2x0aXBNZW51XCI+XG4gICAgICAgICAgPEJyYW5jaE1lbnVWaWV3XG4gICAgICAgICAgICB3b3Jrc3BhY2U9e3RoaXMucHJvcHMud29ya3NwYWNlfVxuICAgICAgICAgICAgbm90aWZpY2F0aW9uTWFuYWdlcj17dGhpcy5wcm9wcy5ub3RpZmljYXRpb25NYW5hZ2VyfVxuICAgICAgICAgICAgY29tbWFuZFJlZ2lzdHJ5PXt0aGlzLnByb3BzLmNvbW1hbmRSZWdpc3RyeX1cbiAgICAgICAgICAgIGNoZWNrb3V0PXt0aGlzLmNoZWNrb3V0fVxuICAgICAgICAgICAgey4uLnJlcG9Qcm9wc31cbiAgICAgICAgICAvPlxuICAgICAgICA8L1Rvb2x0aXA+XG4gICAgICAgIDxQdXNoUHVsbFZpZXdcbiAgICAgICAgICByZWY9e2UgPT4geyB0aGlzLnB1c2hQdWxsVmlldyA9IGU7IH19XG4gICAgICAgICAgcHVzaEluUHJvZ3Jlc3M9e3RoaXMuc3RhdGUucHVzaEluUHJvZ3Jlc3N9XG4gICAgICAgICAgZmV0Y2hJblByb2dyZXNzPXt0aGlzLnN0YXRlLmZldGNoSW5Qcm9ncmVzc31cbiAgICAgICAgICB7Li4ucmVwb1Byb3BzfVxuICAgICAgICAvPlxuICAgICAgICA8VG9vbHRpcFxuICAgICAgICAgIG1hbmFnZXI9e3RoaXMucHJvcHMudG9vbHRpcHN9XG4gICAgICAgICAgdGFyZ2V0PXsoKSA9PiB0aGlzLnB1c2hQdWxsVmlld31cbiAgICAgICAgICB0cmlnZ2VyPVwiY2xpY2tcIlxuICAgICAgICAgIGNsYXNzTmFtZT1cImdpdGh1Yi1TdGF0dXNCYXJUaWxlQ29udHJvbGxlci10b29sdGlwTWVudVwiPlxuICAgICAgICAgIDxQdXNoUHVsbE1lbnVWaWV3XG4gICAgICAgICAgICBvbk1hcmtTcGVjaWFsQ2xpY2s9e3RoaXMuaGFuZGxlT3BlbkdpdFRpbWluZ3NWaWV3fVxuICAgICAgICAgICAgd29ya3NwYWNlPXt0aGlzLnByb3BzLndvcmtzcGFjZX1cbiAgICAgICAgICAgIGluUHJvZ3Jlc3M9e3RoaXMuc3RhdGUuaW5Qcm9ncmVzc31cbiAgICAgICAgICAgIG9yaWdpbkV4aXN0cz17ISF0aGlzLnByb3BzLm9yaWdpbkV4aXN0c31cbiAgICAgICAgICAgIHB1c2g9e3RoaXMucHVzaH1cbiAgICAgICAgICAgIHB1bGw9e3RoaXMucHVsbH1cbiAgICAgICAgICAgIGZldGNoPXt0aGlzLmZldGNofVxuICAgICAgICAgICAgey4uLnJlcG9Qcm9wc31cbiAgICAgICAgICAvPlxuICAgICAgICA8L1Rvb2x0aXA+XG4gICAgICA8L3NwYW4+XG4gICAgKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVPcGVuR2l0VGltaW5nc1ZpZXcoZSkge1xuICAgIGUgJiYgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgIHRoaXMucHJvcHMud29ya3NwYWNlLm9wZW4oJ2F0b20tZ2l0aHViOi8vZGVidWcvdGltaW5ncycpO1xuICB9XG5cbiAgc2V0SW5Qcm9ncmVzc1doaWxlKGJsb2NrLCB7cHVzaCwgcHVsbCwgZmV0Y2h9ID0ge3B1c2g6IGZhbHNlLCBwdWxsOiBmYWxzZSwgZmV0Y2g6IGZhbHNlfSkge1xuICAgIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgICBpZiAodGhpcy5zdGF0ZS5pblByb2dyZXNzKSB7XG4gICAgICAgIHJlc29sdmUoKTtcbiAgICAgICAgcmV0dXJuO1xuICAgICAgfVxuXG4gICAgICB0aGlzLnNldFN0YXRlKHtpblByb2dyZXNzOiB0cnVlLCBwdXNoSW5Qcm9ncmVzczogcHVzaCwgZmV0Y2hJblByb2dyZXNzOiBwdWxsIHx8IGZldGNofSwgYXN5bmMgKCkgPT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgIGF3YWl0IGJsb2NrKCk7XG4gICAgICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgICByZWplY3QoZSk7XG4gICAgICAgIH0gZmluYWxseSB7XG4gICAgICAgICAgdGhpcy5zZXRTdGF0ZSh7aW5Qcm9ncmVzczogZmFsc2UsIHB1c2hJblByb2dyZXNzOiBmYWxzZSwgZmV0Y2hJblByb2dyZXNzOiBmYWxzZX0sIHJlc29sdmUpO1xuICAgICAgICB9XG4gICAgICB9KTtcbiAgICB9KTtcbiAgfVxuXG4gIGFzeW5jIGF0dGVtcHRHaXRPcGVyYXRpb24ob3BlcmF0aW9uLCBlcnJvclRyYW5zZm9ybSA9IGVycm9yID0+ICh7bWVzc2FnZTogZXJyb3Iuc3RkRXJyfSkpIHtcbiAgICBjb25zdCBvcGVyYXRpb25Qcm9taXNlID0gb3BlcmF0aW9uKCk7XG4gICAgdHJ5IHtcbiAgICAgIHJldHVybiBhd2FpdCBvcGVyYXRpb25Qcm9taXNlO1xuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICBpZiAoIShlcnJvciBpbnN0YW5jZW9mIEdpdEVycm9yKSkgeyB0aHJvdyBlcnJvcjsgfVxuXG4gICAgICBjb25zdCB7bm90aWZpY2F0aW9uTWV0aG9kID0gJ2FkZEVycm9yJywgbWVzc2FnZSwgZGVzY3JpcHRpb259ID0gZXJyb3JUcmFuc2Zvcm0oZXJyb3IpO1xuICAgICAgdGhpcy5wcm9wcy5ub3RpZmljYXRpb25NYW5hZ2VyW25vdGlmaWNhdGlvbk1ldGhvZF0oXG4gICAgICAgIG1lc3NhZ2UgfHwgJ0Nhbm5vdCBjb21wbGV0ZSByZW1vdGUgaW50ZXJhY3Rpb24nLFxuICAgICAgICB7ZGVzY3JpcHRpb24sIGRpc21pc3NhYmxlOiB0cnVlfSxcbiAgICAgICk7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgY2hlY2tvdXQoYnJhbmNoTmFtZSwgb3B0aW9ucykge1xuICAgIHJldHVybiB0aGlzLnNldEluUHJvZ3Jlc3NXaGlsZSgoKSA9PiB0aGlzLnByb3BzLnJlcG9zaXRvcnkuY2hlY2tvdXQoYnJhbmNoTmFtZSwgb3B0aW9ucykpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGFzeW5jIHB1c2goe2ZvcmNlLCBzZXRVcHN0cmVhbX0pIHtcbiAgICBhd2FpdCB0aGlzLmF0dGVtcHRHaXRPcGVyYXRpb24oXG4gICAgICAoKSA9PiB0aGlzLmRvUHVzaCh7Zm9yY2UsIHNldFVwc3RyZWFtfSksXG4gICAgICBlcnJvciA9PiB7XG4gICAgICAgIGlmICgvcmVqZWN0ZWRbXFxzXFxTXSpmYWlsZWQgdG8gcHVzaC8udGVzdChlcnJvci5zdGRFcnIpKSB7XG4gICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG1lc3NhZ2U6ICdQdXNoIHJlamVjdGVkJyxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiAnVGhlIHRpcCBvZiB5b3VyIGN1cnJlbnQgYnJhbmNoIGlzIGJlaGluZCBpdHMgcmVtb3RlIGNvdW50ZXJwYXJ0LicgK1xuICAgICAgICAgICAgICAnIFRyeSBwdWxsaW5nIGJlZm9yZSBwdXNoaW5nIGFnYWluLiBPciwgdG8gZm9yY2UgcHVzaCwgaG9sZCBgY21kYCBvciBgY3RybGAgd2hpbGUgY2xpY2tpbmcuJyxcbiAgICAgICAgICB9O1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIHttZXNzYWdlOiAnVW5hYmxlIHRvIHB1c2gnLCBkZXNjcmlwdGlvbjogYDxwcmU+JHtlcnJvci5zdGRFcnJ9PC9wcmU+YH07XG4gICAgICB9LFxuICAgICk7XG4gIH1cblxuICBhc3luYyBkb1B1c2gob3B0aW9ucykge1xuICAgIGlmIChvcHRpb25zLmZvcmNlKSB7XG4gICAgICBjb25zdCBjaG9pY2UgPSB0aGlzLnByb3BzLmNvbmZpcm0oe1xuICAgICAgICBtZXNzYWdlOiAnQXJlIHlvdSBzdXJlIHlvdSB3YW50IHRvIGZvcmNlIHB1c2g/JyxcbiAgICAgICAgZGV0YWlsZWRNZXNzYWdlOiAnVGhpcyBvcGVyYXRpb24gY291bGQgcmVzdWx0IGluIGxvc2luZyBkYXRhIG9uIHRoZSByZW1vdGUuJyxcbiAgICAgICAgYnV0dG9uczogWydGb3JjZSBQdXNoJywgJ0NhbmNlbCBQdXNoJ10sXG4gICAgICB9KTtcbiAgICAgIGlmIChjaG9pY2UgIT09IDApIHsgcmV0dXJuOyB9XG4gICAgfVxuXG4gICAgYXdhaXQgdGhpcy5zZXRJblByb2dyZXNzV2hpbGUoKCkgPT4ge1xuICAgICAgcmV0dXJuIHRoaXMucHJvcHMucmVwb3NpdG9yeS5wdXNoKHRoaXMucHJvcHMuY3VycmVudEJyYW5jaC5nZXROYW1lKCksIG9wdGlvbnMpO1xuICAgIH0sIHtwdXNoOiB0cnVlfSk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgYXN5bmMgcHVsbCgpIHtcbiAgICBhd2FpdCB0aGlzLmF0dGVtcHRHaXRPcGVyYXRpb24oXG4gICAgICAoKSA9PiB0aGlzLmRvUHVsbCgpLFxuICAgICAgZXJyb3IgPT4ge1xuICAgICAgICBpZiAoL2Vycm9yOiBZb3VyIGxvY2FsIGNoYW5nZXMgdG8gdGhlIGZvbGxvd2luZyBmaWxlcyB3b3VsZCBiZSBvdmVyd3JpdHRlbiBieSBtZXJnZS8udGVzdChlcnJvci5zdGRFcnIpKSB7XG4gICAgICAgICAgY29uc3QgbGluZXMgPSBlcnJvci5zdGRFcnIuc3BsaXQoJ1xcbicpO1xuICAgICAgICAgIGNvbnN0IGZpbGVzID0gbGluZXMuc2xpY2UoMywgbGluZXMubGVuZ3RoIC0gMykubWFwKGwgPT4gYFxcYCR7bC50cmltKCl9XFxgYCkuam9pbignPGJyPicpO1xuICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBtZXNzYWdlOiAnUHVsbCBhYm9ydGVkJyxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiAnTG9jYWwgY2hhbmdlcyB0byB0aGUgZm9sbG93aW5nIHdvdWxkIGJlIG92ZXJ3cml0dGVuIGJ5IG1lcmdlOjxicj4nICsgZmlsZXMgK1xuICAgICAgICAgICAgICAnPGJyPlBsZWFzZSBjb21taXQgeW91ciBjaGFuZ2VzIG9yIHN0YXNoIHRoZW0gYmVmb3JlIHlvdSBtZXJnZS4nLFxuICAgICAgICAgIH07XG4gICAgICAgIH0gZWxzZSBpZiAoL0F1dG9tYXRpYyBtZXJnZSBmYWlsZWQ7IGZpeCBjb25mbGljdHMgYW5kIHRoZW4gY29tbWl0IHRoZSByZXN1bHQuLy50ZXN0KGVycm9yLnN0ZE91dCkpIHtcbiAgICAgICAgICB0aGlzLnByb3BzLmVuc3VyZUdpdFRhYlZpc2libGUoKTtcbiAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbm90aWZpY2F0aW9uTWV0aG9kOiAnYWRkV2FybmluZycsXG4gICAgICAgICAgICBtZXNzYWdlOiAnTWVyZ2UgY29uZmxpY3RzJyxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiBgWW91ciBsb2NhbCBjaGFuZ2VzIGNvbmZsaWN0ZWQgd2l0aCBjaGFuZ2VzIG1hZGUgb24gdGhlIHJlbW90ZSBicmFuY2guIFJlc29sdmUgdGhlIGNvbmZsaWN0c1xuICAgICAgICAgICAgICB3aXRoIHRoZSBHaXQgcGFuZWwgYW5kIGNvbW1pdCB0byBjb250aW51ZS5gLFxuICAgICAgICAgIH07XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4ge21lc3NhZ2U6ICdVbmFibGUgdG8gcHVsbCcsIGRlc2NyaXB0aW9uOiBgPHByZT4ke2Vycm9yLnN0ZEVycn08L3ByZT5gfTtcbiAgICAgIH0sXG4gICAgKTtcblxuICB9XG5cbiAgYXN5bmMgZG9QdWxsKCkge1xuICAgIGF3YWl0IHRoaXMuc2V0SW5Qcm9ncmVzc1doaWxlKCgpID0+IHRoaXMucHJvcHMucmVwb3NpdG9yeS5wdWxsKHRoaXMucHJvcHMuY3VycmVudEJyYW5jaC5nZXROYW1lKCkpLCB7cHVsbDogdHJ1ZX0pO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGFzeW5jIGZldGNoKCkge1xuICAgIGF3YWl0IHRoaXMuYXR0ZW1wdEdpdE9wZXJhdGlvbihcbiAgICAgICgpID0+IHRoaXMuZG9GZXRjaCgpLFxuICAgICAgZXJyb3IgPT4ge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgIG1lc3NhZ2U6ICdVbmFibGUgdG8gZmV0Y2gnLFxuICAgICAgICAgIGRlc2NyaXB0aW9uOiBgPHByZT4ke2Vycm9yLnN0ZEVycn08L3ByZT5gLFxuICAgICAgICB9O1xuICAgICAgfSxcbiAgICApO1xuICB9XG5cbiAgYXN5bmMgZG9GZXRjaCgpIHtcbiAgICBhd2FpdCB0aGlzLnNldEluUHJvZ3Jlc3NXaGlsZSgoKSA9PiB0aGlzLnByb3BzLnJlcG9zaXRvcnkuZmV0Y2godGhpcy5wcm9wcy5jdXJyZW50QnJhbmNoLmdldE5hbWUoKSksIHtmZXRjaDogdHJ1ZX0pO1xuICB9XG59XG4iXX0=