'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _commitView = require('../views/commit-view');

var _commitView2 = _interopRequireDefault(_commitView);

var _modelStateRegistry = require('../models/model-state-registry');

var _modelStateRegistry2 = _interopRequireDefault(_modelStateRegistry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CommitViewController = (_class = (_temp = _class2 = class CommitViewController {

  constructor(props) {
    var _this = this;

    this.props = props;

    this.repoStateRegistry = new _modelStateRegistry2.default(CommitViewController, {
      initialModel: props.repository,
      save: () => {
        return {
          regularCommitMessage: this.regularCommitMessage,
          amendingCommitMessage: this.amendingCommitMessage
        };
      },
      restore: function () {
        let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _this.regularCommitMessage = state.regularCommitMessage || '';
        _this.amendingCommitMessage = state.amendingCommitMessage || '';
      }
    });

    if (this.props.isMerging && this.props.mergeMessage) {
      this.regularCommitMessage = this.props.mergeMessage;
    }
    _etch2.default.initialize(this);
  }

  update(props) {
    const wasAmending = this.props.isAmending;
    const wasMerging = this.props.isMerging;
    this.props = _extends({}, this.props, props);
    this.repoStateRegistry.setModel(this.props.repository);
    // If we just checked the "amend" box and we don't yet have a saved amending message,
    // initialize it to be the message from the last commit.
    if (!wasAmending && this.props.isAmending && !this.amendingCommitMessage && this.props.lastCommit.isPresent()) {
      this.amendingCommitMessage = props.lastCommit.getMessage();
    } else if (!wasMerging && this.props.isMerging && !this.regularCommitMessage) {
      this.regularCommitMessage = this.props.mergeMessage || '';
    }
    return _etch2.default.update(this);
  }

  render() {
    const message = this.getCommitMessage();

    return _etch2.default.dom(_commitView2.default, {
      ref: 'commitView',
      stagedChangesExist: this.props.stagedChangesExist,
      mergeConflictsExist: this.props.mergeConflictsExist,
      prepareToCommit: this.props.prepareToCommit,
      commit: this.commit,
      setAmending: this.props.setAmending,
      abortMerge: this.props.abortMerge,
      branchName: this.props.branchName,
      commandRegistry: this.props.commandRegistry,
      maximumCharacterLimit: 72,
      message: message,
      isMerging: this.props.isMerging,
      isAmending: this.props.isAmending,
      lastCommit: this.props.lastCommit,
      onChangeMessage: this.handleMessageChange,
      didMoveUpOnFirstLine: this.props.didMoveUpOnFirstLine
    });
  }

  commit(message) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      try {
        yield _this2.props.commit(message);
        _this2.regularCommitMessage = '';
        _this2.amendingCommitMessage = '';
        _etch2.default.update(_this2);
      } catch (e) {
        _this2.props.notificationManager.addError('Unable to commit', {
          dismissable: true,
          description: `<pre>${e.stdErr || e.stack}</pre>`
        });
      }
    })();
  }

  getCommitMessage() {
    const message = this.props.isAmending ? this.amendingCommitMessage : this.regularCommitMessage;
    return message || '';
  }

  handleMessageChange(newMessage) {
    if (this.props.isAmending) {
      this.amendingCommitMessage = newMessage;
    } else {
      this.regularCommitMessage = newMessage;
    }
    _etch2.default.update(this);
  }

  rememberFocus(event) {
    return this.refs.commitView.rememberFocus(event);
  }

  setFocus(focus) {
    return this.refs.commitView.setFocus(focus);
  }

  hasFocus() {
    return this.element.contains(document.activeElement);
  }

  destroy() {
    this.repoStateRegistry.save();
    return _etch2.default.destroy(this);
  }
}, _class2.focus = _extends({}, _commitView2.default.focus), _temp), (_applyDecoratedDescriptor(_class.prototype, 'commit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleMessageChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMessageChange'), _class.prototype)), _class);
exports.default = CommitViewController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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