'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let UserMentionTooltip = (_temp = _class = class UserMentionTooltip extends _react2.default.Component {

  render() {
    const owner = this.props.repositoryOwner;
    const login = owner.login,
          company = owner.company,
          repositories = owner.repositories,
          members = owner.members;

    return _react2.default.createElement(
      'div',
      { className: 'github-UserMentionTooltip' },
      _react2.default.createElement(
        'div',
        { className: 'github-UserMentionTooltip-avatar' },
        _react2.default.createElement('img', { src: owner.avatarUrl })
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-UserMentionTooltip-info' },
        _react2.default.createElement(
          'div',
          { className: 'github-UserMentionTooltip-info-username' },
          _react2.default.createElement(_octicon2.default, { icon: 'mention' }),
          _react2.default.createElement(
            'strong',
            null,
            login
          )
        ),
        company && _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'briefcase' }),
          _react2.default.createElement(
            'span',
            null,
            company
          )
        ),
        members && _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'organization' }),
          _react2.default.createElement(
            'span',
            null,
            members.totalCount,
            ' members'
          )
        ),
        _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'repo' }),
          _react2.default.createElement(
            'span',
            null,
            repositories.totalCount,
            ' repositories'
          )
        )
      ),
      _react2.default.createElement('div', { style: { clear: 'both' } })
    );
  }
}, _class.propTypes = {
  repositoryOwner: _propTypes2.default.shape({
    login: _propTypes2.default.string.isRequired,
    avatarUrl: _propTypes2.default.string.isRequired,
    repositories: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    }).isRequired,

    // Users
    company: _propTypes2.default.string,

    // Organizations
    members: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    })
  }).isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(UserMentionTooltip, {
  fragments: {
    repositoryOwner: () => function () {
      return {
        children: [{
          fieldName: 'login',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          fieldName: 'avatarUrl',
          kind: 'Field',
          metadata: {},
          type: 'URI'
        }, {
          children: [{
            fieldName: 'totalCount',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }],
          fieldName: 'repositories',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'RepositoryConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }, {
          fieldName: '__typename',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'String'
        }, {
          children: [{
            fieldName: 'company',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'User',
          type: 'User'
        }, {
          children: [{
            children: [{
              fieldName: 'totalCount',
              kind: 'Field',
              metadata: {},
              type: 'Int'
            }],
            fieldName: 'members',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isConnection: true
            },
            type: 'UserConnection'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'Organization',
          type: 'Organization'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {
          isAbstract: true
        },
        name: 'User_RepositoryOwnerRelayQL',
        type: 'RepositoryOwner'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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