'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MergedEvent = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../../views/timeago');

var _timeago2 = _interopRequireDefault(_timeago);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let MergedEvent = exports.MergedEvent = (_temp = _class = class MergedEvent extends _react2.default.Component {

  render() {
    var _props$item = this.props.item;
    const actor = _props$item.actor,
          commit = _props$item.commit,
          mergeRef = _props$item.mergeRef,
          createdAt = _props$item.createdAt;

    return _react2.default.createElement(
      'div',
      { className: 'merged-event' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'git-merge' }),
      _react2.default.createElement('img', { className: 'author-avatar', src: actor.avatarUrl, title: actor.login }),
      _react2.default.createElement(
        'span',
        { className: 'merged-event-header' },
        _react2.default.createElement(
          'span',
          { className: 'username' },
          actor.login
        ),
        ' merged commit ',
        _react2.default.createElement(
          'span',
          { className: 'sha' },
          commit.oid.slice(0, 8)
        ),
        ' into',
        ' ',
        _react2.default.createElement(
          'span',
          { className: 'merge-ref' },
          mergeRef.name
        ),
        ' on ',
        _react2.default.createElement(_timeago2.default, { time: createdAt })
      )
    );
  }
}, _class.propTypes = {
  item: _propTypes2.default.object.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(MergedEvent, {
  fragments: {
    item: () => function () {
      return {
        children: [{
          children: [{
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'actor',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'Actor'
        }, {
          children: [{
            fieldName: 'oid',
            kind: 'Field',
            metadata: {},
            type: 'GitObjectID'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'commit',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Commit'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'mergeRef',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Ref'
        }, {
          fieldName: 'createdAt',
          kind: 'Field',
          metadata: {},
          type: 'DateTime'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Merged_ItemRelayQL',
        type: 'MergedEvent'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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