'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _helpers = require('./helpers');

var _asyncQueue = require('./async-queue');

var _asyncQueue2 = _interopRequireDefault(_asyncQueue);

var _gitShellOutStrategy = require('./git-shell-out-strategy');

var _gitShellOutStrategy2 = _interopRequireDefault(_gitShellOutStrategy);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  create(workingDir) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return this.withStrategies([_gitShellOutStrategy2.default])(workingDir, options);
  },

  withStrategies(strategies) {
    return function createForStrategies(workingDir) {
      let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      const parallelism = options.parallelism || Math.max(3, _os2.default.cpus().length);
      const commandQueue = new _asyncQueue2.default({ parallelism });
      const strategyOptions = _extends({}, options, { queue: commandQueue });

      const strategyInstances = strategies.map(Strategy => new Strategy(workingDir, strategyOptions));
      return (0, _helpers.firstImplementer)(...strategyInstances);
    };
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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