'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _userMentionTooltipRoute = require('../routes/user-mention-tooltip-route');

var _userMentionTooltipRoute2 = _interopRequireDefault(_userMentionTooltipRoute);

var _userMentionTooltipContainer = require('../containers/user-mention-tooltip-container');

var _userMentionTooltipContainer2 = _interopRequireDefault(_userMentionTooltipContainer);

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let UserMentionTooltipItem = class UserMentionTooltipItem {
  constructor(username, relayEnvironment) {
    this.username = username.substr(1);
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      const route = new _userMentionTooltipRoute2.default({ username: this.username });
      this._element = document.createElement('div');
      const rootContainer = _react2.default.createElement(_relayRootContainer2.default, {
        Component: _userMentionTooltipContainer2.default,
        route: route,
        environment: this.relayEnvironment,
        renderLoading: () => {
          return _react2.default.createElement(
            'div',
            { className: 'github-Loader' },
            _react2.default.createElement('span', { className: 'github-Spinner' })
          );
        },
        renderFailure: () => _react2.default.createElement(
          'div',
          null,
          'Could not load information'
        )
      });
      this._component = _reactDom2.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom2.default.unmountComponentAtNode(this._element);
      delete this._element;
    }
  }
};
exports.default = UserMentionTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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