'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _eventKit = require('event-kit');

let StubItem = (_temp = _class = class StubItem {

  // StubItems should only be created by `create` and never constructed directly.
  static create(selector, props) {
    const stub = new StubItem(selector, props);
    const override = {
      _getStub: () => stub,
      getElement: () => stub.getElement(),
      destroy: stub.destroy.bind(stub)
    };
    const proxy = new Proxy(override, {
      get(target, name) {
        const item = stub.getRealItem();
        if (Reflect.has(target, name)) {
          return target[name];
        } else if (item && Reflect.has(item, name)) {
          let val = item[name];
          if (typeof val === 'function') {
            val = val.bind(item);
          }
          return val;
        } else {
          let val = stub[name];
          if (typeof val === 'function') {
            val = val.bind(stub);
          }
          return val;
        }
      }
    });
    this.stubsBySelector.set(selector, proxy);
    return proxy;
  }

  static getBySelector(selector) {
    return this.stubsBySelector.get(selector);
  }

  static getElementBySelector(selector) {
    const stub = this.getBySelector(selector);
    if (stub) {
      return stub.getElement();
    } else {
      return null;
    }
  }

  constructor(selector) {
    let props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    this.emitter = new _eventKit.Emitter();
    this.subscriptions = new _eventKit.CompositeDisposable();

    this.selector = selector;
    this.props = props;
    this.element = document.createElement('div');
    this.element.classList.add(`github-StubItem-${selector}`);
    this.realItem = null;
  }

  setRealItem(item) {
    var _this = this;

    this.realItem = item;
    this.emitter.emit('did-change-title');
    this.emitter.emit('did-change-icon');

    if (item.onDidChangeTitle) {
      this.subscriptions.add(item.onDidChangeTitle(function () {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        return _this.emitter.emit('did-change-title', ...args);
      }));
    }

    if (item.onDidChangeIcon) {
      this.subscriptions.add(item.onDidChangeIcon(function () {
        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        return _this.emitter.emit('did-change-icon', ...args);
      }));
    }

    if (item.onDidDestroy) {
      this.subscriptions.add(item.onDidDestroy(function () {
        for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
          args[_key3] = arguments[_key3];
        }

        _this.realItem = null;
        _this.emitter.emit('did-destroy', ...args);
      }));
    }
  }

  getRealItem() {
    return this.realItem;
  }

  getTitle() {
    return this.props.title || null;
  }

  getIconName() {
    return this.props.iconName || null;
  }

  onDidChangeTitle(cb) {
    return this.emitter.on('did-change-title', cb);
  }

  onDidChangeIcon(cb) {
    return this.emitter.on('did-change-icon', cb);
  }

  getElement() {
    return this.element;
  }

  onDidDestroy(cb) {
    return this.emitter.on('did-destroy', cb);
  }

  destroy() {
    this.subscriptions.dispose();
    this.emitter.dispose();
    StubItem.stubsBySelector.delete(this.selector);
    if (this.actualItem) {
      this.actualItem.destroy && this.actualItem.destroy();
    }
  }
}, _class.stubsBySelector = new Map(), _temp);
exports.default = StubItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInN0dWItaXRlbS5qcyJdLCJuYW1lcyI6WyJTdHViSXRlbSIsImNyZWF0ZSIsInNlbGVjdG9yIiwicHJvcHMiLCJzdHViIiwib3ZlcnJpZGUiLCJfZ2V0U3R1YiIsImdldEVsZW1lbnQiLCJkZXN0cm95IiwiYmluZCIsInByb3h5IiwiUHJveHkiLCJnZXQiLCJ0YXJnZXQiLCJuYW1lIiwiaXRlbSIsImdldFJlYWxJdGVtIiwiUmVmbGVjdCIsImhhcyIsInZhbCIsInN0dWJzQnlTZWxlY3RvciIsInNldCIsImdldEJ5U2VsZWN0b3IiLCJnZXRFbGVtZW50QnlTZWxlY3RvciIsImNvbnN0cnVjdG9yIiwiZW1pdHRlciIsInN1YnNjcmlwdGlvbnMiLCJlbGVtZW50IiwiZG9jdW1lbnQiLCJjcmVhdGVFbGVtZW50IiwiY2xhc3NMaXN0IiwiYWRkIiwicmVhbEl0ZW0iLCJzZXRSZWFsSXRlbSIsImVtaXQiLCJvbkRpZENoYW5nZVRpdGxlIiwiYXJncyIsIm9uRGlkQ2hhbmdlSWNvbiIsIm9uRGlkRGVzdHJveSIsImdldFRpdGxlIiwidGl0bGUiLCJnZXRJY29uTmFtZSIsImljb25OYW1lIiwiY2IiLCJvbiIsImRpc3Bvc2UiLCJkZWxldGUiLCJhY3R1YWxJdGVtIiwiTWFwIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTs7SUFFcUJBLFEscUJBQU4sTUFBTUEsUUFBTixDQUFlOztBQUc1QjtBQUNBLFNBQU9DLE1BQVAsQ0FBY0MsUUFBZCxFQUF3QkMsS0FBeEIsRUFBK0I7QUFDN0IsVUFBTUMsT0FBTyxJQUFJSixRQUFKLENBQWFFLFFBQWIsRUFBdUJDLEtBQXZCLENBQWI7QUFDQSxVQUFNRSxXQUFXO0FBQ2ZDLGdCQUFVLE1BQU1GLElBREQ7QUFFZkcsa0JBQVksTUFBTUgsS0FBS0csVUFBTCxFQUZIO0FBR2ZDLGVBQVNKLEtBQUtJLE9BQUwsQ0FBYUMsSUFBYixDQUFrQkwsSUFBbEI7QUFITSxLQUFqQjtBQUtBLFVBQU1NLFFBQVEsSUFBSUMsS0FBSixDQUFVTixRQUFWLEVBQW9CO0FBQ2hDTyxVQUFJQyxNQUFKLEVBQVlDLElBQVosRUFBa0I7QUFDaEIsY0FBTUMsT0FBT1gsS0FBS1ksV0FBTCxFQUFiO0FBQ0EsWUFBSUMsUUFBUUMsR0FBUixDQUFZTCxNQUFaLEVBQW9CQyxJQUFwQixDQUFKLEVBQStCO0FBQzdCLGlCQUFPRCxPQUFPQyxJQUFQLENBQVA7QUFDRCxTQUZELE1BRU8sSUFBSUMsUUFBUUUsUUFBUUMsR0FBUixDQUFZSCxJQUFaLEVBQWtCRCxJQUFsQixDQUFaLEVBQXFDO0FBQzFDLGNBQUlLLE1BQU1KLEtBQUtELElBQUwsQ0FBVjtBQUNBLGNBQUksT0FBT0ssR0FBUCxLQUFlLFVBQW5CLEVBQStCO0FBQzdCQSxrQkFBTUEsSUFBSVYsSUFBSixDQUFTTSxJQUFULENBQU47QUFDRDtBQUNELGlCQUFPSSxHQUFQO0FBQ0QsU0FOTSxNQU1BO0FBQ0wsY0FBSUEsTUFBTWYsS0FBS1UsSUFBTCxDQUFWO0FBQ0EsY0FBSSxPQUFPSyxHQUFQLEtBQWUsVUFBbkIsRUFBK0I7QUFDN0JBLGtCQUFNQSxJQUFJVixJQUFKLENBQVNMLElBQVQsQ0FBTjtBQUNEO0FBQ0QsaUJBQU9lLEdBQVA7QUFDRDtBQUNGO0FBbEIrQixLQUFwQixDQUFkO0FBb0JBLFNBQUtDLGVBQUwsQ0FBcUJDLEdBQXJCLENBQXlCbkIsUUFBekIsRUFBbUNRLEtBQW5DO0FBQ0EsV0FBT0EsS0FBUDtBQUNEOztBQUVELFNBQU9ZLGFBQVAsQ0FBcUJwQixRQUFyQixFQUErQjtBQUM3QixXQUFPLEtBQUtrQixlQUFMLENBQXFCUixHQUFyQixDQUF5QlYsUUFBekIsQ0FBUDtBQUNEOztBQUVELFNBQU9xQixvQkFBUCxDQUE0QnJCLFFBQTVCLEVBQXNDO0FBQ3BDLFVBQU1FLE9BQU8sS0FBS2tCLGFBQUwsQ0FBbUJwQixRQUFuQixDQUFiO0FBQ0EsUUFBSUUsSUFBSixFQUFVO0FBQ1IsYUFBT0EsS0FBS0csVUFBTCxFQUFQO0FBQ0QsS0FGRCxNQUVPO0FBQ0wsYUFBTyxJQUFQO0FBQ0Q7QUFDRjs7QUFFRGlCLGNBQVl0QixRQUFaLEVBQWtDO0FBQUEsUUFBWkMsS0FBWSx1RUFBSixFQUFJOztBQUNoQyxTQUFLc0IsT0FBTCxHQUFlLHVCQUFmO0FBQ0EsU0FBS0MsYUFBTCxHQUFxQixtQ0FBckI7O0FBRUEsU0FBS3hCLFFBQUwsR0FBZ0JBLFFBQWhCO0FBQ0EsU0FBS0MsS0FBTCxHQUFhQSxLQUFiO0FBQ0EsU0FBS3dCLE9BQUwsR0FBZUMsU0FBU0MsYUFBVCxDQUF1QixLQUF2QixDQUFmO0FBQ0EsU0FBS0YsT0FBTCxDQUFhRyxTQUFiLENBQXVCQyxHQUF2QixDQUE0QixtQkFBa0I3QixRQUFTLEVBQXZEO0FBQ0EsU0FBSzhCLFFBQUwsR0FBZ0IsSUFBaEI7QUFDRDs7QUFFREMsY0FBWWxCLElBQVosRUFBa0I7QUFBQTs7QUFDaEIsU0FBS2lCLFFBQUwsR0FBZ0JqQixJQUFoQjtBQUNBLFNBQUtVLE9BQUwsQ0FBYVMsSUFBYixDQUFrQixrQkFBbEI7QUFDQSxTQUFLVCxPQUFMLENBQWFTLElBQWIsQ0FBa0IsaUJBQWxCOztBQUVBLFFBQUluQixLQUFLb0IsZ0JBQVQsRUFBMkI7QUFDekIsV0FBS1QsYUFBTCxDQUFtQkssR0FBbkIsQ0FBdUJoQixLQUFLb0IsZ0JBQUwsQ0FBc0I7QUFBQSwwQ0FBSUMsSUFBSjtBQUFJQSxjQUFKO0FBQUE7O0FBQUEsZUFBYSxNQUFLWCxPQUFMLENBQWFTLElBQWIsQ0FBa0Isa0JBQWxCLEVBQXNDLEdBQUdFLElBQXpDLENBQWI7QUFBQSxPQUF0QixDQUF2QjtBQUNEOztBQUVELFFBQUlyQixLQUFLc0IsZUFBVCxFQUEwQjtBQUN4QixXQUFLWCxhQUFMLENBQW1CSyxHQUFuQixDQUF1QmhCLEtBQUtzQixlQUFMLENBQXFCO0FBQUEsMkNBQUlELElBQUo7QUFBSUEsY0FBSjtBQUFBOztBQUFBLGVBQWEsTUFBS1gsT0FBTCxDQUFhUyxJQUFiLENBQWtCLGlCQUFsQixFQUFxQyxHQUFHRSxJQUF4QyxDQUFiO0FBQUEsT0FBckIsQ0FBdkI7QUFDRDs7QUFFRCxRQUFJckIsS0FBS3VCLFlBQVQsRUFBdUI7QUFDckIsV0FBS1osYUFBTCxDQUFtQkssR0FBbkIsQ0FBdUJoQixLQUFLdUIsWUFBTCxDQUFrQixZQUFhO0FBQUEsMkNBQVRGLElBQVM7QUFBVEEsY0FBUztBQUFBOztBQUNwRCxjQUFLSixRQUFMLEdBQWdCLElBQWhCO0FBQ0EsY0FBS1AsT0FBTCxDQUFhUyxJQUFiLENBQWtCLGFBQWxCLEVBQWlDLEdBQUdFLElBQXBDO0FBQ0QsT0FIc0IsQ0FBdkI7QUFJRDtBQUNGOztBQUVEcEIsZ0JBQWM7QUFDWixXQUFPLEtBQUtnQixRQUFaO0FBQ0Q7O0FBRURPLGFBQVc7QUFDVCxXQUFPLEtBQUtwQyxLQUFMLENBQVdxQyxLQUFYLElBQW9CLElBQTNCO0FBQ0Q7O0FBRURDLGdCQUFjO0FBQ1osV0FBTyxLQUFLdEMsS0FBTCxDQUFXdUMsUUFBWCxJQUF1QixJQUE5QjtBQUNEOztBQUVEUCxtQkFBaUJRLEVBQWpCLEVBQXFCO0FBQ25CLFdBQU8sS0FBS2xCLE9BQUwsQ0FBYW1CLEVBQWIsQ0FBZ0Isa0JBQWhCLEVBQW9DRCxFQUFwQyxDQUFQO0FBQ0Q7O0FBRUROLGtCQUFnQk0sRUFBaEIsRUFBb0I7QUFDbEIsV0FBTyxLQUFLbEIsT0FBTCxDQUFhbUIsRUFBYixDQUFnQixpQkFBaEIsRUFBbUNELEVBQW5DLENBQVA7QUFDRDs7QUFFRHBDLGVBQWE7QUFDWCxXQUFPLEtBQUtvQixPQUFaO0FBQ0Q7O0FBRURXLGVBQWFLLEVBQWIsRUFBaUI7QUFDZixXQUFPLEtBQUtsQixPQUFMLENBQWFtQixFQUFiLENBQWdCLGFBQWhCLEVBQStCRCxFQUEvQixDQUFQO0FBQ0Q7O0FBRURuQyxZQUFVO0FBQ1IsU0FBS2tCLGFBQUwsQ0FBbUJtQixPQUFuQjtBQUNBLFNBQUtwQixPQUFMLENBQWFvQixPQUFiO0FBQ0E3QyxhQUFTb0IsZUFBVCxDQUF5QjBCLE1BQXpCLENBQWdDLEtBQUs1QyxRQUFyQztBQUNBLFFBQUksS0FBSzZDLFVBQVQsRUFBcUI7QUFDbkIsV0FBS0EsVUFBTCxDQUFnQnZDLE9BQWhCLElBQTJCLEtBQUt1QyxVQUFMLENBQWdCdkMsT0FBaEIsRUFBM0I7QUFDRDtBQUNGO0FBbkgyQixDLFNBQ3JCWSxlLEdBQWtCLElBQUk0QixHQUFKLEU7a0JBRE5oRCxRIiwiZmlsZSI6InN0dWItaXRlbS5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7RW1pdHRlciwgQ29tcG9zaXRlRGlzcG9zYWJsZX0gZnJvbSAnZXZlbnQta2l0JztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3R1Ykl0ZW0ge1xuICBzdGF0aWMgc3R1YnNCeVNlbGVjdG9yID0gbmV3IE1hcCgpXG5cbiAgLy8gU3R1Ykl0ZW1zIHNob3VsZCBvbmx5IGJlIGNyZWF0ZWQgYnkgYGNyZWF0ZWAgYW5kIG5ldmVyIGNvbnN0cnVjdGVkIGRpcmVjdGx5LlxuICBzdGF0aWMgY3JlYXRlKHNlbGVjdG9yLCBwcm9wcykge1xuICAgIGNvbnN0IHN0dWIgPSBuZXcgU3R1Ykl0ZW0oc2VsZWN0b3IsIHByb3BzKTtcbiAgICBjb25zdCBvdmVycmlkZSA9IHtcbiAgICAgIF9nZXRTdHViOiAoKSA9PiBzdHViLFxuICAgICAgZ2V0RWxlbWVudDogKCkgPT4gc3R1Yi5nZXRFbGVtZW50KCksXG4gICAgICBkZXN0cm95OiBzdHViLmRlc3Ryb3kuYmluZChzdHViKSxcbiAgICB9O1xuICAgIGNvbnN0IHByb3h5ID0gbmV3IFByb3h5KG92ZXJyaWRlLCB7XG4gICAgICBnZXQodGFyZ2V0LCBuYW1lKSB7XG4gICAgICAgIGNvbnN0IGl0ZW0gPSBzdHViLmdldFJlYWxJdGVtKCk7XG4gICAgICAgIGlmIChSZWZsZWN0Lmhhcyh0YXJnZXQsIG5hbWUpKSB7XG4gICAgICAgICAgcmV0dXJuIHRhcmdldFtuYW1lXTtcbiAgICAgICAgfSBlbHNlIGlmIChpdGVtICYmIFJlZmxlY3QuaGFzKGl0ZW0sIG5hbWUpKSB7XG4gICAgICAgICAgbGV0IHZhbCA9IGl0ZW1bbmFtZV07XG4gICAgICAgICAgaWYgKHR5cGVvZiB2YWwgPT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgICAgIHZhbCA9IHZhbC5iaW5kKGl0ZW0pO1xuICAgICAgICAgIH1cbiAgICAgICAgICByZXR1cm4gdmFsO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGxldCB2YWwgPSBzdHViW25hbWVdO1xuICAgICAgICAgIGlmICh0eXBlb2YgdmFsID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgICAgICB2YWwgPSB2YWwuYmluZChzdHViKTtcbiAgICAgICAgICB9XG4gICAgICAgICAgcmV0dXJuIHZhbDtcbiAgICAgICAgfVxuICAgICAgfSxcbiAgICB9KTtcbiAgICB0aGlzLnN0dWJzQnlTZWxlY3Rvci5zZXQoc2VsZWN0b3IsIHByb3h5KTtcbiAgICByZXR1cm4gcHJveHk7XG4gIH1cblxuICBzdGF0aWMgZ2V0QnlTZWxlY3RvcihzZWxlY3Rvcikge1xuICAgIHJldHVybiB0aGlzLnN0dWJzQnlTZWxlY3Rvci5nZXQoc2VsZWN0b3IpO1xuICB9XG5cbiAgc3RhdGljIGdldEVsZW1lbnRCeVNlbGVjdG9yKHNlbGVjdG9yKSB7XG4gICAgY29uc3Qgc3R1YiA9IHRoaXMuZ2V0QnlTZWxlY3RvcihzZWxlY3Rvcik7XG4gICAgaWYgKHN0dWIpIHtcbiAgICAgIHJldHVybiBzdHViLmdldEVsZW1lbnQoKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICB9XG5cbiAgY29uc3RydWN0b3Ioc2VsZWN0b3IsIHByb3BzID0ge30pIHtcbiAgICB0aGlzLmVtaXR0ZXIgPSBuZXcgRW1pdHRlcigpO1xuICAgIHRoaXMuc3Vic2NyaXB0aW9ucyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKCk7XG5cbiAgICB0aGlzLnNlbGVjdG9yID0gc2VsZWN0b3I7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgIHRoaXMuZWxlbWVudCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpO1xuICAgIHRoaXMuZWxlbWVudC5jbGFzc0xpc3QuYWRkKGBnaXRodWItU3R1Ykl0ZW0tJHtzZWxlY3Rvcn1gKTtcbiAgICB0aGlzLnJlYWxJdGVtID0gbnVsbDtcbiAgfVxuXG4gIHNldFJlYWxJdGVtKGl0ZW0pIHtcbiAgICB0aGlzLnJlYWxJdGVtID0gaXRlbTtcbiAgICB0aGlzLmVtaXR0ZXIuZW1pdCgnZGlkLWNoYW5nZS10aXRsZScpO1xuICAgIHRoaXMuZW1pdHRlci5lbWl0KCdkaWQtY2hhbmdlLWljb24nKTtcblxuICAgIGlmIChpdGVtLm9uRGlkQ2hhbmdlVGl0bGUpIHtcbiAgICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5hZGQoaXRlbS5vbkRpZENoYW5nZVRpdGxlKCguLi5hcmdzKSA9PiB0aGlzLmVtaXR0ZXIuZW1pdCgnZGlkLWNoYW5nZS10aXRsZScsIC4uLmFyZ3MpKSk7XG4gICAgfVxuXG4gICAgaWYgKGl0ZW0ub25EaWRDaGFuZ2VJY29uKSB7XG4gICAgICB0aGlzLnN1YnNjcmlwdGlvbnMuYWRkKGl0ZW0ub25EaWRDaGFuZ2VJY29uKCguLi5hcmdzKSA9PiB0aGlzLmVtaXR0ZXIuZW1pdCgnZGlkLWNoYW5nZS1pY29uJywgLi4uYXJncykpKTtcbiAgICB9XG5cbiAgICBpZiAoaXRlbS5vbkRpZERlc3Ryb3kpIHtcbiAgICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5hZGQoaXRlbS5vbkRpZERlc3Ryb3koKC4uLmFyZ3MpID0+IHtcbiAgICAgICAgdGhpcy5yZWFsSXRlbSA9IG51bGw7XG4gICAgICAgIHRoaXMuZW1pdHRlci5lbWl0KCdkaWQtZGVzdHJveScsIC4uLmFyZ3MpO1xuICAgICAgfSkpO1xuICAgIH1cbiAgfVxuXG4gIGdldFJlYWxJdGVtKCkge1xuICAgIHJldHVybiB0aGlzLnJlYWxJdGVtO1xuICB9XG5cbiAgZ2V0VGl0bGUoKSB7XG4gICAgcmV0dXJuIHRoaXMucHJvcHMudGl0bGUgfHwgbnVsbDtcbiAgfVxuXG4gIGdldEljb25OYW1lKCkge1xuICAgIHJldHVybiB0aGlzLnByb3BzLmljb25OYW1lIHx8IG51bGw7XG4gIH1cblxuICBvbkRpZENoYW5nZVRpdGxlKGNiKSB7XG4gICAgcmV0dXJuIHRoaXMuZW1pdHRlci5vbignZGlkLWNoYW5nZS10aXRsZScsIGNiKTtcbiAgfVxuXG4gIG9uRGlkQ2hhbmdlSWNvbihjYikge1xuICAgIHJldHVybiB0aGlzLmVtaXR0ZXIub24oJ2RpZC1jaGFuZ2UtaWNvbicsIGNiKTtcbiAgfVxuXG4gIGdldEVsZW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZWxlbWVudDtcbiAgfVxuXG4gIG9uRGlkRGVzdHJveShjYikge1xuICAgIHJldHVybiB0aGlzLmVtaXR0ZXIub24oJ2RpZC1kZXN0cm95JywgY2IpO1xuICB9XG5cbiAgZGVzdHJveSgpIHtcbiAgICB0aGlzLnN1YnNjcmlwdGlvbnMuZGlzcG9zZSgpO1xuICAgIHRoaXMuZW1pdHRlci5kaXNwb3NlKCk7XG4gICAgU3R1Ykl0ZW0uc3R1YnNCeVNlbGVjdG9yLmRlbGV0ZSh0aGlzLnNlbGVjdG9yKTtcbiAgICBpZiAodGhpcy5hY3R1YWxJdGVtKSB7XG4gICAgICB0aGlzLmFjdHVhbEl0ZW0uZGVzdHJveSAmJiB0aGlzLmFjdHVhbEl0ZW0uZGVzdHJveSgpO1xuICAgIH1cbiAgfVxufVxuIl19