'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _issueishTooltipRoute = require('../routes/issueish-tooltip-route');

var _issueishTooltipRoute2 = _interopRequireDefault(_issueishTooltipRoute);

var _issueishTooltipContainer = require('../containers/issueish-tooltip-container');

var _issueishTooltipContainer2 = _interopRequireDefault(_issueishTooltipContainer);

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let IssueishTooltipItem = class IssueishTooltipItem {
  constructor(issueishUrl, relayEnvironment) {
    this.issueishUrl = issueishUrl;
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      const route = new _issueishTooltipRoute2.default({ issueishUrl: this.issueishUrl });
      this._element = document.createElement('div');
      const rootContainer = _react2.default.createElement(_relayRootContainer2.default, {
        Component: _issueishTooltipContainer2.default,
        route: route,
        environment: this.relayEnvironment,
        renderLoading: () => {
          // TODO: adjust min width/height
          return _react2.default.createElement(
            'div',
            { className: 'github-Loader' },
            _react2.default.createElement('span', { className: 'github-Spinner' })
          );
        },
        renderFailure: () => _react2.default.createElement(
          'div',
          null,
          'Could not load information'
        )
      });
      this._component = _reactDom2.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom2.default.unmountComponentAtNode(this._element);
      delete this._element;
    }
  }
};
exports.default = IssueishTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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