(function() {
  var BufferSearch, CompositeDisposable, Disposable, FileIcons, FindOptions, FindView, History, HistoryCycler, ProjectFindView, ResultsModel, ResultsPaneView, SelectNext, TextBuffer, ref, ref1;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, TextBuffer = ref.TextBuffer;

  SelectNext = require('./select-next');

  ref1 = require('./history'), History = ref1.History, HistoryCycler = ref1.HistoryCycler;

  FindOptions = require('./find-options');

  BufferSearch = require('./buffer-search');

  FileIcons = require('./file-icons');

  FindView = require('./find-view');

  ProjectFindView = require('./project-find-view');

  ResultsModel = require('./project/results-model');

  ResultsPaneView = require('./project/results-pane');

  module.exports = {
    activate: function(arg) {
      var findHistory, findOptions, handleEditorCancel, pathsHistory, ref2, replaceHistory, selectNextObjectForEditorElement, showPanel, togglePanel;
      ref2 = arg != null ? arg : {}, findOptions = ref2.findOptions, findHistory = ref2.findHistory, replaceHistory = ref2.replaceHistory, pathsHistory = ref2.pathsHistory;
      if (atom.config.get('find-and-replace.openProjectFindResultsInRightPane')) {
        atom.config.set('find-and-replace.projectSearchResultsPaneSplitDirection', 'right');
      }
      atom.config.unset('find-and-replace.openProjectFindResultsInRightPane');
      atom.workspace.addOpener(function(filePath) {
        if (filePath === ResultsPaneView.URI) {
          return new ResultsPaneView();
        }
      });
      this.subscriptions = new CompositeDisposable;
      this.findHistory = new History(findHistory);
      this.replaceHistory = new History(replaceHistory);
      this.pathsHistory = new History(pathsHistory);
      this.findOptions = new FindOptions(findOptions);
      this.findModel = new BufferSearch(this.findOptions);
      this.resultsModel = new ResultsModel(this.findOptions);
      this.subscriptions.add(atom.workspace.getCenter().observeActivePaneItem((function(_this) {
        return function(paneItem) {
          if (paneItem != null ? typeof paneItem.getBuffer === "function" ? paneItem.getBuffer() : void 0 : void 0) {
            return _this.findModel.setEditor(paneItem);
          } else {
            return _this.findModel.setEditor(null);
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('.find-and-replace, .project-find', 'window:focus-next-pane', function() {
        return atom.views.getView(atom.workspace).focus();
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show-in-current-directory', (function(_this) {
        return function(arg1) {
          var target;
          target = arg1.target;
          _this.createViews();
          _this.findPanel.hide();
          _this.projectFindPanel.show();
          _this.projectFindView.focusFindElement();
          return _this.projectFindView.findInCurrentlySelectedDirectory(target);
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-find-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show-replace', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusReplaceEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:clear-history', (function(_this) {
        return function() {
          _this.findHistory.clear();
          return _this.replaceHistory.clear();
        };
      })(this)));
      handleEditorCancel = (function(_this) {
        return function(arg1) {
          var isMiniEditor, ref3, ref4, target;
          target = arg1.target;
          isMiniEditor = target.tagName === 'ATOM-TEXT-EDITOR' && target.hasAttribute('mini');
          if (!isMiniEditor) {
            if ((ref3 = _this.findPanel) != null) {
              ref3.hide();
            }
            return (ref4 = _this.projectFindPanel) != null ? ref4.hide() : void 0;
          }
        };
      })(this);
      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': handleEditorCancel,
        'core:close': handleEditorCancel
      }));
      selectNextObjectForEditorElement = (function(_this) {
        return function(editorElement) {
          var editor, selectNext;
          if (_this.selectNextObjects == null) {
            _this.selectNextObjects = new WeakMap();
          }
          editor = editorElement.getModel();
          selectNext = _this.selectNextObjects.get(editor);
          if (selectNext == null) {
            selectNext = new SelectNext(editor);
            _this.selectNextObjects.set(editor, selectNext);
          }
          return selectNext;
        };
      })(this);
      showPanel = function(panelToShow, panelToHide, postShowAction) {
        panelToHide.hide();
        panelToShow.show();
        return typeof postShowAction === "function" ? postShowAction() : void 0;
      };
      togglePanel = function(panelToToggle, panelToHide, postToggleAction) {
        panelToHide.hide();
        if (panelToToggle.isVisible()) {
          return panelToToggle.hide();
        } else {
          panelToToggle.show();
          return typeof postToggleAction === "function" ? postToggleAction() : void 0;
        }
      };
      return atom.commands.add('.editor:not(.mini)', {
        'find-and-replace:select-next': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectNext();
        },
        'find-and-replace:select-all': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectAll();
        },
        'find-and-replace:select-undo': function(event) {
          return selectNextObjectForEditorElement(this).undoLastSelection();
        },
        'find-and-replace:select-skip': function(event) {
          return selectNextObjectForEditorElement(this).skipCurrentSelection();
        }
      });
    },
    consumeFileIcons: function(service) {
      FileIcons.setService(service);
      return new Disposable(function() {
        return FileIcons.resetService();
      });
    },
    provideService: function() {
      return {
        resultsMarkerLayerForTextEditor: this.findModel.resultsMarkerLayerForTextEditor.bind(this.findModel)
      };
    },
    createViews: function() {
      var findBuffer, findHistoryCycler, options, pathsBuffer, pathsHistoryCycler, replaceBuffer, replaceHistoryCycler;
      if (this.findView != null) {
        return;
      }
      findBuffer = new TextBuffer;
      replaceBuffer = new TextBuffer;
      pathsBuffer = new TextBuffer;
      findHistoryCycler = new HistoryCycler(findBuffer, this.findHistory);
      replaceHistoryCycler = new HistoryCycler(replaceBuffer, this.replaceHistory);
      pathsHistoryCycler = new HistoryCycler(pathsBuffer, this.pathsHistory);
      options = {
        findBuffer: findBuffer,
        replaceBuffer: replaceBuffer,
        pathsBuffer: pathsBuffer,
        findHistoryCycler: findHistoryCycler,
        replaceHistoryCycler: replaceHistoryCycler,
        pathsHistoryCycler: pathsHistoryCycler
      };
      this.findView = new FindView(this.findModel, options);
      this.projectFindView = new ProjectFindView(this.resultsModel, options);
      this.findPanel = atom.workspace.addBottomPanel({
        item: this.findView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.projectFindPanel = atom.workspace.addBottomPanel({
        item: this.projectFindView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.findView.setPanel(this.findPanel);
      this.projectFindView.setPanel(this.projectFindPanel);
      return ResultsPaneView.model = this.resultsModel;
    },
    deactivate: function() {
      var ref2, ref3, ref4, ref5, ref6, ref7;
      if ((ref2 = this.findPanel) != null) {
        ref2.destroy();
      }
      this.findPanel = null;
      if ((ref3 = this.findView) != null) {
        ref3.destroy();
      }
      this.findView = null;
      if ((ref4 = this.findModel) != null) {
        ref4.destroy();
      }
      this.findModel = null;
      if ((ref5 = this.projectFindPanel) != null) {
        ref5.destroy();
      }
      this.projectFindPanel = null;
      if ((ref6 = this.projectFindView) != null) {
        ref6.destroy();
      }
      this.projectFindView = null;
      ResultsPaneView.model = null;
      this.resultsModel = null;
      if ((ref7 = this.subscriptions) != null) {
        ref7.dispose();
      }
      return this.subscriptions = null;
    },
    serialize: function() {
      return {
        findOptions: this.findOptions.serialize(),
        findHistory: this.findHistory.serialize(),
        replaceHistory: this.replaceHistory.serialize(),
        pathsHistory: this.pathsHistory.serialize()
      };
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
