(function() {
  var Emitter, FindOptions, Params, _;

  _ = require('underscore-plus');

  Emitter = require('atom').Emitter;

  Params = ['findPattern', 'replacePattern', 'pathsPattern', 'useRegex', 'wholeWord', 'caseSensitive', 'inCurrentSelection'];

  module.exports = FindOptions = (function() {
    function FindOptions(state) {
      var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9;
      if (state == null) {
        state = {};
      }
      this.emitter = new Emitter;
      this.findPattern = '';
      this.replacePattern = (ref = state.replacePattern) != null ? ref : '';
      this.pathsPattern = (ref1 = state.pathsPattern) != null ? ref1 : '';
      this.useRegex = (ref2 = (ref3 = state.useRegex) != null ? ref3 : atom.config.get('find-and-replace.useRegex')) != null ? ref2 : false;
      this.caseSensitive = (ref4 = (ref5 = state.caseSensitive) != null ? ref5 : atom.config.get('find-and-replace.caseSensitive')) != null ? ref4 : false;
      this.wholeWord = (ref6 = (ref7 = state.wholeWord) != null ? ref7 : atom.config.get('find-and-replace.wholeWord')) != null ? ref6 : false;
      this.inCurrentSelection = (ref8 = (ref9 = state.inCurrentSelection) != null ? ref9 : atom.config.get('find-and-replace.inCurrentSelection')) != null ? ref8 : false;
    }

    FindOptions.prototype.onDidChange = function(callback) {
      return this.emitter.on('did-change', callback);
    };

    FindOptions.prototype.onDidChangeReplacePattern = function(callback) {
      return this.emitter.on('did-change-replacePattern', callback);
    };

    FindOptions.prototype.serialize = function() {
      var i, len, param, result;
      result = {};
      for (i = 0, len = Params.length; i < len; i++) {
        param = Params[i];
        result[param] = this[param];
      }
      return result;
    };

    FindOptions.prototype.set = function(newParams) {
      var changedParams, i, key, len, param, val;
      if (newParams == null) {
        newParams = {};
      }
      changedParams = null;
      for (i = 0, len = Params.length; i < len; i++) {
        key = Params[i];
        if ((newParams[key] != null) && newParams[key] !== this[key]) {
          if (changedParams == null) {
            changedParams = {};
          }
          this[key] = changedParams[key] = newParams[key];
        }
      }
      if (changedParams != null) {
        for (param in changedParams) {
          val = changedParams[param];
          this.emitter.emit("did-change-" + param);
        }
        return this.emitter.emit('did-change', changedParams);
      }
    };

    FindOptions.prototype.getFindPatternRegex = function() {
      var expression, flags;
      flags = 'g';
      if (!this.caseSensitive) {
        flags += 'i';
      }
      if (this.useRegex) {
        expression = this.findPattern;
      } else {
        expression = _.escapeRegExp(this.findPattern);
      }
      if (this.wholeWord) {
        expression = "\\b" + expression + "\\b";
      }
      return new RegExp(expression, flags);
    };

    return FindOptions;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
