"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) /* istanbul ignore next */  if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    /* istanbul ignore next */  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var rest_1 = require("./rest");
var lang_extensions_1 = require("../../lang/lang_extensions");
var gast_public_1 = require("./gast_public");
var first_1 = require("./first");
var utils_1 = require("../../utils/utils");
var constants_1 = require("../constants");
var tokens_public_1 = require("../../scan/tokens_public");
// This ResyncFollowsWalker computes all of the follows required for RESYNC
// (skipping reference production).
var ResyncFollowsWalker = (function (_super) {
    __extends(ResyncFollowsWalker, _super);
    function ResyncFollowsWalker(topProd) {
        _super.call(this);
        this.topProd = topProd;
        this.follows = new lang_extensions_1.HashTable();
    }
    ResyncFollowsWalker.prototype.startWalking = function () {
        this.walk(this.topProd);
        return this.follows;
    };
    ResyncFollowsWalker.prototype.walkTerminal = function (terminal, currRest, prevRest) {
        // do nothing! just like in the public sector after 13:00
    };
    ResyncFollowsWalker.prototype.walkProdRef = function (refProd, currRest, prevRest) {
        var followName = buildBetweenProdsFollowPrefix(refProd.referencedRule, refProd.occurrenceInParent) + this.topProd.name;
        var fullRest = currRest.concat(prevRest);
        var restProd = new gast_public_1.gast.Flat(fullRest);
        var t_in_topProd_follows = first_1.first(restProd);
        this.follows.put(followName, t_in_topProd_follows);
    };
    return ResyncFollowsWalker;
}(rest_1.RestWalker));
exports.ResyncFollowsWalker = ResyncFollowsWalker;
function computeAllProdsFollows(topProductions) {
    var reSyncFollows = new lang_extensions_1.HashTable();
    utils_1.forEach(topProductions, function (topProd) {
        var currRefsFollow = new ResyncFollowsWalker(topProd).startWalking();
        reSyncFollows.putAll(currRefsFollow);
    });
    return reSyncFollows;
}
exports.computeAllProdsFollows = computeAllProdsFollows;
function buildBetweenProdsFollowPrefix(inner, occurenceInParent) {
    return inner.name + occurenceInParent + constants_1.IN;
}
exports.buildBetweenProdsFollowPrefix = buildBetweenProdsFollowPrefix;
function buildInProdFollowPrefix(terminal) {
    var terminalName = tokens_public_1.tokenName(terminal.terminalType);
    return terminalName + terminal.occurrenceInParent + constants_1.IN;
}
exports.buildInProdFollowPrefix = buildInProdFollowPrefix;
