(function() {
  var CompositeDisposable, Disposable, dontSaveIf, fs, ref, ref1, shouldSave;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable;

  fs = require('fs-plus');

  ref1 = require('./controls'), dontSaveIf = ref1.dontSaveIf, shouldSave = ref1.shouldSave;

  module.exports = {
    subscriptions: null,
    provideService: function() {
      return {
        dontSaveIf: dontSaveIf
      };
    },
    activate: function() {
      var handleBeforeUnload, handleBlur;
      this.subscriptions = new CompositeDisposable;
      handleBeforeUnload = this.autosaveAllPaneItems.bind(this);
      window.addEventListener('beforeunload', handleBeforeUnload, true);
      this.subscriptions.add(new Disposable(function() {
        return window.removeEventListener('beforeunload', handleBeforeUnload, true);
      }));
      handleBlur = (function(_this) {
        return function(event) {
          if (event.target === window) {
            return _this.autosaveAllPaneItems();
          } else if (event.target.matches('atom-text-editor:not(mini)') && !event.target.contains(event.relatedTarget)) {
            return _this.autosavePaneItem(event.target.getModel());
          }
        };
      })(this);
      window.addEventListener('blur', handleBlur, true);
      this.subscriptions.add(new Disposable(function() {
        return window.removeEventListener('blur', handleBlur, true);
      }));
      return this.subscriptions.add(atom.workspace.onWillDestroyPaneItem((function(_this) {
        return function(arg) {
          var item;
          item = arg.item;
          return _this.autosavePaneItem(item);
        };
      })(this)));
    },
    deactivate: function() {
      return this.subscriptions.dispose();
    },
    autosavePaneItem: function(paneItem) {
      var pane;
      if (!atom.config.get('autosave.enabled')) {
        return;
      }
      if ((paneItem != null ? typeof paneItem.getURI === "function" ? paneItem.getURI() : void 0 : void 0) == null) {
        return;
      }
      if (!(paneItem != null ? typeof paneItem.isModified === "function" ? paneItem.isModified() : void 0 : void 0)) {
        return;
      }
      if (!(((paneItem != null ? typeof paneItem.getPath === "function" ? paneItem.getPath() : void 0 : void 0) != null) && fs.isFileSync(paneItem.getPath()))) {
        return;
      }
      if (!shouldSave(paneItem)) {
        return;
      }
      pane = atom.workspace.paneForItem(paneItem);
      if (pane != null) {
        return pane.saveItem(paneItem);
      } else {
        return typeof paneItem.save === "function" ? paneItem.save() : void 0;
      }
    },
    autosaveAllPaneItems: function() {
      var i, len, paneItem, ref2, results;
      ref2 = atom.workspace.getPaneItems();
      results = [];
      for (i = 0, len = ref2.length; i < len; i++) {
        paneItem = ref2[i];
        results.push(this.autosavePaneItem(paneItem));
      }
      return results;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
