Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var Unsupported = 'unsupported';
var Idle = 'idle';
var CheckingForUpdate = 'checking';
var DownloadingUpdate = 'downloading';
var UpdateAvailableToInstall = 'update-available';
var UpToDate = 'no-update-available';
var ErrorState = 'error';

var UpdateManager = (function () {
  function UpdateManager() {
    _classCallCheck(this, UpdateManager);

    this.emitter = new _atom.Emitter();
    this.currentVersion = atom.getVersion();
    this.availableVersion = atom.getVersion();
    this.resetState();
    this.listenForAtomEvents();
  }

  _createClass(UpdateManager, [{
    key: 'listenForAtomEvents',
    value: function listenForAtomEvents() {
      var _this = this;

      this.subscriptions = new _atom.CompositeDisposable();

      this.subscriptions.add(atom.autoUpdater.onDidBeginCheckingForUpdate(function () {
        _this.setState(CheckingForUpdate);
      }), atom.autoUpdater.onDidBeginDownloadingUpdate(function () {
        _this.setState(DownloadingUpdate);
      }), atom.autoUpdater.onDidCompleteDownloadingUpdate(function (_ref) {
        var releaseVersion = _ref.releaseVersion;

        _this.setAvailableVersion(releaseVersion);
      }), atom.autoUpdater.onUpdateNotAvailable(function () {
        _this.setState(UpToDate);
      }), atom.autoUpdater.onUpdateError(function () {
        _this.setState(ErrorState);
      }), atom.config.observe('core.automaticallyUpdate', function (value) {
        _this.autoUpdatesEnabled = value;
        _this.emitDidChange();
      }));

      // TODO: When https://github.com/atom/electron/issues/4587 is closed we can add this support.
      // atom.autoUpdater.onUpdateAvailable =>
      //   @find('.about-updates-item').removeClass('is-shown')
      //   @updateAvailable.addClass('is-shown')
    }
  }, {
    key: 'dispose',
    value: function dispose() {
      this.subscriptions.dispose();
    }
  }, {
    key: 'onDidChange',
    value: function onDidChange(callback) {
      return this.emitter.on('did-change', callback);
    }
  }, {
    key: 'emitDidChange',
    value: function emitDidChange() {
      this.emitter.emit('did-change');
    }
  }, {
    key: 'getAutoUpdatesEnabled',
    value: function getAutoUpdatesEnabled() {
      return this.autoUpdatesEnabled && this.state !== UpdateManager.State.Unsupported;
    }
  }, {
    key: 'setAutoUpdatesEnabled',
    value: function setAutoUpdatesEnabled(enabled) {
      return atom.config.set('core.automaticallyUpdate', enabled);
    }
  }, {
    key: 'getErrorMessage',
    value: function getErrorMessage() {
      return atom.autoUpdater.getErrorMessage();
    }
  }, {
    key: 'getState',
    value: function getState() {
      return this.state;
    }
  }, {
    key: 'setState',
    value: function setState(state) {
      this.state = state;
      this.emitDidChange();
    }
  }, {
    key: 'resetState',
    value: function resetState() {
      this.state = atom.autoUpdater.platformSupportsUpdates() ? atom.autoUpdater.getState() : Unsupported;
      this.emitDidChange();
    }
  }, {
    key: 'getAvailableVersion',
    value: function getAvailableVersion() {
      return this.availableVersion;
    }
  }, {
    key: 'setAvailableVersion',
    value: function setAvailableVersion(version) {
      this.availableVersion = version;

      if (this.availableVersion !== this.currentVersion) {
        this.state = UpdateAvailableToInstall;
      } else {
        this.state = UpToDate;
      }

      this.emitDidChange();
    }
  }, {
    key: 'checkForUpdate',
    value: function checkForUpdate() {
      atom.autoUpdater.checkForUpdate();
    }
  }, {
    key: 'restartAndInstallUpdate',
    value: function restartAndInstallUpdate() {
      atom.autoUpdater.restartAndInstallUpdate();
    }
  }, {
    key: 'getReleaseNotesURLForCurrentVersion',
    value: function getReleaseNotesURLForCurrentVersion() {
      return this.getReleaseNotesURLForVersion(this.currentVersion);
    }
  }, {
    key: 'getReleaseNotesURLForAvailableVersion',
    value: function getReleaseNotesURLForAvailableVersion() {
      return this.getReleaseNotesURLForVersion(this.availableVersion);
    }
  }, {
    key: 'getReleaseNotesURLForVersion',
    value: function getReleaseNotesURLForVersion(appVersion) {
      // Dev versions will not have a releases page
      if (appVersion.indexOf('dev') > -1) {
        return 'https://atom.io/releases';
      }

      if (!appVersion.startsWith('v')) {
        appVersion = 'v' + appVersion;
      }
      return 'https://github.com/atom/atom/releases/tag/' + appVersion;
    }
  }]);

  return UpdateManager;
})();

exports['default'] = UpdateManager;

UpdateManager.State = {
  Unsupported: Unsupported,
  Idle: Idle,
  CheckingForUpdate: CheckingForUpdate,
  DownloadingUpdate: DownloadingUpdate,
  UpdateAvailableToInstall: UpdateAvailableToInstall,
  UpToDate: UpToDate,
  Error: ErrorState
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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