/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFAttributes;
import org.graphstream.stream.file.gexf.GEXFEdges;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.GEXFNodes;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFGraph
implements GEXFElement {
    GEXF root;
    GEXFElement.DefaultEdgeType defaultEdgeType;
    GEXFElement.IDType idType;
    GEXFElement.Mode mode;
    GEXFAttributes nodesAttributes;
    GEXFAttributes edgesAttributes;
    GEXFElement nodes;
    GEXFElement edges;

    public GEXFGraph(GEXF root) {
        this(root, GEXFElement.Mode.DYNAMIC);
    }

    public GEXFGraph(GEXF root, GEXFElement.Mode mode) {
        this.root = root;
        this.defaultEdgeType = GEXFElement.DefaultEdgeType.UNDIRECTED;
        this.idType = GEXFElement.IDType.STRING;
        this.mode = mode;
        this.nodesAttributes = new GEXFAttributes(root, GEXFElement.ClassType.NODE);
        this.edgesAttributes = new GEXFAttributes(root, GEXFElement.ClassType.EDGE);
        this.nodes = new GEXFNodes(root);
        this.edges = new GEXFEdges(root);
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        GEXFElement.Mode realMode = this.mode;
        if (!this.root.isExtensionEnable(GEXFElement.Extension.DYNAMICS)) {
            realMode = GEXFElement.Mode.STATIC;
        }
        stream.startElement("graph");
        stream.stream.writeAttribute("idtype", this.idType.qname);
        stream.stream.writeAttribute("mode", realMode.qname);
        stream.stream.writeAttribute("defaultedgetype", this.defaultEdgeType.qname);
        if (this.root.isExtensionEnable(GEXFElement.Extension.DYNAMICS)) {
            stream.stream.writeAttribute("timeformat", this.root.getTimeFormat().qname);
        }
        this.nodesAttributes.export(stream);
        this.edgesAttributes.export(stream);
        this.nodes.export(stream);
        this.edges.export(stream);
        stream.endElement();
    }
}

