/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.CoreOptions;
import ancestris.util.swing.DialogManager;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextFieldWidget;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShortNameBean
extends PropertyBean {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<table><row><l/><row><v wx=\"1\"/><check pad=\"0\"/></row></row><row><l/><v wx=\"1\"/></row></table>");
    private Property[] sameLastNames = new Property[0];
    private ChoiceWidget cLast;
    private ChoiceWidget cFirst;
    private JCheckBox cAll;
    private TextFieldWidget tSuff;

    private String getReplaceAllMsg() {
        if (this.sameLastNames.length < 2) {
            return null;
        }
        return RESOURCES.getString("choice.global.confirm", new Object[]{"" + this.sameLastNames.length, ((PropertyName)this.getProperty()).getLastName(), this.cLast.getText()});
    }

    public ShortNameBean() {
        this.setLayout((LayoutManager)LAYOUT.copy());
        this.cLast = new ChoiceWidget();
        this.cLast.addChangeListener((ChangeListener)this.changeSupport);
        this.cLast.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String msg = ShortNameBean.this.getReplaceAllMsg();
                if (msg != null) {
                    ShortNameBean.this.cAll.setVisible(true);
                    ShortNameBean.this.cAll.setToolTipText(msg);
                }
            }
        });
        this.cLast.setIgnoreCase(true);
        this.cFirst = new ChoiceWidget();
        this.cFirst.addChangeListener((ChangeListener)this.changeSupport);
        this.cFirst.setIgnoreCase(true);
        this.tSuff = new TextFieldWidget("", 10);
        this.cAll = new JCheckBox();
        this.cAll.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.cAll.setVisible(false);
        this.cAll.setRequestFocusEnabled(false);
        this.add(new JLabel(PropertyName.getLabelForLastName()));
        this.add((Component)this.cLast);
        this.add(this.cAll);
        this.add(new JLabel(PropertyName.getLabelForFirstName()));
        this.add((Component)this.cFirst);
        this.cAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = ShortNameBean.this.getReplaceAllMsg();
                if (msg != null && ShortNameBean.this.cAll.isSelected()) {
                    boolean yes = DialogManager.YES_OPTION == DialogManager.createYesNo((String)PropertyBean.RESOURCES.getString("choice.global.enable"), (String)msg).show();
                    ShortNameBean.this.cAll.setSelected(yes);
                }
            }
        });
        this.defaultFocus = this.cLast;
    }

    @Override
    protected void commitImpl(Property property) {
        PropertyName p = (PropertyName)property;
        Object first = this.cFirst.getText().trim();
        String last = this.cLast.getText().trim();
        String suff = this.tSuff.getText().trim();
        Gedcom ged = p.getGedcom();
        if (ged != null) {
            switch (CoreOptions.getInstance().getCorrectName()) {
                case 2: {
                    last = last.toUpperCase(ged.getLocale());
                    this.cLast.setText(last);
                }
                case 1: {
                    if (((String)first).length() <= 0) break;
                    first = Character.toString(((String)first).charAt(0)).toUpperCase(ged.getLocale()) + ((String)first).substring(1);
                    this.cFirst.setText((String)first);
                }
            }
        }
        String oldName = p.getLastName();
        p.setName((String)first, last, suff);
        if (this.cAll.isSelected()) {
            p.replaceAllLastNames(oldName);
        }
        this.setPropertyImpl((Property)p);
    }

    @Override
    public void setPropertyImpl(Property prop) {
        PropertyName name = (PropertyName)prop;
        if (name == null) {
            this.sameLastNames = new Property[0];
            this.cLast.setValues(PropertyName.getLastNames((Gedcom)this.getRoot().getGedcom(), (boolean)true));
            this.cLast.setText("");
            this.cFirst.setValues(PropertyName.getFirstNames((Gedcom)this.getRoot().getGedcom(), (boolean)true));
            this.cFirst.setText("");
            this.tSuff.setText("");
        } else {
            this.sameLastNames = name.getSameLastNames();
            this.cLast.setValues(name.getLastNames(true));
            this.cLast.setText(name.getLastName());
            this.cFirst.setValues(name.getFirstNames(true));
            this.cFirst.setText(name.getFirstName());
            this.tSuff.setText(name.getSuffix());
        }
        this.cAll.setVisible(false);
        this.cAll.setSelected(false);
    }
}

