/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.modules.editors.LanguagesConstants;
import ancestris.modules.editors.gedcomconversion.GedcomVersionConverter;
import ancestris.util.GedcomUtilities;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyChoiceMedium;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyCreate;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.SNote;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.values.AdopEnum;
import genj.gedcom.values.FamcStatEnum;
import genj.gedcom.values.MediEnum;
import genj.gedcom.values.NameTypeEnum;
import genj.gedcom.values.PediEnum;
import genj.gedcom.values.ResnEnum;
import genj.gedcom.values.RoleEnum;
import genj.util.Resources;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.openide.util.Exceptions;

public class GedcomSevenConverter
implements Runnable {
    private int counter;
    private String stateName;
    private GedcomVersionConverter converter = null;
    private Gedcom gedcom = null;
    private MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();

    public GedcomSevenConverter(GedcomVersionConverter converter) {
        this.converter = converter;
        this.gedcom = converter.gedcom;
    }

    public void notifyProgress() {
        this.converter.notifyProgress(this.counter, this.stateName);
    }

    private void setNextStepCounters(int nextInterval, int percentageFrom, int percentageTo, String step) {
        this.counter = this.converter.setNextStepCounters(nextInterval, percentageFrom, percentageTo, step);
        this.stateName = step;
        this.notifyProgress();
    }

    @Override
    public void run() {
        if (this.converter.upgrade) {
            this.upgrade();
        } else {
            this.downgrade();
        }
    }

    private void upgrade() {
        String convertedLanguage;
        this.setNextStepCounters(10, 0, 5, "Converting header...");
        Entity header = this.gedcom.getFirstEntity("HEAD");
        for (String extension : GedcomConstants.EXTENSIONS) {
            this.addTagSchemaIfExists(extension, header);
        }
        header.delProperties("FILE");
        header.delProperties("CHAR");
        Property gedc = header.getProperty("GEDC");
        gedc.delProperties("FORM");
        Property langue = header.getProperty("LANG");
        if (langue != null && !(convertedLanguage = LanguagesConstants.getConvertedLanguage("5.5.1", langue.getValue())).isEmpty()) {
            langue.setValue(convertedLanguage);
            this.gedcom.setLanguage(langue.getValue());
        }
        try {
            this.setNextStepCounters(this.gedcom.getEntities().size(), 1, 30, "Creating Creation Dates...");
            this.changeCrea();
            this.setNextStepCounters(this.gedcom.getEntities().size(), 30, 45, "Converting IDs...");
            this.adjustIdCharacters();
            this.setNextStepCounters(this.gedcom.getEntities("NOTE").size(), 45, 60, "Converting Notes...");
            this.changeNotes();
            this.setNextStepCounters(this.gedcom.getEntities().size(), 60, 65, "Converting Sources...");
            this.changeSources();
            this.setNextStepCounters(this.gedcom.getEntities("INDI").size() + this.gedcom.getEntities("FAM").size(), 65, 70, "Converting Individuals and Families...");
            this.changeINDIsnFAMs();
            this.changeINTDate();
            this.setNextStepCounters(this.gedcom.getEntities().size(), 70, 90, "Converting Medias...");
            this.changeMedia();
            this.adjustRole();
            this.setNextStepCounters(this.gedcom.getPropertiesByClass(PropertyAssociation.class).size(), 90, 95, "Converting Associations...");
            this.changeAsso();
            this.setNextStepCounters(this.gedcom.getEntities().size(), 95, 99, "Repositionning creation dates...");
            this.repositionDates();
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void changeAsso() throws GedcomException {
        String rela = "";
        ArrayList assos = new ArrayList();
        assos.addAll(this.gedcom.getPropertiesByClass(PropertyAssociation.class));
        for (PropertyAssociation prop : assos) {
            PropertyEvent event;
            ++this.counter;
            this.notifyProgress();
            Indi indiRela = (Indi)prop.getEntity();
            if (prop.getTarget() == null) continue;
            Property propCible = prop.getTarget().getParent();
            Property relaProp = prop.getProperty("RELA");
            boolean hasAnchor = false;
            if (relaProp != null) {
                rela = relaProp.getDisplayValue();
                boolean bl = hasAnchor = ((PropertyRelationship)relaProp).getAnchor() != null;
            }
            if (hasAnchor) {
                prop.getParent().delProperty((Property)prop);
                Property asso = propCible.addPropertyXref("ASSO", indiRela.getId(), -1);
                if (asso instanceof PropertyAssociation) {
                    PropertyAssociation propertyAssociation = (PropertyAssociation)asso;
                    propertyAssociation.link();
                }
                this.addAdjustRole(asso, rela);
            } else {
                if (relaProp != null) {
                    prop.delProperty(relaProp);
                }
                this.addAdjustRole((Property)prop, rela);
            }
            if (!(propCible instanceof PropertyEvent) || (event = (PropertyEvent)propCible) == null || event.isKnownToHaveHappened() == null || !event.isKnownToHaveHappened().booleanValue() || event.getNoOfProperties() <= 0) continue;
            event.setValue("");
        }
    }

    private void addAdjustRole(Property parent, String rela) {
        String currentValue = rela.toLowerCase(Locale.getDefault()).trim();
        for (RoleEnum role : RoleEnum.values()) {
            String roleStr = role.getDisplayValue().toLowerCase(Locale.getDefault()).trim();
            if (!roleStr.equals(currentValue) && !roleStr.contains(currentValue)) continue;
            parent.addProperty("ROLE", role.name());
            return;
        }
        Property prop = parent.addProperty("ROLE", "");
        prop.setValue(currentValue);
    }

    private void adjustRole() {
        for (Property role : this.gedcom.getPropertiesByClass(PropertyChoiceValue.class)) {
            if (!"ROLE".equals(role.getTag()) || role.isValid()) continue;
            String currentValue = role.getDisplayValue().toLowerCase(Locale.getDefault()).trim();
            int n = 0;
            RoleEnum[] roleEnumArray = RoleEnum.values();
            int n2 = roleEnumArray.length;
            if (n >= n2) continue;
            RoleEnum roleEnum = roleEnumArray[n];
            String roleStr = roleEnum.getDisplayValue().toLowerCase(Locale.getDefault()).trim();
            if (roleStr.equals(currentValue) || roleStr.contains(currentValue)) {
                role.setValue(roleEnum.name());
                continue;
            }
            role.setValue(RoleEnum.OTHER.name());
            if (currentValue.isEmpty()) continue;
            role.addProperty("PHRASE", currentValue);
        }
    }

    private void changeMedia() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities());
        for (Entity ent : allEnts) {
            ++this.counter;
            this.notifyProgress();
            ArrayList allProps = new ArrayList();
            allProps.addAll(ent.getAllProperties("OBJE"));
            for (Property p : allProps) {
                if (p instanceof PropertyMedia) continue;
                Property parent = p.getParent();
                Media newMedia = (Media)this.gedcom.createEntity("OBJE");
                Property mediaLink = parent.addMedia(newMedia);
                Property pTitl = p.getProperty("TITL");
                if (pTitl != null) {
                    boolean moved = false;
                    Property[] propertyArray = p.getProperties("FILE");
                    int n = propertyArray.length;
                    for (int i = 0; i < n; ++i) {
                        Property pFile = propertyArray[i];
                        pFile.addProperty("TITL", pTitl.getValue());
                        moved = true;
                    }
                    if (moved) {
                        p.delProperty(pTitl);
                    }
                }
                for (Property child : p.getProperties()) {
                    if (child.getTag().equals("TITL") || child.isSpecific()) {
                        GedcomSevenConverter.movePropertyRecursively(child, mediaLink);
                        continue;
                    }
                    GedcomSevenConverter.movePropertyRecursively(child, (Property)newMedia);
                }
                int pos = parent.getPropertyPosition(p);
                parent.delProperty(p);
                parent.moveProperty(mediaLink, pos);
            }
        }
        for (Entity ent : this.gedcom.getEntities("OBJE")) {
            for (Property pFile : ent.getProperties("FILE")) {
                String fValue = pFile.getValue();
                pFile.setValue(this.adjustFileName(fValue));
                Property pForm = pFile.getProperty("FORM");
                if (pForm == null) continue;
                pForm.setValue(this.getMimeType(pForm.getValue()));
                Property pMediaType = pForm.getProperty("MEDI");
                if (pMediaType != null) {
                    this.adjustMediaType(pMediaType);
                    continue;
                }
                Property pType = pForm.getProperty("TYPE");
                if (pType == null) continue;
                this.adjustMediaType(pType);
            }
            for (Property p : ent.getAllProperties("RESN")) {
                this.adjustEnum(p, this.getMatchingResn(p.getValue()));
            }
        }
    }

    private String adjustFileName(String fValue) {
        String retour = fValue;
        if (retour.contains("://")) {
            return retour;
        }
        if (retour.startsWith("\\\\")) {
            return "file:" + this.escapePath(retour.replace('\\', '/'));
        }
        if (retour.matches("[A-Za-z]:\\\\.*") || retour.matches("[A-Za-z]:/.*")) {
            return "file:///" + retour.charAt(0) + ":/" + this.escapePath(retour.substring(3).replace('\\', '/'));
        }
        if (retour.startsWith("/")) {
            return "file://" + this.escapePath(retour);
        }
        return this.escapePath(retour.replace('\\', '/'));
    }

    private String escapePath(String url) {
        String retour = url;
        retour = retour.replace("%", "%25");
        retour = retour.replace(":", "%3A");
        retour = retour.replace("?", "%3F");
        retour = retour.replace("#", "%23");
        retour = retour.replace("[", "%5B");
        retour = retour.replace("]", "%5D");
        retour = retour.replace("@", "%40");
        return retour;
    }

    private void adjustMediaType(Property pMediaType) throws GedcomException {
        if (pMediaType instanceof PropertyChoiceMedium) {
            PropertyChoiceMedium mediaProp = (PropertyChoiceMedium)pMediaType;
            String phrase = mediaProp.getPhrase();
            if (!phrase.isEmpty()) {
                String value = this.getMatchingMedia(phrase);
                mediaProp.setValue(value);
                if (!value.equals(phrase)) {
                    mediaProp.delProperty(mediaProp.getProperty("PHRASE"));
                }
            }
        } else {
            this.adjustEnum(pMediaType, this.getMatchingMedia(pMediaType.getValue()), "MEDI");
        }
    }

    private void adjustEnum(Property p, String value) throws GedcomException {
        this.adjustEnum(p, value, p.getTag());
    }

    private void adjustEnum(Property p, String value, String tag) throws GedcomException {
        Property parent = p.getParent();
        Property pEnum = parent.addProperty(tag, "", parent.getPropertyPosition(p));
        pEnum.setValue(value);
        for (Property child : p.getProperties()) {
            GedcomSevenConverter.movePropertyRecursively(child, pEnum);
        }
        parent.delProperty(p);
    }

    private String getMatchingMedia(String value) {
        String ret = value;
        String[] choices = Resources.get(Gedcom.class).getString("MEDI.vals", false).split(",");
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].toLowerCase(Locale.getDefault()).trim().equals(value.toLowerCase(Locale.getDefault()).trim())) continue;
            ret = MediEnum.values()[i].getDisplayValue();
            break;
        }
        return ret;
    }

    private String getMatchingPedi(String value) {
        String ret = value;
        String[] choices = Resources.get(Gedcom.class).getString("PEDI.vals", false).split(",");
        int[] map = new int[]{0, 1, 2, 3};
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].toLowerCase(Locale.getDefault()).trim().equals(value.toLowerCase(Locale.getDefault()).trim())) continue;
            ret = PediEnum.values()[map[i]].getDisplayValue();
            break;
        }
        return ret;
    }

    private String getMatchingNameType(String value) {
        String ret = value;
        String[] choices = Resources.get(Gedcom.class).getString("NAME-TYPE.vals", false).split(",");
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].toLowerCase(Locale.getDefault()).trim().equals(value.toLowerCase(Locale.getDefault()).trim())) continue;
            ret = NameTypeEnum.values()[i].getDisplayValue();
            break;
        }
        return ret;
    }

    private String getMatchingResn(String value) {
        String ret = value;
        String[] choices = Resources.get(Gedcom.class).getString("RESN.vals", false).split(",");
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].toLowerCase(Locale.getDefault()).trim().equals(value.toLowerCase(Locale.getDefault()).trim())) continue;
            ret = ResnEnum.values()[i].getDisplayValue();
            break;
        }
        return ret;
    }

    private String getMatchingFamcStat(String value) {
        String ret = value;
        String valueLC = value.toLowerCase(Locale.getDefault()).trim();
        if (valueLC.contains("challenged")) {
            ret = FamcStatEnum.values()[0].getDisplayValue();
        } else if (valueLC.contains("disproven")) {
            ret = FamcStatEnum.values()[1].getDisplayValue();
        } else if (valueLC.contains("proven")) {
            ret = FamcStatEnum.values()[2].getDisplayValue();
        }
        return ret;
    }

    private String getMatchingFamcAdop(String value) {
        String ret = value;
        String[] choices = Resources.get(Gedcom.class).getString("ADOP.vals", false).split(",");
        int[] map = new int[]{0, 1, 2};
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].toLowerCase(Locale.getDefault()).trim().equals(value.toLowerCase(Locale.getDefault()).trim())) continue;
            ret = AdopEnum.values()[map[i]].getDisplayValue();
            break;
        }
        return ret;
    }

    private String getMimeType(String value) {
        String retour = value.toLowerCase();
        try {
            for (MediaType mt : this.allTypes.getMediaTypeRegistry().getTypes()) {
                MimeType mit = this.allTypes.getRegisteredMimeType(mt.toString());
                if (!mit.getExtension().equals("." + value)) continue;
                retour = mit.getName();
                break;
            }
        }
        catch (MimeTypeException e) {
            retour = value;
        }
        if ("image/jpeg".equals(retour)) {
            retour = "image/jpg";
        }
        if ("web".equals(retour)) {
            retour = "text/html";
        }
        return retour;
    }

    private void changeSources() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities());
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        for (Entity ent : allEnts) {
            ++this.counter;
            this.notifyProgress();
            ArrayList allProps = new ArrayList();
            allProps.addAll(ent.getAllProperties("SOUR"));
            for (Property p : allProps) {
                if (!(p instanceof PropertySource)) {
                    Source newSource = (Source)this.gedcom.createEntity("SOUR");
                    Property parent = p.getParent();
                    Property sourceLink = parent.addSource(newSource);
                    if (sourceLink == null) continue;
                    for (Property child : p.getProperties()) {
                        if (child.getTag().equals("QUAY") || child.isSpecific()) {
                            GedcomSevenConverter.movePropertyRecursively(child, sourceLink);
                            continue;
                        }
                        GedcomSevenConverter.movePropertyRecursively(child, (Property)newSource);
                    }
                    Property titlProp = newSource.getProperty("TITL");
                    if (titlProp != null) {
                        titlProp.setValue(p.getValue());
                    } else {
                        newSource.addProperty("TITL", p.getValue());
                    }
                    int pos = parent.getPropertyPosition(p);
                    parent.delProperty(p);
                    parent.moveProperty(sourceLink, pos);
                    continue;
                }
                for (Source pEven : p.getProperties("EVEN")) {
                    for (Property role : pEven.getAllProperties("ROLE")) {
                        this.addAdjustRole(role.getParent(), role.getValue());
                        role.getParent().delProperty(role);
                    }
                    this.adjustEnum((Property)pEven, pEven.getValue());
                }
            }
        }
        for (Entity ent : this.gedcom.getEntities("SOUR")) {
            for (Property pRepo : ent.getProperties("REPO")) {
                for (Property pCaln : pRepo.getProperties("CALN")) {
                    for (Property pMediaType : pCaln.getProperties("MEDI")) {
                        this.adjustMediaType(pMediaType);
                    }
                }
            }
            for (Property pData : ent.getProperties("DATA")) {
                for (Property pEven : pData.getProperties("EVEN")) {
                    this.adjustEnum(pEven, pEven.getValue());
                }
            }
        }
    }

    private void changeINDIsnFAMs() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities("INDI"));
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        allEnts.addAll(this.gedcom.getEntities("FAM"));
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        for (Entity ent : allEnts) {
            ++this.counter;
            this.notifyProgress();
            ArrayList allProps = new ArrayList();
            allProps.addAll(ent.getAllProperties("RESI"));
            for (Property p : allProps) {
                Property pType = p.getProperty("TYPE");
                if (pType == null) continue;
                p.setValue(pType.getValue());
                p.delProperty(pType);
            }
            allProps.clear();
            allProps.addAll(ent.getProperties(PropertyName.class));
            for (Property p : allProps) {
                PropertyName pName = (PropertyName)p;
                Property pFirst = pName.getProperty("GIVN");
                Property pLast = pName.getProperty("SURN");
                boolean guessedF = pFirst != null ? pFirst.isGuessed() : true;
                boolean guessedL = pLast != null ? pLast.isGuessed() : true;
                String firstName = pName.getFirstName().replaceAll(",", " ").replaceAll(" +", " ");
                String lastName = pName.getLastName();
                pName.setName(firstName, lastName);
                pFirst = pName.getProperty("GIVN");
                pLast = pName.getProperty("SURN");
                if (pFirst != null) {
                    pFirst.setGuessed(guessedF);
                }
                if (pLast == null) continue;
                pLast.setGuessed(guessedL);
            }
            allProps.clear();
            allProps.addAll(ent.getAllProperties("AGE"));
            for (Property p : allProps) {
                String age = p.getValue();
                if (age.isEmpty() || p.isValid()) continue;
                Property phrase = p.getProperty("PHRASE");
                if (phrase == null) {
                    phrase = p.addProperty("PHRASE", "");
                }
                phrase.setValue(age);
                p.setValue("");
            }
            if (ent instanceof Indi) {
                for (Property famc : ent.getProperties(new TagPath("INDI:FAMC"))) {
                    Property statProp;
                    Property pediProp = famc.getProperty("PEDI");
                    if (pediProp != null) {
                        this.adjustEnum(pediProp, this.getMatchingPedi(pediProp.getValue()));
                    }
                    if ((statProp = famc.getProperty("STAT")) == null) continue;
                    this.adjustEnum(statProp, this.getMatchingFamcStat(statProp.getValue()));
                }
                for (Property p : ent.getProperties(new TagPath("INDI:NAME:TYPE"))) {
                    this.adjustEnum(p, this.getMatchingNameType(p.getValue()));
                }
                for (Property p : ent.getProperties(new TagPath("INDI:ADOP:FAMC:ADOP"))) {
                    this.adjustEnum(p, this.getMatchingFamcAdop(p.getValue()));
                }
            }
            for (Property p : ent.getAllProperties("RESN")) {
                this.adjustEnum(p, this.getMatchingResn(p.getValue()));
            }
        }
    }

    private void changeINTDate() {
        for (PropertyDate pdate : this.gedcom.getPropertiesByClass(PropertyDate.class)) {
            if (!PropertyDate.INTERPRETED.equals(pdate.getFormat())) continue;
            pdate.setFormat(PropertyDate.ESTIMATED);
        }
    }

    private void changeNotes() throws GedcomException {
        ArrayList notes = new ArrayList();
        notes.addAll(this.gedcom.getEntities("NOTE"));
        for (Note note : notes) {
            ++this.counter;
            this.notifyProgress();
            SNote snote = (SNote)this.gedcom.createEntity("SNOTE", "S" + note.getId());
            snote.setValue(note.getValue());
            Property pCrea = note.getProperty("CREA");
            if (pCrea != null) {
                PropertyCreate sCreate = (PropertyCreate)snote.getProperty("CREA");
                sCreate.setValue(pCrea.getValue());
                note.delProperty(pCrea);
            }
            Property pChan = note.getProperty("CHAN");
            PropertyChange sChan = (PropertyChange)snote.getProperty("CHAN");
            long previousChangeTime = 0L;
            if (pChan != null && pChan instanceof PropertyChange) {
                Property[] pSubNotes;
                Property[] pChange = (Property[])pChan;
                previousChangeTime = pChange.getTime();
                for (Property pSubNote : pSubNotes = pChan.getProperties("NOTE")) {
                    sChan.addProperty("NOTE", pSubNote.getValue());
                }
                note.delProperty(pChan);
            }
            GedcomUtilities.copyPropertiesRecursively((Property)note, (Property)snote, (boolean)false);
            for (Property ssubnote : snote.getProperties("NOTE")) {
                if (ssubnote == snote.getDelegate()) continue;
                snote.delProperty(ssubnote);
            }
            List refs = note.getProperties(PropertyForeignXRef.class);
            for (PropertyForeignXRef pfxref : refs) {
                Property e = (Property)pfxref.getTargetParent().get();
                e.addNote((AbstractNote)snote);
            }
            sChan.setTime(previousChangeTime);
            this.gedcom.deleteEntity((Entity)note);
        }
        ArrayList snotes = new ArrayList();
        snotes.addAll(this.gedcom.getEntities("SNOTE"));
        for (SNote snote : snotes) {
            snote.setId(snote.getId().substring(1));
        }
    }

    private void addTagSchemaIfExists(String tag, Entity header) {
        if (this.gedcom.getPropertyCount(tag) != 0) {
            Property schma = this.addScheme(header);
            schma.addProperty("TAG", tag + " https://docs.ancestris.org/books/user-guide/page/tags#bkmrk-ancestris-tags");
        }
    }

    private Property addScheme(Entity header) {
        Property[] schmas = header.getProperties("SCHMA");
        if (schmas.length == 0) {
            header.addProperty("SCHMA", null);
        }
        schmas = header.getProperties("SCHMA");
        return schmas[0];
    }

    private void adjustIdCharacters() throws GedcomException {
        Pattern pattern = Pattern.compile("^[0-9A-Z_]+$");
        Pattern unallowed = Pattern.compile("[^0-9A-Z_]");
        for (Entity ent : this.gedcom.getEntities()) {
            Matcher match;
            ++this.counter;
            this.notifyProgress();
            String id = ent.getId();
            if ("VOID".equals(id)) {
                ent.setId("_VOID");
            }
            if (!(match = pattern.matcher(id)).matches()) {
                ent.setId(unallowed.matcher(id.toUpperCase()).replaceAll("_"));
            }
            this.replaceUTags(ent);
            this.eraseAtValues(ent);
            this.changeReferenceNumber(ent);
        }
    }

    private void changeReferenceNumber(Entity e) {
        Property exid;
        Property parent;
        ArrayList afnList = new ArrayList();
        afnList.addAll(e.getAllProperties("AFN"));
        for (Property p : afnList) {
            parent = p.getParent();
            exid = parent.addProperty("EXID", p.getValue());
            exid.addProperty("TYPE", "https://gedcom.io/terms/v7/AFN");
            parent.delProperty(p);
        }
        afnList.clear();
        afnList.addAll(e.getAllProperties("RIN"));
        for (Property p : afnList) {
            parent = p.getParent();
            exid = parent.addProperty("EXID", p.getValue());
            exid.addProperty("TYPE", "https://gedcom.io/terms/v7/RIN");
            parent.delProperty(p);
        }
        afnList.clear();
        afnList.addAll(e.getAllProperties("RFN"));
        for (Property p : afnList) {
            parent = p.getParent();
            exid = parent.addProperty("EXID", p.getValue());
            exid.addProperty("TYPE", "https://gedcom.io/terms/v7/RFN");
            parent.delProperty(p);
        }
    }

    private void replaceUTags(Entity e) {
        for (Property pTime : e.getAllProperties("_TIME")) {
            Property parent = pTime.getParent();
            if (parent instanceof PropertyDate) {
                if (parent.getProperty("TIME") == null) {
                    parent.addProperty("TIME", this.replaceTime(pTime.getValue()));
                }
            } else {
                Property pDate = parent.getProperty("DATE");
                if (pDate.getProperty("TIME") == null) {
                    pDate.addProperty("TIME", this.replaceTime(pTime.getValue()));
                }
            }
            parent.delProperty(pTime);
        }
    }

    private void eraseAtValues(Entity e) {
        Pattern tag = Pattern.compile("(FAMC|FAMS|HUSB|WIFE|CHIL|SUBM|ALIA|ANCI|DESI|ASSO|SNOTE|SOUR|REPO)");
        Pattern value = Pattern.compile("@");
        for (Property prop : e.findProperties(tag, value)) {
            prop.setValue("");
        }
    }

    private String replaceTime(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("[a-zA-Z]", ":").replaceAll(" ", "");
    }

    private void changeCrea() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities());
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        for (Entity ent : allEnts) {
            ++this.counter;
            this.notifyProgress();
            Property crea = ent.getProperty("CREA");
            if (crea != null) continue;
            crea = ent.addProperty("CREA", "", ent.getNoOfProperties());
            Property chan = ent.getProperty("CHAN");
            if (chan == null) continue;
            crea.setValue(chan.getValue());
        }
    }

    private void repositionDates() {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities());
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        for (Entity ent : allEnts) {
            ++this.counter;
            this.notifyProgress();
            Property p = ent.getProperty("CREA");
            if (p != null) {
                ent.moveProperty(p, ent.getNoOfProperties());
            }
            if ((p = ent.getProperty("CHAN")) == null) continue;
            ent.moveProperty(p, ent.getNoOfProperties());
        }
    }

    private void downgrade() {
        String[] value;
        String convertedLanguage;
        this.setNextStepCounters(10, 0, 5, "Converting header...");
        Entity header = this.gedcom.getFirstEntity("HEAD");
        Property[] schmas = header.getProperties("SCHMA");
        if (schmas.length != 0) {
            header.delProperties("SCHMA");
        }
        header.addProperty("FILE", this.gedcom.getName());
        header.addProperty("CHAR", "UTF-8");
        Property langue = header.getProperty("LANG");
        if (langue != null && !"".equals(convertedLanguage = LanguagesConstants.getConvertedLanguage("7.0.13", (value = langue.getValue().split("_"))[0]))) {
            langue.setValue(convertedLanguage);
            this.gedcom.setLanguage(langue.getValue());
        }
        try {
            this.setNextStepCounters(this.gedcom.getEntities("SNOTE").size(), 5, 15, "Removing SNOTEs...");
            this.removeSnote();
            this.setNextStepCounters(this.gedcom.getEntities("OBJE").size(), 15, 30, "Converting Medias...");
            this.downgradeMedia();
            this.setNextStepCounters(this.gedcom.getEntities("INDI").size() + this.gedcom.getEntities("FAM").size(), 30, 35, "Converting Individuals and Families...");
            this.downgradeINDIsnFAMs();
            this.setNextStepCounters(this.gedcom.getPropertiesByClass(PropertyAssociation.class).size(), 35, 50, "Converting Associations...");
            this.downgradeAsso();
            this.downgradeRole();
            this.setNextStepCounters(this.gedcom.getEntities().size(), 50, 80, "Removing creation dates...");
            this.removeCrea();
            this.setNextStepCounters(this.gedcom.getEntities().size(), 80, 98, "Converting Entity IDs...");
            this.adjustEntity();
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void adjustEntity() {
        for (Entity e : this.gedcom.getEntities()) {
            Property parent;
            ++this.counter;
            this.notifyProgress();
            for (Property p : e.getAllProperties("TIME")) {
                if (this.converter.toGrammar.isValid(p.getPath())) continue;
                Property parent2 = p.getParent();
                parent2.addProperty("_TIME", p.getValue());
                parent2.delProperty(p);
            }
            ArrayList exidList = new ArrayList();
            exidList.addAll(e.getAllProperties("EXID"));
            for (Property p : exidList) {
                parent = p.getParent();
                Property type = p.getProperty("TYPE");
                if (type == null) {
                    parent.addProperty("_EXID", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                if (type.getValue().contains("https://gedcom.io/terms/v7/AFN")) {
                    parent.addProperty("AFN", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                if (type.getValue().contains("https://gedcom.io/terms/v7/RIN")) {
                    parent.addProperty("RIN", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                if (type.getValue().contains("https://gedcom.io/terms/v7/RFN")) {
                    parent.addProperty("RFN", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                Property uExid = parent.addProperty("_EXID", p.getValue());
                uExid.addProperty("_TYPE", type.getValue());
                parent.delProperty(p);
            }
            for (Property p : e.getAllProperties("PHRASE")) {
                parent = p.getParent();
                parent.setValue(p.getValue());
                parent.delProperty(p);
            }
        }
    }

    private void downgradeAsso() throws GedcomException {
        ArrayList assos = new ArrayList();
        assos.addAll(this.gedcom.getPropertiesByClass(PropertyAssociation.class));
        for (PropertyAssociation prop : assos) {
            Property parent;
            ++this.counter;
            this.notifyProgress();
            String roleValue = "";
            Property pRole = prop.getProperty("ROLE");
            if (pRole != null) {
                String value = pRole.getValue();
                RoleEnum rEnum = RoleEnum.valueOf((String)value);
                switch (rEnum) {
                    case OTHER: {
                        Property phrase = pRole.getProperty("PHRASE");
                        roleValue = phrase.getValue();
                        prop.addProperty("RELA", roleValue);
                        break;
                    }
                    default: {
                        roleValue = rEnum.getDisplayValue();
                        prop.addProperty("RELA", roleValue);
                    }
                }
                prop.delProperty(pRole);
            }
            if ((parent = prop.getParent()) instanceof Indi) continue;
            Property cible = (Property)prop.getTargetParent().get();
            TagPath anchor = parent.getPath(true);
            parent.delProperty((Property)prop);
            Property assoCible = cible.addPropertyXref("ASSO", parent.getEntity().getId(), -1);
            assoCible.addProperty("RELA", roleValue + " @#" + anchor.toString() + "@");
            if (!(assoCible instanceof PropertyAssociation)) continue;
            PropertyAssociation propertyAssociation = (PropertyAssociation)assoCible;
            propertyAssociation.link();
        }
    }

    private void downgradeRole() {
        for (Property pRole : this.gedcom.getPropertiesByClass(PropertyChoiceRole.class)) {
            Property phrase = pRole.getProperty("PHRASE");
            if (phrase == null || !"ROLE".equals(pRole.getTag())) continue;
            Property parent = pRole.getParent();
            String value = phrase.getDisplayValue();
            parent.delProperty(pRole);
            parent.addProperty("ROLE", value);
        }
    }

    private void downgradeINDIsnFAMs() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities("INDI"));
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        allEnts.addAll(this.gedcom.getEntities("FAM"));
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        for (Entity ent : allEnts) {
            ++this.counter;
            this.notifyProgress();
            ArrayList allProps = new ArrayList();
            allProps.addAll(ent.getAllProperties("RESI"));
            for (Property p : allProps) {
                Property pType = p.getProperty("TYPE");
                if (pType != null) continue;
                p.addProperty("TYPE", p.getValue());
                p.setValue("");
            }
            allProps.clear();
            allProps.addAll(ent.getAllProperties("AGE"));
            for (Property p : allProps) {
                String phraseStr;
                Property phrase = p.getProperty("PHRASE");
                if (phrase == null || (phraseStr = phrase.getValue()).isEmpty()) continue;
                if (p instanceof PropertyAge) {
                    PropertyAge pAge = (PropertyAge)p;
                    if (pAge.getAge().getValue().equals("0d")) {
                        ((PropertyAge)p).setValue(phraseStr);
                    } else {
                        p.addProperty("_PHRASE", phraseStr);
                    }
                }
                phrase.getParent().delProperty(phrase);
            }
        }
    }

    private void downgradeMedia() {
        block3: for (Entity ent : this.gedcom.getEntities("OBJE")) {
            ++this.counter;
            this.notifyProgress();
            Property pFile = ent.getProperty("FILE");
            if (pFile == null) continue;
            pFile.setValue(this.downgradeFileName(pFile.getValue()));
            Property pForm = pFile.getProperty("FORM");
            pForm.setValue(this.getExtensionFromMType(pForm.getValue()));
            Property pMediaType = pForm.getProperty("MEDI");
            if (pMediaType == null) continue;
            String value = pMediaType.getValue();
            MediEnum mtEnum = MediEnum.valueOf((String)value);
            switch (mtEnum) {
                case OTHER: {
                    Property pPhrase = pMediaType.getProperty("PHRASE");
                    pMediaType.setValue(pPhrase.getValue());
                    continue block3;
                }
            }
            pMediaType.setValue(mtEnum.getDisplayValue());
        }
    }

    private String downgradeFileName(String fValue) {
        String retour = fValue;
        if (retour.contains("file:///")) {
            return this.unescapePath(retour.substring(8));
        }
        if (retour.contains("http://") || retour.contains("https://") || retour.contains("HTTP://") || retour.contains("HTTPS://")) {
            return retour;
        }
        return this.unescapePath(retour);
    }

    private String unescapePath(String url) {
        String retour = url;
        retour = retour.replace("%40", "@");
        retour = retour.replace("%5D", "]");
        retour = retour.replace("%5B", "[");
        retour = retour.replace("%23", "#");
        retour = retour.replace("%3F", "?");
        retour = retour.replace("%3A", ":");
        retour = retour.replace("%25", "%");
        return retour;
    }

    private void removeSnote() throws GedcomException {
        ArrayList snotes = new ArrayList();
        snotes.addAll(this.gedcom.getEntities("SNOTE"));
        for (SNote snote : snotes) {
            ++this.counter;
            this.notifyProgress();
            Note note = (Note)this.gedcom.createEntity("NOTE", "N" + snote.getId());
            Property sCrea = snote.getProperty("CREA");
            if (sCrea != null) {
                snote.delProperty(sCrea);
            }
            Property sChan = snote.getProperty("CHAN");
            PropertyChange pChan = (PropertyChange)note.getProperty("CHAN");
            if (pChan == null) {
                note.addProperty("CHAN", "");
                pChan = (PropertyChange)note.getProperty("CHAN");
            }
            long previousChangeTime = 0L;
            if (sChan != null && sChan instanceof PropertyChange) {
                Property[] sSubNotes;
                Property[] sChange = (Property[])sChan;
                previousChangeTime = sChange.getTime();
                for (Property sSubNote : sSubNotes = sChan.getProperties("NOTE")) {
                    pChan.addProperty("NOTE", sSubNote.getValue());
                }
                snote.delProperty(sChan);
            }
            GedcomUtilities.copyPropertiesRecursively((Property)snote, (Property)note, (boolean)false);
            for (Property subnote : note.getProperties("NOTE")) {
                if (subnote == note.getDelegate()) continue;
                note.delProperty(subnote);
            }
            List refs = snote.getProperties(PropertyForeignXRef.class);
            for (PropertyForeignXRef pfxref : refs) {
                Property e = (Property)pfxref.getTargetParent().get();
                e.addNote((AbstractNote)note);
            }
            pChan.setTime(previousChangeTime);
            this.gedcom.deleteEntity((Entity)snote);
        }
        ArrayList notes = new ArrayList();
        notes.addAll(this.gedcom.getEntities("NOTE"));
        for (Note note : notes) {
            note.setId(note.getId().substring(1));
        }
    }

    private void removeCrea() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities());
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        for (Entity ent : allEnts) {
            ++this.counter;
            this.notifyProgress();
            Property crea = ent.getProperty("CREA");
            if (crea == null) continue;
            ent.delProperty(crea);
        }
    }

    private String getExtensionFromMType(String value) {
        try {
            MimeType mit = this.allTypes.getRegisteredMimeType(value);
            if (mit == null && "image/jpg".equals(value)) {
                mit = this.allTypes.getRegisteredMimeType("image/jpeg");
            }
            if (mit == null) {
                return "WEB";
            }
            String extension = mit.getExtension();
            return extension.substring(1);
        }
        catch (MimeTypeException e) {
            return "WEB";
        }
    }

    public void getPropertiesRecursively(Property parent, List<Property> props) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            props.add(child);
            this.getPropertiesRecursively(child, props);
        }
    }

    private static Property getLastPropertyPosition(Property parentPropertyDest, String tag) {
        Property ret = null;
        int max = -1;
        for (Property prop : parentPropertyDest.getProperties(tag)) {
            int pos = parentPropertyDest.getPropertyPosition(prop);
            if (pos <= max) continue;
            ret = prop;
            max = pos;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void movePropertyRecursively(Property propertySrc, Property parentPropertyDest) throws GedcomException {
        boolean isSameValue;
        Property propertyDest = GedcomSevenConverter.getLastPropertyPosition(parentPropertyDest, propertySrc.getTag());
        boolean tagAlreadyExists = propertyDest != null;
        boolean isSingleton = propertySrc.getMetaProperty().isSingleton();
        int n = tagAlreadyExists ? parentPropertyDest.getPropertyPosition(propertyDest) + 1 : parentPropertyDest.getNoOfProperties();
        boolean bl = isSameValue = tagAlreadyExists && GedcomUtilities.isSameValue((Property)propertySrc, (Property)propertyDest);
        if (propertySrc instanceof PropertyForeignXRef) {
            PropertyForeignXRef pfxref = (PropertyForeignXRef)propertySrc;
            PropertyXRef pxref = pfxref.getTarget();
            if (pxref == null) return;
            pxref.unlink();
            pxref.setValue(parentPropertyDest.getEntity().getId());
            pxref.link();
            return;
        }
        if (!tagAlreadyExists || !isSingleton && !isSameValue) {
            if (propertySrc instanceof PropertyName) {
                propertyDest = parentPropertyDest.addProperty(propertySrc.getTag(), "", n);
            } else if (propertySrc instanceof PropertyXRef) {
                propertyDest = parentPropertyDest.addProperty(propertySrc.getTag(), propertySrc.getValue(), n);
            } else {
                propertyDest = parentPropertyDest.addProperty(propertySrc.getTag(), "", n);
                propertyDest.setValue(propertySrc.getValue());
            }
            if (propertyDest instanceof PropertyXRef) {
                PropertyXRef propertyXRef = (PropertyXRef)propertyDest;
                propertyXRef.link();
            }
        }
        for (Property children : propertySrc.getProperties()) {
            GedcomSevenConverter.movePropertyRecursively(children, propertyDest);
        }
        if (propertySrc instanceof PropertyXRef) {
            PropertyXRef pxref = (PropertyXRef)propertySrc;
            if (propertySrc.isValid()) {
                Property parent = pxref.getTarget().getParent();
                parent.delProperty((Property)pxref.getTarget());
                return;
            }
        }
        propertySrc.getParent().delProperty(propertySrc);
    }
}

