/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.app.ActionOpenDefault;
import ancestris.app.App;
import ancestris.app.AppOptions;
import ancestris.app.OptionFilesOptionsPanelController;
import ancestris.core.CoreOptions;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.URLUtil;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.GedcomOptions;
import genj.io.Options;
import genj.util.Registry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.actions.Openable;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class OptionFilesPanel
extends JPanel {
    private final OptionFilesOptionsPanelController controller;
    private String oldValueDefaultFile = "";
    private boolean isDefaultFileValid = true;
    private String oldValueReportDir = "";
    private boolean isReportDirValid = true;
    private String oldValueBackupDir = "";
    private boolean isBackupDirValid = true;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinner1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JCheckBox jcbAlwaysOpen;
    private JCheckBox jcbOpenNothing;
    private JCheckBox jcbSortEntity;
    private JComboBox logLevel;
    private JPanel mainPanel;
    private JSpinner nbBackups;
    private JSpinner nbMinAutosave;

    OptionFilesPanel(OptionFilesOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void chooseFileDir(JTextField jTF, boolean dirOnly, boolean filesOnly) {
        File file;
        FileChooserBuilder fcb = new FileChooserBuilder(OptionFilesPanel.class.getCanonicalName() + dirOnly).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)(dirOnly ? "TITL_GetDefaultDir" : "TITL_GetDefaultGedcom"))).setApproveText(NbBundle.getMessage(this.getClass(), (String)"OK_Select")).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setFileFilter((FileFilter)(dirOnly ? null : FileChooserBuilder.getGedcomFilter())).setAcceptAllFileFilterUsed(dirOnly).setFileHiding(true).setParent((Component)this).setSelectedFile(new File(jTF.getText())).setDefaultWorkingDirectory(new File(System.getProperty("user.home")));
        if (filesOnly) {
            fcb.setFilesOnly(filesOnly);
        }
        if (dirOnly) {
            fcb.setDirectoriesOnly(dirOnly);
        }
        if ((file = fcb.showOpenDialog()) != null) {
            jTF.setText(file.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.jLabel14 = new JLabel();
        this.jButton4 = new JButton();
        this.jTextField3 = new JTextField();
        this.logLevel = new JComboBox();
        this.jButton3 = new JButton();
        this.jcbAlwaysOpen = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.jcbOpenNothing = new JCheckBox();
        this.jButton2 = new JButton();
        this.jcbSortEntity = new JCheckBox();
        this.jSpinner1 = new JSpinner(new SpinnerNumberModel(2048, 128, 16384, 128));
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.nbBackups = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.nbMinAutosave = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel14.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jButton4.text"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jTextField3.setText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField3.text"));
        this.jTextField3.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField3.toolTipText"));
        this.logLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL"}));
        this.logLevel.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.logLevel.toolTipText"));
        this.logLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.logLevelActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jButton3.text"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.jButton3ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jcbAlwaysOpen, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbAlwaysOpen.text"));
        this.jcbAlwaysOpen.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbOpenOnlyEmpty.tooltip"));
        this.jcbAlwaysOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.jcbAlwaysOpenActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel13.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jcbOpenNothing, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbOpenNothing.text"));
        this.jcbOpenNothing.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbOpenNothing.toolTipText"));
        this.jcbOpenNothing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.jcbOpenNothingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jcbSortEntity, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbSortEntity.text"));
        this.jcbSortEntity.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbSortEntity.toolTipText"));
        this.jSpinner1.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jSpinner1.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel5.text"));
        this.nbBackups.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.nbBackups.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.nbBackups.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel2.text"));
        this.jTextField2.setText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField2.text"));
        this.jTextField2.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField2.toolTipText"));
        this.nbMinAutosave.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.nbMinAutosave.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.nbMinAutosave.toolTipText"));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel6.text"));
        this.jLabel12.setFont(this.jLabel12.getFont().deriveFont(this.jLabel12.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel12.text"));
        this.jTextField4.setText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField4.text"));
        this.jTextField4.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField4.toolTipText"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addGroup(mainPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel14).addComponent(this.jLabel4).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nbBackups).addComponent(this.logLevel, 0, -1, Short.MAX_VALUE).addComponent(this.jSpinner1).addComponent(this.nbMinAutosave, -2, 105, -2))).addComponent(this.jLabel1)).addGap(177, 177, 177)).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jTextField4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4)))).addGroup(mainPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jTextField2).addComponent(this.jLabel5).addComponent(this.jTextField3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3, GroupLayout.Alignment.TRAILING).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING))).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jcbSortEntity).addComponent(this.jcbOpenNothing).addComponent(this.jcbAlwaysOpen)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcbAlwaysOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcbOpenNothing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcbSortEntity).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jButton3)).addGap(18, 18, 18).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jSpinner1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.logLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.nbBackups, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.nbMinAutosave, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jButton4)).addContainerGap()));
        this.jScrollPane1.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1).addGap(0, 0, 0)));
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.chooseFileDir(this.jTextField3, true, false);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.chooseFileDir(this.jTextField2, false, true);
    }

    private void logLevelActionPerformed(ActionEvent evt) {
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.chooseFileDir(this.jTextField4, true, false);
    }

    private void jcbAlwaysOpenActionPerformed(ActionEvent evt) {
        if (this.jcbAlwaysOpen.isSelected()) {
            this.jcbOpenNothing.setSelected(false);
        }
    }

    private void jcbOpenNothingActionPerformed(ActionEvent evt) {
        if (this.jcbOpenNothing.isSelected()) {
            this.jcbAlwaysOpen.setSelected(false);
        }
    }

    void load() {
        Registry gedcomPrefs = Registry.get(GedcomOptions.class);
        this.setGedcomFile(CoreOptions.getInstance().getDefaultGedcom());
        this.jcbOpenNothing.setSelected(CoreOptions.getInstance().getOpenNothingAtStartup());
        this.jcbAlwaysOpen.setSelected(CoreOptions.getInstance().getAlwaysOpenDefault());
        this.jcbSortEntity.setSelected(Options.getSortEntities());
        this.setReportDir(gedcomPrefs.get("reportDir", System.getProperty("user.home")));
        this.jSpinner1.setValue(AppOptions.getMaxLogSizeKB());
        this.setLogLevel(Registry.get(App.class).get("logLevel", "INFO"));
        this.nbBackups.setValue(Options.getNbBackups());
        this.nbMinAutosave.setValue(CoreOptions.getInstance().getMinAutosave());
        this.setBackupDir(Options.getBackupDirectory());
    }

    void store() {
        Registry gedcomPrefs = Registry.get(GedcomOptions.class);
        CoreOptions.getInstance().setDefaultGedcom(this.isDefaultFileValid ? this.getGedcomFile() : null);
        CoreOptions.getInstance().setOpenNothingAtStartup(this.jcbOpenNothing.isSelected());
        CoreOptions.getInstance().setAlwaysOpenDefault(this.jcbAlwaysOpen.isEnabled() && this.jcbAlwaysOpen.isSelected());
        Options.setSortEntities((boolean)this.jcbSortEntity.isSelected());
        gedcomPrefs.put("reportDir", this.isReportDirValid ? this.getReportDir() : "");
        AppOptions.setMaxLogSizeKB(Integer.parseInt(this.jSpinner1.getValue().toString()));
        Registry.get(App.class).put("logLevel", this.getLogLevel());
        Options.setNbBackups((int)Integer.parseInt(this.nbBackups.getValue().toString()));
        CoreOptions.getInstance().setMinAutosave(Integer.parseInt(this.nbMinAutosave.getValue().toString()));
        GedcomDirectory.getDefault().setAutosaveDelay();
        Options.setBackupDirectory((String)(this.isBackupDirValid ? this.getBackupDir() : ""));
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionPanel.saved.statustext"));
    }

    boolean valid() {
        if (!this.oldValueDefaultFile.equals(this.jTextField2.getText())) {
            this.oldValueDefaultFile = this.jTextField2.getText();
            this.isDefaultFileValid = this.isDefaultGedcomFileValid();
            if (!this.isDefaultFileValid) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionPanel.notexist.statustext"));
            }
            this.jcbAlwaysOpen.setEnabled(!this.jTextField2.getText().isEmpty() && this.isDefaultFileValid);
        }
        if (!this.oldValueReportDir.equals(this.jTextField3.getText())) {
            this.oldValueReportDir = this.jTextField3.getText();
            this.isReportDirValid = new File(this.oldValueReportDir).exists();
            if (!this.isReportDirValid) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionPanel.notexistReportDir.statustext"));
            }
        }
        if (!this.oldValueBackupDir.equals(this.jTextField4.getText())) {
            this.oldValueBackupDir = this.jTextField4.getText();
            this.isBackupDirValid = new File(this.oldValueBackupDir).exists();
            if (!this.isBackupDirValid) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionPanel.notexistBackupDir.statustext"));
            }
        }
        return this.isDefaultFileValid && this.isReportDirValid && this.isBackupDirValid;
    }

    void setGedcomFile(URL file) {
        this.jTextField2.setText("");
        try {
            if (file != null && "file".equals(file.getProtocol())) {
                this.jTextField2.setText(new File(file.toURI()).getAbsolutePath());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private boolean isDefaultGedcomFileValid() {
        if (this.jTextField2.getText().trim().isEmpty()) {
            return true;
        }
        Collection actions = Lookup.getDefault().lookupAll(Openable.class);
        for (Openable action : actions) {
            ActionOpenDefault a;
            if (!(action instanceof ActionOpenDefault) || (a = (ActionOpenDefault)action).getValidFile(URLUtil.toURL(this.jTextField2.getText())) == null) continue;
            return true;
        }
        return false;
    }

    private URL getGedcomFile() {
        if (this.jTextField2.getText().trim().isEmpty()) {
            return null;
        }
        return URLUtil.toURL(this.jTextField2.getText());
    }

    void setReportDir(String str) {
        if (((String)str).equals("")) {
            str = System.getProperty("user.home") + File.separator + "report";
        }
        this.jTextField3.setText((String)str);
    }

    String getReportDir() {
        return this.jTextField3.getText();
    }

    void setBackupDir(String str) {
        this.jTextField4.setText(str);
    }

    String getBackupDir() {
        return this.jTextField4.getText();
    }

    String getAssoCommand(String str) {
        String command = "";
        int i = str.lastIndexOf("*");
        command = i < 0 ? str : (i + 1 == str.length() || str.equals("") ? "" : str.substring(i + 1, str.length()));
        return command;
    }

    String getLogLevel() {
        return this.logLevel.getSelectedItem().toString();
    }

    void setLogLevel(String str) {
        this.logLevel.setSelectedItem(str);
    }
}

