/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.core.pluginservice.AncestrisPlugin;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.util.Registry;
import genj.util.Validator;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ErrorPanel
extends JPanel {
    private final Registry registry = Registry.get(this.getClass());
    final List<ViewContext> errors = new ArrayList<ViewContext>();
    final ErrorListModel model = new ErrorListModel();
    private JList<ViewContext> errorsList;
    private JScrollPane jScrollPane;
    private JButton paramButton;
    private JLabel paramLabel;

    public ErrorPanel() {
        this.initComponents();
        this.errorsList.setCellRenderer(new ListRenderer());
        int maxWidth = this.registry.get("errorWindowWidth", this.getPreferredSize().width);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (ViewContext error : this.errors) {
            maxWidth = Math.max(maxWidth, fm.stringWidth(error.getText()) + 70);
        }
        this.setPreferredSize(new Dimension(maxWidth, this.registry.get("errorWindowHeight", this.getPreferredSize().height)));
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.errorsList = new JList();
        this.paramLabel = new JLabel();
        this.paramButton = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ErrorPanel.this.formComponentResized(evt);
            }
        });
        this.errorsList.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.errorsList.setModel(this.model);
        this.errorsList.setSelectionMode(0);
        this.errorsList.setFixedCellHeight(20);
        this.errorsList.setVisibleRowCount(12);
        this.jScrollPane.setViewportView(this.errorsList);
        Mnemonics.setLocalizedText((JLabel)this.paramLabel, (String)NbBundle.getMessage(ErrorPanel.class, (String)"ErrorPanel.paramLabel.text"));
        this.paramButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/app/parameters.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.paramButton, (String)NbBundle.getMessage(ErrorPanel.class, (String)"ErrorPanel.paramButton.text"));
        this.paramButton.setPreferredSize(new Dimension(24, 24));
        this.paramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.paramButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, -1, 481, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.paramButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paramLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 170, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.paramLabel).addComponent(this.paramButton, -2, -1, -2)).addContainerGap()));
    }

    private void paramButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Extensions/GedcomValidateOptions");
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("errorWindowWidth", evt.getComponent().getWidth());
        this.registry.put("errorWindowHeight", evt.getComponent().getHeight());
    }

    public boolean setErrors(Entity e) {
        Validator validator = null;
        Collection plugins = Lookup.getDefault().lookupAll(AncestrisPlugin.class);
        for (AncestrisPlugin plugin : plugins) {
            if (!plugin.getPluginName().equals("modules.gedcom.gedcomvalidate")) continue;
            validator = (Validator)plugin;
            break;
        }
        this.paramLabel.setVisible(validator != null);
        this.paramButton.setVisible(validator != null);
        if (validator != null) {
            List newErrors = validator.start(e);
            if (newErrors != null) {
                this.addErrors(e, newErrors);
            }
            if (e instanceof Indi) {
                Indi i = (Indi)e;
                newErrors = validator.start((Entity)i.getFamilyWhereBiologicalChild());
                if (newErrors != null) {
                    this.addErrors(e, newErrors);
                }
                for (Fam fam : i.getFamiliesWhereSpouse()) {
                    newErrors = validator.start((Entity)fam);
                    if (newErrors == null) continue;
                    this.addErrors(e, newErrors);
                }
            }
        }
        return !this.errors.isEmpty();
    }

    public void addErrors(Entity e, List<ViewContext> newErrors) {
        for (ViewContext error : newErrors) {
            if (!error.getEntity().equals(e)) continue;
            this.errors.add(error);
        }
        this.model.setLines();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String getMessage(Entity e) {
        return NbBundle.getMessage(this.getClass(), (String)"TITL_WARNING_Control", (Object)e.toString());
    }

    private class ErrorListModel
    extends AbstractListModel<ViewContext> {
        ViewContext[] lines;

        public ErrorListModel() {
            this.lines = (ViewContext[])ErrorPanel.this.errors.toArray(ViewContext[]::new);
        }

        public void setLines() {
            this.lines = (ViewContext[])ErrorPanel.this.errors.toArray(ViewContext[]::new);
        }

        @Override
        public int getSize() {
            return this.lines.length;
        }

        @Override
        public ViewContext getElementAt(int i) {
            return this.lines[i];
        }
    }

    private class ListRenderer
    extends JLabel
    implements ListCellRenderer<ViewContext> {
        private Color backSelectedColor = null;
        private Color foreSelectedColor = null;

        public ListRenderer() {
            Color c = new JList().getSelectionBackground();
            this.backSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            c = new JList().getSelectionForeground();
            this.foreSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ViewContext> list, ViewContext value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setIconTextGap(8);
                this.setIcon((Icon)value.getImage());
                this.setText(value.getText());
                if (isSelected) {
                    this.setBackground(this.backSelectedColor);
                    this.setForeground(this.foreSelectedColor);
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setOpaque(true);
            }
            return this;
        }
    }
}

