/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.util;

import java.util.HashMap;
import java.util.Map;

public class DisjointSets<E> {
    protected Map<E, Node> map;

    public DisjointSets() {
        this.map = new HashMap<E, Node>();
    }

    public DisjointSets(int initialCapacity) {
        this.map = new HashMap<E, Node>(4 * initialCapacity / 3 + 1);
    }

    public boolean add(E e) {
        Node x = this.map.get(e);
        if (x != null) {
            return false;
        }
        this.map.put(e, new Node());
        return true;
    }

    public boolean inSameSet(Object e1, Object e2) {
        Node x1 = this.map.get(e1);
        if (x1 == null) {
            return false;
        }
        Node x2 = this.map.get(e2);
        if (x2 == null) {
            return false;
        }
        return x1.root() == x2.root();
    }

    public boolean union(Object e1, Object e2) {
        Node x1 = this.map.get(e1);
        if (x1 == null) {
            return false;
        }
        Node x2 = this.map.get(e2);
        if (x2 == null) {
            return false;
        }
        return x1.join(x2);
    }

    public boolean contains(Object e) {
        return this.map.get(e) != null;
    }

    public void clear() {
        this.map.values().forEach(node -> {
            node.parent = null;
        });
        this.map.clear();
    }

    protected static class Node {
        Node parent = this;
        int rank = 0;

        protected Node() {
        }

        protected Node root() {
            if (this != this.parent) {
                this.parent = this.parent.root();
            }
            return this.parent;
        }

        protected boolean join(Node node) {
            Node y;
            Node x = this.root();
            if (x == (y = node.root())) {
                return false;
            }
            if (x.rank > y.rank) {
                y.parent = x;
            } else {
                x.parent = y;
                if (x.rank == y.rank) {
                    ++y.rank;
                }
            }
            return true;
        }
    }
}

