/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class TopologicalSortDFS
implements Algorithm {
    private Graph graph;
    private List<Node> sortedNodes;
    private HashSet<Node> markedNodeList;
    private HashSet<Node> tempMarkedNodeList;

    @Override
    public void init(Graph theGraph) {
        this.graph = theGraph;
        this.sortedNodes = new ArrayList<Node>();
        this.markedNodeList = new HashSet();
        this.tempMarkedNodeList = new HashSet();
    }

    @Override
    public void compute() {
        while ((long)this.markedNodeList.size() != this.graph.nodes().count()) {
            this.graph.nodes().forEach(this::visit);
        }
        Collections.reverse(this.sortedNodes);
    }

    private void visit(Node theNode) {
        if (this.markedNodeList.contains(theNode)) {
            return;
        }
        if (this.tempMarkedNodeList.contains(theNode)) {
            this.throwException();
        }
        this.tempMarkedNodeList.add(theNode);
        theNode.leavingEdges().forEach(anEdge -> this.visit(anEdge.getTargetNode()));
        this.markedNodeList.add(theNode);
        this.sortedNodes.add(theNode);
    }

    private void throwException() {
        throw new IllegalStateException("graph is no DAG");
    }

    public List<Node> getSortedNodes() {
        return this.sortedNodes;
    }

    @Result
    public String defaultResult() {
        return this.getSortedNodes().toString();
    }
}

