/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Stream;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Structure;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

public class ConnectedComponents
extends SinkAdapter
implements DynamicAlgorithm,
Iterable<ConnectedComponent> {
    protected HashSet<ConnectedComponent> components;
    protected HashMap<Node, ConnectedComponent> componentsMap;
    protected Graph graph;
    protected String countAttribute;
    protected String cutAttribute;
    protected boolean started = false;
    protected int currentComponentId;

    public ConnectedComponents() {
    }

    public ConnectedComponents(Graph graph) {
        this();
        if (graph != null) {
            this.init(graph);
        }
    }

    @Override
    public void init(Graph graph) {
        if (this.graph != null) {
            this.graph.removeSink((Sink)this);
        }
        this.graph = graph;
        this.graph.addSink((Sink)this);
        this.components = new HashSet();
        this.componentsMap = new HashMap();
    }

    @Override
    public void compute() {
        this.started = true;
        this.components.clear();
        this.componentsMap.clear();
        this.graph.nodes().filter(n -> !this.componentsMap.containsKey(n)).forEach(n -> {
            ConnectedComponent cc = new ConnectedComponent();
            this.computeConnectedComponent(cc, (Node)n, null);
            this.components.add(cc);
        });
    }

    protected void computeConnectedComponent(ConnectedComponent cc, Node from, Edge drop) {
        LinkedList<Node> open = new LinkedList<Node>();
        open.add(from);
        cc.registerNode(from);
        while (!open.isEmpty()) {
            Node n = (Node)open.poll();
            n.edges().filter(e -> e != drop && !this.isCutEdge((Edge)e)).forEach(e -> {
                Node n2 = e.getOpposite(n);
                if (this.componentsMap.get(n2) != cc) {
                    open.add(n2);
                    cc.registerNode(n2);
                }
            });
        }
    }

    @Override
    public void terminate() {
        if (this.graph != null) {
            this.graph.removeSink((Sink)this);
            this.graph = null;
            this.started = false;
            this.components.clear();
            this.componentsMap.clear();
        }
    }

    @Override
    public Iterator<ConnectedComponent> iterator() {
        return this.components.iterator();
    }

    public void publish(String nodeAttribute) {
        if (this.graph == null) {
            return;
        }
        this.graph.nodes().forEach(n -> {
            ConnectedComponent cc = this.componentsMap.get(n);
            assert (cc != null);
            n.setAttribute(this.countAttribute, new Object[]{cc.id});
        });
    }

    public ConnectedComponent getGiantComponent() {
        this.checkStarted();
        ConnectedComponent maxCC = null;
        maxCC = (ConnectedComponent)this.components.stream().max((cc1, cc2) -> Integer.compare(cc1.size, cc2.size)).get();
        return maxCC;
    }

    public int getConnectedComponentsCount() {
        this.checkStarted();
        return this.components.size();
    }

    @Result
    public String defaultResult() {
        return this.getConnectedComponentsCount() + " connected component(s) in this graph";
    }

    public int getConnectedComponentsCount(int sizeThreshold) {
        return this.getConnectedComponentsCount(sizeThreshold, 0);
    }

    public int getConnectedComponentsCount(int sizeThreshold, int sizeCeiling) {
        this.checkStarted();
        if (sizeThreshold <= 1 && sizeCeiling <= 0) {
            return this.components.size();
        }
        int count = 0;
        count = (int)this.components.stream().filter(cc -> cc.size >= sizeThreshold && (sizeCeiling <= 0 || cc.size < sizeCeiling)).count();
        return count;
    }

    public ConnectedComponent getConnectedComponentOf(Node n) {
        return n == null ? null : this.componentsMap.get(n);
    }

    public ConnectedComponent getConnectedComponentOf(String nodeId) {
        return this.getConnectedComponentOf(this.graph.getNode(nodeId));
    }

    public ConnectedComponent getConnectedComponentOf(int nodeIndex) {
        return this.getConnectedComponentOf(this.graph.getNode(nodeIndex));
    }

    @Parameter
    public void setCutAttribute(String cutAttribute) {
        this.cutAttribute = cutAttribute;
        if (this.graph != null) {
            this.compute();
        }
    }

    @Parameter
    public void setCountAttribute(String countAttribute) {
        if (this.countAttribute != null && this.graph != null) {
            this.graph.nodes().forEach(n -> n.removeAttribute(countAttribute));
        }
        this.countAttribute = countAttribute;
        this.publish(countAttribute);
    }

    protected boolean isCutEdge(Edge e) {
        return this.cutAttribute != null && e.hasAttribute(this.cutAttribute);
    }

    protected void checkStarted() {
        if (!this.started && this.graph != null) {
            this.compute();
        }
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        Edge edge;
        if (!this.started && this.graph != null) {
            this.compute();
        } else if (this.started && (edge = this.graph.getEdge(edgeId)) != null) {
            ConnectedComponent cc1;
            Node n0 = edge.getNode0();
            Node n1 = edge.getNode1();
            ConnectedComponent cc0 = this.componentsMap.get(n0);
            if (cc0 != (cc1 = this.componentsMap.get(n1))) {
                this.computeConnectedComponent(cc0, n1, null);
                assert (cc1.size == 0);
            }
        }
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        Edge edge;
        this.checkStarted();
        if (this.started && (edge = this.graph.getEdge(edgeId)) != null) {
            ConnectedComponent cc1;
            Node n0 = edge.getNode0();
            Node n1 = edge.getNode1();
            ConnectedComponent cc0 = this.componentsMap.get(n0);
            if (cc0 == (cc1 = this.componentsMap.get(n1))) {
                ConnectedComponent ccN = new ConnectedComponent();
                this.computeConnectedComponent(ccN, n1, edge);
                this.components.add(ccN);
            }
        }
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        Node node;
        if (!this.started && this.graph != null) {
            this.compute();
        } else if (this.started && (node = this.graph.getNode(nodeId)) != null) {
            ConnectedComponent ccN = new ConnectedComponent();
            this.computeConnectedComponent(ccN, node, null);
            this.components.add(ccN);
        }
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        ConnectedComponent cc;
        Node node;
        this.checkStarted();
        if (this.started && (node = this.graph.getNode(nodeId)) != null && (cc = this.componentsMap.remove(node)) != null) {
            cc.unregisterNode(node);
        }
    }

    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        if (this.cutAttribute != null && attribute.equals(this.cutAttribute)) {
            Edge edge;
            if (!this.started && this.graph != null) {
                this.compute();
            }
            if ((edge = this.graph.getEdge(edgeId)) != null) {
                ConnectedComponent cc1;
                Node n0 = edge.getNode0();
                Node n1 = edge.getNode1();
                ConnectedComponent cc0 = this.componentsMap.get(n0);
                if (cc0 == (cc1 = this.componentsMap.get(n1))) {
                    ConnectedComponent ccN = new ConnectedComponent();
                    this.computeConnectedComponent(ccN, n1, edge);
                    this.components.add(ccN);
                }
            }
        }
    }

    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
        if (this.cutAttribute != null && attribute.equals(this.cutAttribute)) {
            Edge edge;
            if (!this.started && this.graph != null) {
                this.compute();
            }
            if ((edge = this.graph.getEdge(edgeId)) != null) {
                ConnectedComponent cc1;
                Node n0 = edge.getNode0();
                Node n1 = edge.getNode1();
                ConnectedComponent cc0 = this.componentsMap.get(n0);
                if (cc0 != (cc1 = this.componentsMap.get(n1))) {
                    this.computeConnectedComponent(cc0, n1, null);
                    assert (cc1.size == 0);
                }
            }
        }
    }

    public void graphCleared(String graphId, long timeId) {
        if (this.started) {
            this.components.clear();
            this.componentsMap.clear();
        }
    }

    public class ConnectedComponent
    implements Structure {
        public final int id;
        int size;

        ConnectedComponent() {
            this.id = ConnectedComponents.this.currentComponentId++;
            this.size = 0;
        }

        void registerNode(Node n) {
            ConnectedComponent old = ConnectedComponents.this.componentsMap.put(n, this);
            if (ConnectedComponents.this.countAttribute != null) {
                n.setAttribute(ConnectedComponents.this.countAttribute, new Object[]{this.id});
            }
            if (old != this) {
                ++this.size;
                if (old != null) {
                    old.unregisterNode(n);
                }
            }
        }

        void unregisterNode(Node n) {
            --this.size;
            if (this.size == 0) {
                ConnectedComponents.this.components.remove(this);
            }
        }

        public Stream<Node> nodes() {
            return ConnectedComponents.this.graph.nodes().filter(n -> ConnectedComponents.this.componentsMap.get(n) == this);
        }

        public Set<Node> getNodeSet() {
            HashSet<Node> nodes = new HashSet<Node>();
            this.nodes().forEach(n -> nodes.add((Node)n));
            return nodes;
        }

        public Stream<Edge> edges() {
            return ConnectedComponents.this.graph.edges().filter(e -> ConnectedComponents.this.componentsMap.get(e.getNode0()) == this && ConnectedComponents.this.componentsMap.get(e.getNode1()) == this && !ConnectedComponents.this.isCutEdge((Edge)e));
        }

        public boolean contains(Node n) {
            return ConnectedComponents.this.componentsMap.get(n) == this;
        }

        public String toString() {
            return String.format("ConnectedComponent#%d", this.id);
        }

        public int getNodeCount() {
            return (int)this.nodes().count();
        }

        public int getEdgeCount() {
            return (int)this.edges().count();
        }
    }
}

