/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.HashMap;
import java.util.HashSet;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.measure.CommunityMeasure;
import org.graphstream.graph.Node;

public abstract class CommunityRelativeMeasure
extends CommunityMeasure {
    protected String referenceMarker;
    protected HashMap<Object, HashSet<Node>> referenceCommunities;

    public CommunityRelativeMeasure(String marker) {
        super(marker);
        this.referenceMarker = "label";
    }

    public CommunityRelativeMeasure(String marker, String referenceMarker) {
        super(marker);
        this.referenceMarker = referenceMarker;
    }

    @Override
    public abstract void compute();

    @Override
    protected void initialize() {
        super.initialize();
        this.referenceCommunities = Toolkit.communities(this.graph, this.referenceMarker);
    }

    @Override
    public void nodeAdded(String graphId, long timeId, String nodeId) {
        super.nodeAdded(graphId, timeId, nodeId);
        Node n = this.graph.getNode(nodeId);
        this.assignNode(nodeId, n.getAttribute(this.referenceMarker), this.referenceCommunities);
    }

    @Override
    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        super.nodeRemoved(graphId, timeId, nodeId);
        Node n = this.graph.getNode(nodeId);
        this.unassignNode(nodeId, n.getAttribute(this.referenceMarker), this.referenceCommunities);
    }

    @Override
    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        super.nodeAttributeChanged(graphId, timeId, nodeId, attribute, oldValue, newValue);
        if (attribute.equals(this.referenceMarker) && oldValue != newValue) {
            this.unassignNode(nodeId, oldValue, this.referenceCommunities);
            this.assignNode(nodeId, newValue, this.referenceCommunities);
        }
    }
}

