/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.panels;

import ancestris.modules.editors.aries.models.SourceCitationsTableModel;
import ancestris.modules.editors.aries.panels.SourceCitationEditorPanel;
import ancestris.modules.editors.aries.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SourceCitationsTablePanel
extends JPanel {
    private Property mRoot;
    private Source mSource;
    private PropertySource mSourceCitation;
    private final SourceCitationsTableModel mSourceCitationsTableModel = new SourceCitationsTableModel();
    private final ChangeSupport changeSupport = new ChangeSupport(SourceCitationsTablePanel.class);
    private JButton addSourceCitationButton;
    private JButton deleteSourceCitationButton;
    private JButton editSourceCitationButton;
    private EditorTable sourceCitationsTable;
    private JScrollPane sourceCitationsTableScrollPane;
    private JToolBar sourcesToolBar;

    public SourceCitationsTablePanel() {
        this.initComponents();
        this.sourceCitationsTable.setID(SourceCitationsTablePanel.class.getName());
    }

    private void initComponents() {
        this.sourcesToolBar = new JToolBar();
        this.addSourceCitationButton = new JButton();
        this.editSourceCitationButton = new JButton();
        this.deleteSourceCitationButton = new JButton();
        this.sourceCitationsTableScrollPane = new JScrollPane();
        this.sourceCitationsTable = new EditorTable();
        this.setMinimumSize(new Dimension(453, 57));
        this.setName("");
        this.sourcesToolBar.setFloatable(false);
        this.sourcesToolBar.setRollover(true);
        this.addSourceCitationButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit_add.png")));
        this.addSourceCitationButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/panels/Bundle").getString("SourceCitationsTablePanel.addSourceCitationButton.toolTipText"), new Object[0]));
        this.addSourceCitationButton.setHorizontalTextPosition(0);
        this.addSourceCitationButton.setVerticalTextPosition(3);
        this.addSourceCitationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationsTablePanel.this.addSourceCitationButtonActionPerformed(evt);
            }
        });
        this.sourcesToolBar.add(this.addSourceCitationButton);
        this.editSourceCitationButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit.png")));
        this.editSourceCitationButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/panels/Bundle").getString("SourceCitationsTablePanel.editSourceCitationButton.toolTipText"), new Object[0]));
        this.editSourceCitationButton.setHorizontalTextPosition(0);
        this.editSourceCitationButton.setVerticalTextPosition(3);
        this.editSourceCitationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationsTablePanel.this.editSourceCitationButtonActionPerformed(evt);
            }
        });
        this.sourcesToolBar.add(this.editSourceCitationButton);
        this.deleteSourceCitationButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit_delete.png")));
        this.deleteSourceCitationButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/panels/Bundle").getString("SourceCitationsTablePanel.deleteSourceCitationButton.toolTipText"), new Object[0]));
        this.deleteSourceCitationButton.setHorizontalTextPosition(0);
        this.deleteSourceCitationButton.setVerticalTextPosition(3);
        this.deleteSourceCitationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationsTablePanel.this.deleteSourceCitationButtonActionPerformed(evt);
            }
        });
        this.sourcesToolBar.add(this.deleteSourceCitationButton);
        this.sourceCitationsTable.setModel(this.mSourceCitationsTableModel);
        this.sourceCitationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SourceCitationsTablePanel.this.sourceCitationsTableMouseClicked(evt);
            }
        });
        this.sourceCitationsTableScrollPane.setViewportView(this.sourceCitationsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourcesToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.sourceCitationsTableScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sourcesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceCitationsTableScrollPane, -2, 26, Short.MAX_VALUE)));
    }

    private void addSourceCitationButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(gedcom1 -> {
                this.mSource = (Source)gedcom1.createEntity("SOUR");
                this.mSourceCitation = (PropertySource)this.mRoot.addProperty("SOUR", "@" + this.mSource.getId() + "@");
                this.mSourceCitation.link();
            });
            SourceCitationEditorPanel sourceCitationEditor = new SourceCitationEditorPanel();
            DialogManager.ADialog sourceCitationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.create.title", (Object)Gedcom.getName((String)this.mRoot.getTag()), (Object)this.mRoot.getEntity()), (JComponent)sourceCitationEditor);
            sourceCitationEditorDialog.setDialogId(SourceCitationsTablePanel.class.getName());
            sourceCitationEditor.set(this.mRoot, (Property)this.mSourceCitation);
            if (sourceCitationEditorDialog.show() == DialogDescriptor.OK_OPTION && this.mSourceCitation.isValid()) {
                try {
                    gedcom.doUnitOfWork(gedcom1 -> {
                        sourceCitationEditor.commit();
                        if (this.mSource != this.mSourceCitation.getTargetEntity().get()) {
                            gedcom1.deleteEntity((Entity)this.mSource);
                        }
                    });
                    if (this.mSourceCitationsTableModel.indexOf(this.mSourceCitation) == -1) {
                        this.mSourceCitationsTableModel.add((Property)this.mSourceCitation);
                    }
                    int row = this.mSourceCitationsTableModel.indexOf(this.mSourceCitation);
                    this.sourceCitationsTable.setRowSelectionInterval(row, row);
                    this.editSourceCitationButton.setEnabled(true);
                    this.deleteSourceCitationButton.setEnabled(true);
                    this.changeSupport.fireChange();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editSourceCitationButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.sourceCitationsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.sourceCitationsTable.convertRowIndexToModel(selectedRow);
            Gedcom gedcom = this.mRoot.getGedcom();
            int undoNb = gedcom.getUndoNb();
            SourceCitationEditorPanel sourceCitationEditor = new SourceCitationEditorPanel();
            DialogManager.ADialog sourceCitationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.edit.title", (Object)Gedcom.getName((String)this.mRoot.getTag()), (Object)this.mRoot.getEntity()), (JComponent)sourceCitationEditor);
            sourceCitationEditorDialog.setDialogId(SourceCitationsTablePanel.class.getName());
            sourceCitationEditor.set(this.mRoot, this.mSourceCitationsTableModel.getValueAt(rowIndex));
            if (sourceCitationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(gedcom1 -> sourceCitationEditor.commit());
                    this.changeSupport.fireChange();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
    }

    private void deleteSourceCitationButtonActionPerformed(ActionEvent evt) {
        DialogManager createYesNo;
        int selectedRow = this.sourceCitationsTable.getSelectedRow();
        if (selectedRow != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(SourceCitationsTablePanel.class, (String)"SourceCitationsTableDialog.deleteSourceCitation.title"), (String)NbBundle.getMessage(SourceCitationsTablePanel.class, (String)"SourceCitationsTableDialog.deleteSourceCitation.text", (Object)this.mRoot, (Object)this.mRoot.getEntity()))).show() == DialogManager.YES_OPTION) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(gedcom -> this.mRoot.delProperty(this.mSourceCitationsTableModel.remove(this.sourceCitationsTable.convertRowIndexToModel(selectedRow))));
                if (this.mSourceCitationsTableModel.getRowCount() <= 0) {
                    this.editSourceCitationButton.setEnabled(false);
                    this.deleteSourceCitationButton.setEnabled(false);
                }
                this.changeSupport.fireChange();
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void sourceCitationsTableMouseClicked(MouseEvent evt) {
        int selectedRow;
        if (evt.getClickCount() >= 2 && (selectedRow = this.sourceCitationsTable.getSelectedRow()) != -1) {
            int rowIndex = this.sourceCitationsTable.convertRowIndexToModel(selectedRow);
            Gedcom gedcom = this.mRoot.getGedcom();
            int undoNb = gedcom.getUndoNb();
            SourceCitationEditorPanel sourceCitationEditor = new SourceCitationEditorPanel();
            DialogManager.ADialog sourceCitationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.edit.title", (Object)Gedcom.getName((String)this.mRoot.getTag()), (Object)this.mRoot.getEntity()), (JComponent)sourceCitationEditor);
            sourceCitationEditor.set(this.mRoot, this.mSourceCitationsTableModel.getValueAt(rowIndex));
            if (sourceCitationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(gedcom1 -> sourceCitationEditor.commit());
                    this.changeSupport.fireChange();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
    }

    public void set(Property root, List<Property> sourcesList) {
        this.mRoot = root;
        this.mSourceCitationsTableModel.clear();
        this.mSourceCitationsTableModel.addAll(sourcesList);
        if (this.mSourceCitationsTableModel.getRowCount() > 0) {
            this.editSourceCitationButton.setEnabled(true);
            this.deleteSourceCitationButton.setEnabled(true);
        } else {
            this.editSourceCitationButton.setEnabled(false);
            this.deleteSourceCitationButton.setEnabled(false);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }
}

