/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.utilities.EntityTag2Name;
import genj.gedcom.Entity;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class ReferencesTableModel
extends AbstractTableModel {
    List<Entity> entitiesList = new ArrayList<Entity>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(ReferencesTableModel.class, (String)"ReferencesTableModel.column.ID.title"), NbBundle.getMessage(ReferencesTableModel.class, (String)"ReferencesTableModel.column.Type.title"), NbBundle.getMessage(ReferencesTableModel.class, (String)"ReferencesTableModel.column.Value.title")};

    @Override
    public int getRowCount() {
        return this.entitiesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.entitiesList.size()) {
            Entity entity = this.entitiesList.get(row);
            switch (column) {
                case 0: {
                    return entity.getId();
                }
                case 1: {
                    return EntityTag2Name.getTagName(entity.getTag());
                }
            }
            return entity.toString(false);
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(Entity entity) {
        this.entitiesList.add(entity);
        this.fireTableDataChanged();
    }

    public void addAll(List<Entity> entitiesList) {
        this.entitiesList.addAll(entitiesList);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.entitiesList.clear();
    }

    public Entity getValueAt(int row) {
        if (row < this.entitiesList.size()) {
            return this.entitiesList.get(row);
        }
        return null;
    }
}

