/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.actions;

import ancestris.modules.editors.aries.AriesTopComponent;
import ancestris.modules.editors.aries.editors.IndividualEditor;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class AriesCreateIndividualAction
implements ActionListener {
    private final DataObject context;
    Entity entity;

    public AriesCreateIndividualAction(DataObject context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Context gedcomContext = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (gedcomContext != null) {
            Gedcom gedcom = gedcomContext.getGedcom();
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            if (atc == null) {
                AncestrisTopComponent win = new AriesTopComponent().create(gedcomContext);
                win.open();
                win.requestActive();
            }
            try {
                gedcom.doUnitOfWork(gedcom1 -> {
                    this.entity = gedcom1.createEntity("INDI");
                    this.entity.addProperty("NAME", "");
                });
                IndividualEditor individualEditor = new IndividualEditor(true);
                individualEditor.setContext(new Context(this.entity));
                if (!individualEditor.showPanel()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

