/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.text;

import java.util.MissingResourceException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;

public final class AskEditorQuestions {
    private AskEditorQuestions() {
    }

    public static QuestionResult askUserQuestion(UserQuestionException uqe) {
        String key = "UserQuestionAnswer_" + uqe.getClass().getName();
        try {
            String ask = NbBundle.getMessage(AskEditorQuestions.class, (String)key);
            if ("yes".equals(ask)) {
                return QuestionResult.YES;
            }
            if ("no".equals(ask)) {
                return QuestionResult.NO;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return QuestionResult.ASK_USER;
    }

    public static boolean askReloadDocument(String localizedMessage) {
        String ask = NbBundle.getMessage(AskEditorQuestions.class, (String)"ASK_OnReload");
        if ("yes".equals(ask)) {
            return true;
        }
        if ("no".equals(ask)) {
            return false;
        }
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)localizedMessage, 0);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        return NotifyDescriptor.OK_OPTION.equals(res);
    }

    public static enum QuestionResult {
        ASK_USER,
        YES,
        NO;

    }
}

