/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;

public class BeanGroup {
    private static final HashMap<AbstractRecord.RecordType, BeanGroup[]> groupMap = new HashMap(4);
    GroupId groupId;
    private final String title;
    private boolean visible;
    private ArrayList<BeanField> fields = null;

    public static void initGroup(GroupId id, String birthTitle, String marriageTitle, String deathTitle, String miscTitle) {
        BeanGroup group;
        String title = "";
        if (birthTitle != null && !birthTitle.isEmpty()) {
            title = ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.row." + birthTitle);
        }
        BeanGroup.groupMap.get((Object)((Object)AbstractRecord.RecordType.BIRTH))[id.ordinal()] = group = new BeanGroup(id, title);
        title = marriageTitle != null && !marriageTitle.isEmpty() ? ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.row." + marriageTitle) : "";
        BeanGroup.groupMap.get((Object)((Object)AbstractRecord.RecordType.MARRIAGE))[id.ordinal()] = group = new BeanGroup(id, title);
        title = deathTitle != null && !deathTitle.isEmpty() ? ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.row." + deathTitle) : "";
        BeanGroup.groupMap.get((Object)((Object)AbstractRecord.RecordType.DEATH))[id.ordinal()] = group = new BeanGroup(id, title);
        title = miscTitle != null && !miscTitle.isEmpty() ? ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.row." + miscTitle) : "";
        BeanGroup.groupMap.get((Object)((Object)AbstractRecord.RecordType.MISC))[id.ordinal()] = group = new BeanGroup(id, title);
    }

    public static void initGroupField(GroupId groupId, AbstractRecord.FieldType fieldType, boolean birthUse, boolean marriageUse, boolean deathUse, boolean miscUse) {
        if (birthUse) {
            BeanGroup.addField(AbstractRecord.RecordType.BIRTH, groupId, fieldType, birthUse);
        }
        if (marriageUse) {
            BeanGroup.addField(AbstractRecord.RecordType.MARRIAGE, groupId, fieldType, marriageUse);
        }
        if (deathUse) {
            BeanGroup.addField(AbstractRecord.RecordType.DEATH, groupId, fieldType, deathUse);
        }
        if (miscUse) {
            BeanGroup.addField(AbstractRecord.RecordType.MISC, groupId, fieldType, miscUse);
        }
    }

    public static void addField(AbstractRecord.RecordType recordType, GroupId groupId, AbstractRecord.FieldType fieldType, boolean use) {
        BeanGroup group = groupMap.get((Object)recordType)[groupId.ordinal()];
        group.fields.add(new BeanField(fieldType, true));
        group.visible = false;
        Iterator<BeanField> fieldIter = group.fields.iterator();
        while (fieldIter.hasNext() && !group.visible) {
            group.visible |= fieldIter.next().isVisible();
        }
    }

    public static BeanGroup[] getGroups(AbstractRecord.RecordType recordType) {
        return groupMap.get((Object)recordType);
    }

    public static BeanGroup getGroup(AbstractRecord.RecordType recordType, AbstractRecord.FieldType fieldType) {
        for (BeanGroup beanGroup : groupMap.get((Object)recordType)) {
            for (BeanField beanField : beanGroup.getFields()) {
                if (beanField.getFieldType() != fieldType) continue;
                return beanGroup;
            }
        }
        return null;
    }

    public BeanGroup(GroupId groupId, String title) {
        this.groupId = groupId;
        this.title = title;
        this.visible = false;
        this.fields = new ArrayList();
    }

    public GroupId getId() {
        return this.groupId;
    }

    public String getTitle() {
        return this.title;
    }

    public Collection<BeanField> getFields() {
        return this.fields;
    }

    public boolean isVisible() {
        return this.visible;
    }

    static {
        groupMap.put(AbstractRecord.RecordType.BIRTH, new BeanGroup[14]);
        groupMap.put(AbstractRecord.RecordType.MARRIAGE, new BeanGroup[14]);
        groupMap.put(AbstractRecord.RecordType.DEATH, new BeanGroup[14]);
        groupMap.put(AbstractRecord.RecordType.MISC, new BeanGroup[14]);
        BeanGroup.initGroup(GroupId.general, "Birth", "Marriage", "Death", "Misc");
        BeanGroup.initGroup(GroupId.indi, "Child", "Husband", "Deceased", "Participant1");
        BeanGroup.initGroup(GroupId.indiMarried, "Married", "ExWife", "Married", "Married");
        BeanGroup.initGroup(GroupId.indiFather, "Father", "IndiFather", "Father", "Father");
        BeanGroup.initGroup(GroupId.indiMother, "Mother", "IndiMother", "Mother", "Mother");
        BeanGroup.initGroup(GroupId.wife, "Wife", "Wife", "Wife", "Participant2");
        BeanGroup.initGroup(GroupId.wifeMarried, "Married", "ExHusband", "", "Married");
        BeanGroup.initGroup(GroupId.wifeFather, "WifeFather", "WifeFather", "Father", "Father");
        BeanGroup.initGroup(GroupId.wifeMother, "WifeMother", "WifeMother", "Mother", "Mother");
        BeanGroup.initGroup(GroupId.witness1, "GodFather", "Witness1", "Witness1", "Witness1");
        BeanGroup.initGroup(GroupId.witness2, "GodMother", "Witness2", "Witness2", "Witness2");
        BeanGroup.initGroup(GroupId.witness3, "Witness3", "Witness3", "Witness3", "Witness3");
        BeanGroup.initGroup(GroupId.witness4, "Witness4", "Witness4", "Witness4", "Witness4");
        BeanGroup.initGroup(GroupId.generalComment, "GeneralComment", "GeneralComment", "GeneralComment", "GeneralComment");
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.eventTag, false, false, false, true);
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.eventType, false, false, false, true);
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.secondDate, false, false, false, true);
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.eventDate, true, true, true, true);
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.parish, true, true, true, true);
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.notary, false, false, false, true);
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.cote, true, true, true, true);
        BeanGroup.initGroupField(GroupId.general, AbstractRecord.FieldType.freeComment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiLastName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiFirstName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiSex, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiAge, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiBirthDate, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiBirthPlace, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiBirthAddress, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiOccupation, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiResidence, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiAddress, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiDeathDate, false, false, true, false);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiDeathPlace, false, false, true, false);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiDeathAddress, false, false, true, false);
        BeanGroup.initGroupField(GroupId.indi, AbstractRecord.FieldType.indiComment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMarried, AbstractRecord.FieldType.indiMarriedLastName, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMarried, AbstractRecord.FieldType.indiMarriedFirstName, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMarried, AbstractRecord.FieldType.indiMarriedDead, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMarried, AbstractRecord.FieldType.indiMarriedOccupation, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMarried, AbstractRecord.FieldType.indiMarriedResidence, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMarried, AbstractRecord.FieldType.indiMarriedAddress, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMarried, AbstractRecord.FieldType.indiMarriedComment, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherLastName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherFirstName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherAge, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherDead, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherOccupation, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherResidence, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherAddress, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiFather, AbstractRecord.FieldType.indiFatherComment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherLastName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherFirstName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherAge, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherDead, false, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherOccupation, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherResidence, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherAddress, true, true, true, true);
        BeanGroup.initGroupField(GroupId.indiMother, AbstractRecord.FieldType.indiMotherComment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeLastName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeFirstName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeSex, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeAge, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeBirthDate, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeBirthPlace, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeBirthAddress, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeOccupation, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeResidence, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeAddress, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wife, AbstractRecord.FieldType.wifeComment, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMarried, AbstractRecord.FieldType.wifeMarriedLastName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMarried, AbstractRecord.FieldType.wifeMarriedFirstName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMarried, AbstractRecord.FieldType.wifeMarriedDead, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMarried, AbstractRecord.FieldType.wifeMarriedOccupation, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMarried, AbstractRecord.FieldType.wifeMarriedResidence, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMarried, AbstractRecord.FieldType.wifeMarriedAddress, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMarried, AbstractRecord.FieldType.wifeMarriedComment, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherLastName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherFirstName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherAge, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherDead, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherOccupation, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherResidence, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherAddress, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeFather, AbstractRecord.FieldType.wifeFatherComment, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherLastName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherFirstName, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherAge, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherDead, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherOccupation, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherResidence, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherAddress, false, true, false, true);
        BeanGroup.initGroupField(GroupId.wifeMother, AbstractRecord.FieldType.wifeMotherComment, false, true, false, true);
        BeanGroup.initGroupField(GroupId.witness1, AbstractRecord.FieldType.witness1LastName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness1, AbstractRecord.FieldType.witness1FirstName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness1, AbstractRecord.FieldType.witness1Occupation, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness1, AbstractRecord.FieldType.witness1Comment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness2, AbstractRecord.FieldType.witness2LastName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness2, AbstractRecord.FieldType.witness2FirstName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness2, AbstractRecord.FieldType.witness2Occupation, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness2, AbstractRecord.FieldType.witness2Comment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness3, AbstractRecord.FieldType.witness3LastName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness3, AbstractRecord.FieldType.witness3FirstName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness3, AbstractRecord.FieldType.witness3Occupation, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness3, AbstractRecord.FieldType.witness3Comment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness4, AbstractRecord.FieldType.witness4LastName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness4, AbstractRecord.FieldType.witness4FirstName, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness4, AbstractRecord.FieldType.witness4Occupation, true, true, true, true);
        BeanGroup.initGroupField(GroupId.witness4, AbstractRecord.FieldType.witness4Comment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.generalComment, AbstractRecord.FieldType.generalComment, true, true, true, true);
        BeanGroup.initGroupField(GroupId.generalComment, AbstractRecord.FieldType.deedText, true, true, true, true);
        BeanGroup.initGroupField(GroupId.generalComment, AbstractRecord.FieldType.eventMedia, true, true, true, true);
    }

    public static enum GroupId {
        general,
        indi,
        indiMarried,
        indiFather,
        indiMother,
        wife,
        wifeMarried,
        wifeFather,
        wifeMother,
        witness1,
        witness2,
        witness3,
        witness4,
        generalComment;

    }
}

