/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.releve.MainPanelInterface;
import ancestris.modules.releve.MenuCommandProvider;
import ancestris.modules.releve.RelevePanel;
import ancestris.modules.releve.ReleveStatistic;
import ancestris.modules.releve.ReleveTopComponent;
import ancestris.modules.releve.editor.MainPanelTranscriber;
import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.file.FileExtensionFilter;
import ancestris.modules.releve.file.FileManager;
import ancestris.modules.releve.file.ReleveFileAncestrisV2;
import ancestris.modules.releve.file.ReleveFileDialog;
import ancestris.modules.releve.file.ReleveFileExport;
import ancestris.modules.releve.file.ReleveFileGedcom;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.model.RecordMisc;
import ancestris.modules.releve.model.RecordModel;
import ancestris.modules.releve.search.ResultBuffer;
import ancestris.modules.releve.search.SearchDialog;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public final class MainPanelRegister
extends JPanel
implements MainPanelInterface,
MenuCommandProvider {
    private static final String PREF_LAST_FILE_NAMES = "LastFileNames";
    private final Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private DataManager dataManager;
    private JLabel fileNameLabel;
    private JButton buttonNewFile;
    private JButton buttonLoadFile;
    private JButton buttonSave;
    private JButton buttonSaveAs;
    private JButton buttonImport;
    private JButton buttonExport;
    private JButton buttonStatistics;
    private JButton buttonCheck;
    private JButton buttonDemoFile;
    private JSeparator separator1;
    private JSeparator separator2;
    private JSeparator separator3;
    private JSeparator separator4;
    private File currentFile = null;
    private JTabbedPane jTabbedPane1;
    private RelevePanel panelAll;
    private RelevePanel panelBirth;
    private RelevePanel panelDeath;
    private RelevePanel panelMarriage;
    private RelevePanel panelMisc;
    private Box.Filler filler1;

    public MainPanelRegister(MainPanelTranscriber transcriber) {
        this.initComponents();
        this.fileNameLabel = new JLabel("", new ImageIcon(MainPanelRegister.class.getResource("/ancestris/modules/releve/images/Filename.png")), 10);
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        try {
            this.buttonNewFile = ButtonFactory.create(this, "new", "createFile", "NewFile.png");
            this.buttonLoadFile = ButtonFactory.create(this, "open", "loadFile", "OpenFile.png");
            this.buttonSave = ButtonFactory.create(this, "save", "saveFile", "SaveFile.png");
            this.buttonSaveAs = ButtonFactory.create(this, "saveas", "saveFileAs", "SaveFileAs.png");
            this.buttonImport = ButtonFactory.create(this, "import", "importFile", "ImportFile.png");
            this.buttonExport = ButtonFactory.create(this, "export", "exportFile", "ExportFile.png");
            this.buttonStatistics = ButtonFactory.create(this, "statistics", "showStatistics", "Statistics.png");
            this.buttonCheck = ButtonFactory.create(this, "check", "showCheck", "Search.png");
            this.buttonDemoFile = ButtonFactory.create(this, "demo", "loadFileDemo", "Demo.png");
            this.separator1 = new JToolBar.Separator();
            this.separator2 = new JToolBar.Separator();
            this.separator3 = new JToolBar.Separator();
            this.separator4 = new JToolBar.Separator();
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.initModels(transcriber);
    }

    public void initModels(MainPanelTranscriber transcriber) {
        String shortCut = "MainShortcut";
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt N"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt M"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt D"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt T"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt V"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt G"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt K"), shortCut);
        this.getActionMap().put(shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().toUpperCase().equals("N")) {
                    MainPanelRegister.this.jTabbedPane1.setSelectedComponent(MainPanelRegister.this.panelBirth);
                    MainPanelRegister.this.panelBirth.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("M")) {
                    MainPanelRegister.this.jTabbedPane1.setSelectedComponent(MainPanelRegister.this.panelMarriage);
                    MainPanelRegister.this.panelMarriage.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("D")) {
                    MainPanelRegister.this.jTabbedPane1.setSelectedComponent(MainPanelRegister.this.panelDeath);
                    MainPanelRegister.this.panelDeath.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("V")) {
                    MainPanelRegister.this.jTabbedPane1.setSelectedComponent(MainPanelRegister.this.panelMisc);
                    MainPanelRegister.this.panelMisc.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("T")) {
                    MainPanelRegister.this.jTabbedPane1.setSelectedComponent(MainPanelRegister.this.panelAll);
                    MainPanelRegister.this.panelAll.createRecord();
                } else if (!actionEvent.getActionCommand().toUpperCase().equals("K") && actionEvent.getActionCommand().toUpperCase().equals("G")) {
                    Context context;
                    boolean saveResult = true;
                    if (MainPanelRegister.this.dataManager.isDirty()) {
                        saveResult = MainPanelRegister.this.askSaveData();
                    }
                    if (saveResult && (context = GedcomDirectory.getDefault().getDefaultContext()) != null && context.getGedcom() != null) {
                        try {
                            FileBuffer fileBuffer = ReleveFileGedcom.loadFile(context.getGedcom());
                            MainPanelRegister.this.dataManager.addRecords(fileBuffer, false);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        });
        AncestrisPlugin.register((Object)this);
        this.dataManager = new DataManager();
        this.panelBirth.setModel(this.dataManager, RelevePanel.PanelType.birth, this, transcriber);
        this.panelMarriage.setModel(this.dataManager, RelevePanel.PanelType.marriage, this, transcriber);
        this.panelDeath.setModel(this.dataManager, RelevePanel.PanelType.death, this, transcriber);
        this.panelMisc.setModel(this.dataManager, RelevePanel.PanelType.misc, this, transcriber);
        this.panelAll.setModel(this.dataManager, RelevePanel.PanelType.all, this, transcriber);
        this.setCurrentFile(null);
        String[] lastFileNamesArray = NbPreferences.forModule(MainPanelRegister.class).get(PREF_LAST_FILE_NAMES, "").split(";");
        if (lastFileNamesArray.length > 0 && !lastFileNamesArray[0].isEmpty()) {
            File lastFile = new File(lastFileNamesArray[0]);
            if (lastFile.exists()) {
                this.loadFile(lastFile, false);
            }
            Object lastFileNames = "";
            for (int i = 1; i < lastFileNamesArray.length; ++i) {
                if (!((String)lastFileNames).isEmpty()) {
                    lastFileNames = (String)lastFileNames + ";";
                }
                lastFileNames = (String)lastFileNames + lastFileNamesArray[i];
            }
            NbPreferences.forModule(MainPanelRegister.class).put(PREF_LAST_FILE_NAMES, (String)lastFileNames);
        }
        AncestrisPlugin.register((Object)((Object)this.dataManager));
        this.buttonSave.setEnabled(this.dataManager.isDirty());
        this.dataManager.getDataModel().addPropertyChangeListener(evt -> this.buttonSave.setEnabled((Boolean)evt.getNewValue()));
    }

    @Override
    public String getInfoText() {
        return NbBundle.getMessage(this.getClass(), (String)"mainPanelRegister.info");
    }

    @Override
    public JComponent[] getMenuComponents() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(this.buttonNewFile);
        list.add(this.buttonLoadFile);
        list.add(this.buttonImport);
        list.add(this.buttonDemoFile);
        list.add(this.separator1);
        list.add(this.buttonStatistics);
        list.add(this.buttonCheck);
        list.add(this.separator2);
        list.add(this.buttonSave);
        list.add(this.buttonSaveAs);
        list.add(this.buttonExport);
        list.add(this.separator3);
        list.add(this.fileNameLabel);
        list.add(this.filler1);
        list.add(this.separator4);
        RelevePanel panel = (RelevePanel)this.jTabbedPane1.getSelectedComponent();
        list.addAll(Arrays.asList(panel.getMenuComponents()));
        return (JComponent[])list.toArray(JComponent[]::new);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (l instanceof ReleveTopComponent) {
            this.listeners.add(l);
        }
    }

    @Override
    public void firePropertyChangeEvent(PropertyChangeEvent evt) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    @Override
    public boolean canClose() {
        boolean result = true;
        if (this.dataManager.isDirty()) {
            result = this.askSaveData();
        }
        if (result) {
            this.panelBirth.componentClosed();
            this.panelMarriage.componentClosed();
            this.panelDeath.componentClosed();
            this.panelMisc.componentClosed();
            this.panelAll.componentClosed();
            if (this.currentFile != null) {
                Object lastFileNames = NbPreferences.forModule(MainPanelRegister.class).get(PREF_LAST_FILE_NAMES, "");
                if (!((String)lastFileNames).isEmpty()) {
                    lastFileNames = (String)lastFileNames + ";";
                }
                lastFileNames = (String)lastFileNames + this.currentFile.getAbsolutePath();
                NbPreferences.forModule(MainPanelRegister.class).put(PREF_LAST_FILE_NAMES, (String)lastFileNames);
            }
        }
        return result;
    }

    @Override
    public void componentClosed() {
        AncestrisPlugin.unregister((Object)((Object)this.dataManager));
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public void selectField(AbstractRecord record, AbstractRecord.FieldType fieldType) {
        if (record instanceof RecordBirth) {
            if (this.panelBirth.verifyCurrentRecord()) {
                this.jTabbedPane1.setSelectedComponent(this.panelBirth);
                this.panelBirth.selectRecord(this.dataManager.getDataModel().getIndex(record));
                this.panelBirth.selectField(fieldType);
            }
        } else if (record instanceof RecordMarriage) {
            if (this.panelMarriage.verifyCurrentRecord()) {
                this.jTabbedPane1.setSelectedComponent(this.panelMarriage);
                this.panelMarriage.selectRecord(this.dataManager.getDataModel().getIndex(record));
                this.panelMarriage.selectField(fieldType);
            }
        } else if (record instanceof RecordDeath) {
            if (this.panelDeath.verifyCurrentRecord()) {
                this.jTabbedPane1.setSelectedComponent(this.panelDeath);
                this.panelDeath.selectRecord(this.dataManager.getDataModel().getIndex(record));
                this.panelDeath.selectField(fieldType);
            }
        } else if (record instanceof RecordMisc && this.panelMisc.verifyCurrentRecord()) {
            this.jTabbedPane1.setSelectedComponent(this.panelMisc);
            this.panelMisc.selectRecord(this.dataManager.getDataModel().getIndex(record));
            this.panelMisc.selectField(fieldType);
        }
    }

    @Override
    public void setGedcomLinkSelected(boolean selected) {
        this.panelBirth.setGedcomLinkSelected(selected);
        this.panelMarriage.setGedcomLinkSelected(selected);
        this.panelDeath.setGedcomLinkSelected(selected);
        this.panelMisc.setGedcomLinkSelected(selected);
        this.panelAll.setGedcomLinkSelected(selected);
    }

    @Override
    public String getSelectedFileAbsolutePath() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void showStatistics() {
        ReleveStatistic.showStatistics(this.dataManager);
    }

    public void showCheck() {
        ResultBuffer errorBuffer = new ResultBuffer();
        SearchDialog.show(null, this, this.dataManager, errorBuffer, this.currentFile);
    }

    public void createFile() {
        boolean result = true;
        if (this.dataManager.isDirty()) {
            result = this.askSaveData();
        }
        if (result) {
            this.dataManager.removeAll();
            this.panelBirth.selectRecord(-1);
            this.panelMarriage.selectRecord(-1);
            this.panelDeath.selectRecord(-1);
            this.panelMisc.selectRecord(-1);
            this.panelAll.selectRecord(-1);
            this.setCurrentFile(null);
        }
        this.resizeAllTableColumns();
    }

    public void loadFile() {
        boolean result = true;
        if (this.dataManager.isDirty()) {
            result = this.askSaveData();
        }
        if (result) {
            String title = NbBundle.getMessage(MainPanelRegister.class, (String)"LOAD_FILE");
            File releveFile = MainPanelRegister.getFileFromUserForOpen(this, title, AbstractAncestrisAction.TXT_OK, "", "txt");
            this.loadFile(releveFile, false);
        }
    }

    public void importFile() {
        String title = NbBundle.getMessage(MainPanelRegister.class, (String)"LOAD_FILE");
        File releveFile = MainPanelRegister.getFileFromUserForOpen(this, title, AbstractAncestrisAction.TXT_OK, "", "txt");
        this.loadFile(releveFile, true);
    }

    private void loadFile(File releveFile, boolean append) {
        String title = ResourceBundle.getBundle("ancestris/modules/releve/Bundle").getString("LOAD_FILE");
        RecordModel.setUndoEnabled(false);
        try {
            if (releveFile != null) {
                FileBuffer fileBuffer = FileManager.loadFile(releveFile);
                if (fileBuffer.getError().length() > 0) {
                    String message = String.format(ResourceBundle.getBundle("ancestris/modules/releve/Bundle").getString("INFO_FILE"), releveFile.getName(), fileBuffer.getBirthCount(), fileBuffer.getMarriageCount(), fileBuffer.getDeathCount(), fileBuffer.getMiscCount());
                    ReleveFileDialog.show(WindowManager.getDefault().getMainWindow(), title, message, fileBuffer.getError());
                }
                List<String> places = fileBuffer.getPlaces();
                String defaultPlace = "";
                if (!append) {
                    defaultPlace = "";
                }
                int forceDefaultPlace = 0;
                if (!places.isEmpty()) {
                    if (places.size() > 1) {
                        if (append) {
                            if (defaultPlace.isEmpty()) {
                                defaultPlace = this.askSelectDefaultPlace(places);
                            }
                            if (defaultPlace != null) {
                                forceDefaultPlace = this.askDifferentPlace(places, defaultPlace);
                            }
                        } else {
                            defaultPlace = this.askSelectDefaultPlace(places);
                            if (defaultPlace != null) {
                                forceDefaultPlace = this.askDifferentPlace(places, defaultPlace);
                            }
                        }
                    } else if (places.size() == 1) {
                        if (append) {
                            if (defaultPlace.isEmpty()) {
                                defaultPlace = places.toArray()[0].toString();
                            } else if (!places.toArray()[0].equals(defaultPlace)) {
                                forceDefaultPlace = this.askDifferentPlace(places, defaultPlace);
                            }
                        } else {
                            defaultPlace = places.toArray()[0].toString();
                        }
                    }
                }
                if (defaultPlace != null && forceDefaultPlace != -1) {
                    this.dataManager.addRecords(fileBuffer, append);
                    if (!append) {
                        this.panelBirth.selectRow(0);
                        this.panelMarriage.selectRow(0);
                        this.panelDeath.selectRow(0);
                        this.panelMisc.selectRow(0);
                        this.panelAll.selectRow(0);
                    }
                    RelevePanel selectedPanel = this.panelBirth;
                    if (this.panelBirth.getRowCount() != 0) {
                        selectedPanel = this.panelBirth;
                    } else if (this.panelMarriage.getRowCount() != 0) {
                        selectedPanel = this.panelMarriage;
                    } else if (this.panelDeath.getRowCount() != 0) {
                        selectedPanel = this.panelDeath;
                    } else if (this.panelMisc.getRowCount() != 0) {
                        selectedPanel = this.panelMisc;
                    }
                    this.jTabbedPane1.setSelectedComponent(selectedPanel);
                    if (!append) {
                        this.setCurrentFile(releveFile);
                    }
                }
            }
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            ex.printStackTrace(System.err);
            Toolkit.getDefaultToolkit().beep();
            if (ex.getMessage() == null || message.isEmpty()) {
                JOptionPane.showMessageDialog(this, ex.getClass().getName() + " See console log", title, 0);
            }
            JOptionPane.showMessageDialog(this, ex.getMessage(), title, 0);
        }
        RecordModel.setUndoEnabled(true);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.RELOAD_FILE, this, null));
        this.resizeAllTableColumns();
    }

    private String askSelectDefaultPlace(List<String> places) {
        String title = NbBundle.getMessage(MainPanelRegister.class, (String)"LOAD_FILE");
        Object result = JOptionPane.showInputDialog(this, "Choisir le lieu par d\u00e9faut :", title, 3, null, places.toArray(), places.toArray()[0]);
        String defaultPlace = result != null ? result.toString() : null;
        return defaultPlace;
    }

    private int askDifferentPlace(List<String> places, String defaultPlace) {
        String title = NbBundle.getMessage(MainPanelRegister.class, (String)"LOAD_FILE");
        Object message = String.format("Ce fichier contient des relev\u00e9s qui ont des lieux diff\u00e9rents de %s", defaultPlace);
        for (String place : places) {
            message = (String)message + "\n   " + place;
        }
        message = (String)message + "\n";
        message = (String)message + String.format("Voulez-vous les ignorer, ou remplacer leur lieu par %s ?", defaultPlace);
        Object[] options = new String[]{"Ignorer", "Remplacer", "Abandonner"};
        int result = JOptionPane.showOptionDialog(this, message, title, -1, 3, null, options, options[0]);
        switch (result) {
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    private boolean askSaveData() {
        Object fileName;
        String title = NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.save");
        if (this.currentFile != null) {
            fileName = this.currentFile.getName();
        } else {
            fileName = "";
            if (!((String)fileName).isEmpty()) {
                fileName = (String)fileName + ".txt";
            }
        }
        Object o = DialogManager.create((String)title, (String)String.format(NbBundle.getMessage(MainPanelRegister.class, (String)"message.saveFile"), fileName)).setMessageType(3).setOptionType(1).show();
        if (o == DialogManager.YES_OPTION) {
            this.saveFile();
        }
        return o != DialogManager.CANCEL_OPTION;
    }

    private static File getFileFromUserForOpen(Component component, String title, String buttonLabel, String defaultFileName, String extension) {
        File file = new FileChooserBuilder(MainPanelRegister.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(title).setApproveText(buttonLabel).setDefaultExtension(extension).setSelectedFile(new File(defaultFileName)).setDefaultWorkingDirectory(FileManager.getPreferredDir()).setFileHiding(true).showOpenDialog();
        if (file == null) {
            return null;
        }
        FileManager.putPreferredDir(file.getParentFile());
        return file;
    }

    public void saveFile() {
        if (this.currentFile != null) {
            StringBuilder saveResult = FileManager.saveFile(this.dataManager, this.currentFile, FileManager.FileFormat.FILE_TYPE_ANCESTRISV6);
            if (saveResult.toString().isEmpty()) {
                this.dataManager.resetDirty();
            } else {
                String message = saveResult.toString();
                String title = NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.save");
                JOptionPane.showMessageDialog(this, message, title, 0);
            }
        } else {
            this.saveFileAs();
        }
    }

    public void saveFileAs() {
        Object fileName;
        String buttonLabel = NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.save");
        String title = NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.saveas");
        String extension = "txt";
        if (this.currentFile != null) {
            fileName = this.currentFile.getName();
        } else {
            fileName = "default";
            if (!((String)fileName).isEmpty()) {
                fileName = (String)fileName + ".txt";
            }
        }
        File file = new FileChooserBuilder(MainPanelRegister.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(title).setApproveText(buttonLabel).setDefaultExtension(extension).setSelectedFile(new File((String)fileName)).setDefaultWorkingDirectory(FileManager.getPreferredDir()).setFileHiding(true).showSaveDialog();
        if (file != null) {
            FileManager.putPreferredDir(file.getParentFile());
            StringBuilder saveResult = FileManager.saveFile(this.dataManager, file, FileManager.FileFormat.FILE_TYPE_ANCESTRISV6);
            if (saveResult.toString().isEmpty()) {
                this.dataManager.resetDirty();
                this.setCurrentFile(file);
            } else {
                String message = saveResult.toString();
                JOptionPane.showMessageDialog(this, message, title, 0);
            }
        }
    }

    public void exportFile() {
        final FileChooserBuilder fcb = new FileChooserBuilder(MainPanelRegister.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(this.getClass(), (String)"FileChooserOKButton")).setDefaultWorkingDirectory(FileManager.getPreferredDir()).setFileHiding(true).setAcceptAllFileFilterUsed(false);
        JPanel panelExport = new JPanel();
        JPanel jPanelFormat = new JPanel();
        final JRadioButton jRadioButtonEgmt = new JRadioButton();
        final JRadioButton jRadioButtonNimegue = new JRadioButton();
        final JRadioButton jRadioButtonPdf = new JRadioButton();
        ButtonGroup buttonGroupFormat = new ButtonGroup();
        buttonGroupFormat.add(jRadioButtonEgmt);
        buttonGroupFormat.add(jRadioButtonNimegue);
        buttonGroupFormat.add(jRadioButtonPdf);
        final JRadioButton jRadioButtonAll = new JRadioButton();
        final JRadioButton jRadioButtonBirth = new JRadioButton();
        final JRadioButton jRadioButtonMarriage = new JRadioButton();
        final JRadioButton jRadioButtonDeath = new JRadioButton();
        final JRadioButton jRadioButtonMisc = new JRadioButton();
        ButtonGroup buttonGroupModel = new ButtonGroup();
        buttonGroupModel.add(jRadioButtonAll);
        buttonGroupModel.add(jRadioButtonBirth);
        buttonGroupModel.add(jRadioButtonMarriage);
        buttonGroupModel.add(jRadioButtonDeath);
        buttonGroupModel.add(jRadioButtonMisc);
        JPanel jPanelModel = new JPanel();
        panelExport.setLayout(new GridBagLayout());
        jPanelFormat.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jPanelFormat.border.title")));
        jPanelFormat.setLayout(new GridLayout(2, 1, 2, 2));
        jRadioButtonEgmt.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonEgmt.text"));
        jPanelFormat.add(jRadioButtonEgmt);
        jRadioButtonNimegue.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonNimegue.text"));
        jPanelFormat.add(jRadioButtonNimegue);
        jRadioButtonPdf.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonPdf.text"));
        jPanelFormat.add(jRadioButtonPdf);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panelExport.add((Component)jPanelFormat, gridBagConstraints);
        jPanelModel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jPanelModel.border.title")));
        jPanelModel.setLayout(new GridLayout(5, 1, 2, 2));
        jRadioButtonAll.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonAll.text"));
        jPanelModel.add(jRadioButtonAll);
        jRadioButtonBirth.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonBirth.text"));
        jPanelModel.add(jRadioButtonBirth);
        jRadioButtonMarriage.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonMarriage.text"));
        jPanelModel.add(jRadioButtonMarriage);
        jRadioButtonDeath.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonDeath.text"));
        jPanelModel.add(jRadioButtonDeath);
        jRadioButtonMisc.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonMisc.text"));
        jPanelModel.add(jRadioButtonMisc);
        ActionListener rbActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String extension = "txt";
                String cityName = "default";
                if (cityName.isEmpty()) {
                    cityName = "";
                }
                String recordType = jRadioButtonAll.isSelected() ? "" : (jRadioButtonBirth.isSelected() ? "_B" : (jRadioButtonMarriage.isSelected() ? "_M" : (jRadioButtonDeath.isSelected() ? "_D" : (jRadioButtonMisc.isSelected() ? "_V" : ""))));
                String format = "";
                if (jRadioButtonEgmt.isSelected()) {
                    format = "_EGMT";
                    extension = "csv";
                } else if (jRadioButtonNimegue.isSelected()) {
                    format = "_NIMEGUE";
                    extension = "txt";
                } else if (jRadioButtonPdf.isSelected()) {
                    format = "";
                    extension = "pdf";
                }
                String defaultFileName = cityName + recordType + format + "." + extension;
                fcb.setDefaultExtension(extension);
                fcb.setSelectedFile(new File(defaultFileName));
                fcb.forceSelectedFile(new File(defaultFileName));
                fcb.forceFileFilter((FileFilter)new FileExtensionFilter(extension));
            }
        };
        jRadioButtonEgmt.addActionListener(rbActionListener);
        jRadioButtonNimegue.addActionListener(rbActionListener);
        jRadioButtonPdf.addActionListener(rbActionListener);
        jRadioButtonAll.addActionListener(rbActionListener);
        jRadioButtonBirth.addActionListener(rbActionListener);
        jRadioButtonMarriage.addActionListener(rbActionListener);
        jRadioButtonDeath.addActionListener(rbActionListener);
        jRadioButtonMisc.addActionListener(rbActionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        panelExport.add((Component)jPanelModel, gridBagConstraints);
        jRadioButtonEgmt.setSelected(true);
        jRadioButtonBirth.setSelected(true);
        rbActionListener.actionPerformed(new ActionEvent(this, 1001, null){});
        fcb.setDefaultExtension("csv").setSelectedFile(new File("export_B_EGMT.csv")).setFileFilter((FileFilter)new FileExtensionFilter("csv")).setAccessory((JComponent)panelExport);
        File file = fcb.showSaveDialog();
        if (file != null) {
            FileManager.putPreferredDir(file.getParentFile());
            FileManager.FileFormat fileFormat = FileManager.FileFormat.FILE_TYPE_UNKNOW;
            if (jRadioButtonEgmt.isSelected()) {
                fileFormat = FileManager.FileFormat.FILE_TYPE_EGMT;
            } else if (jRadioButtonNimegue.isSelected()) {
                fileFormat = FileManager.FileFormat.FILE_TYPE_NIMEGUE;
            } else if (jRadioButtonPdf.isSelected()) {
                fileFormat = FileManager.FileFormat.FILE_TYPE_PDF;
            }
            StringBuilder saveResult = new StringBuilder();
            if (jRadioButtonAll.isSelected()) {
                FileManager.saveFile(this.dataManager, file, fileFormat);
            } else if (jRadioButtonBirth.isSelected()) {
                FileManager.saveFile(file, fileFormat, this.dataManager.getDataModel(), AbstractRecord.RecordType.BIRTH);
            } else if (jRadioButtonMarriage.isSelected()) {
                FileManager.saveFile(file, fileFormat, this.dataManager.getDataModel(), AbstractRecord.RecordType.MARRIAGE);
            } else if (jRadioButtonDeath.isSelected()) {
                FileManager.saveFile(file, fileFormat, this.dataManager.getDataModel(), AbstractRecord.RecordType.DEATH);
            } else if (jRadioButtonMisc.isSelected()) {
                FileManager.saveFile(file, fileFormat, this.dataManager.getDataModel(), AbstractRecord.RecordType.MISC);
            }
            if (!saveResult.toString().isEmpty()) {
                String message = saveResult.toString();
                JOptionPane.showMessageDialog(this, message, NbBundle.getMessage(this.getClass(), (String)"FileChooserTitle"), 0);
            }
        }
    }

    public void loadFileDemo() {
        boolean result = true;
        if (this.dataManager.isDirty()) {
            result = this.askSaveData();
        }
        if (result) {
            try {
                InputStream is = this.getClass().getResourceAsStream("/ancestris/modules/releve/file/bourbons.txt");
                FileBuffer fileBuffer = ReleveFileAncestrisV2.loadFile(is);
                this.dataManager.addRecords(fileBuffer, false);
                this.setCurrentFile(null);
                this.dataManager.resetDirty();
                this.panelBirth.selectRow(0);
                this.panelMarriage.selectRow(0);
                this.panelDeath.selectRow(0);
                this.panelMisc.selectRow(0);
                this.panelAll.selectRow(0);
                this.setCurrentFile(new File(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.demoRecord")));
                this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.RELOAD_FILE, this, null));
                this.resizeAllTableColumns();
            }
            catch (MissingResourceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void setCurrentFile(File releveFile) {
        this.currentFile = releveFile;
        this.dataManager.setCurrentFile(this.currentFile);
        String[] nameAndTip = this.getCurrentModuleName();
        this.fileNameLabel.setText(nameAndTip[0]);
        this.fileNameLabel.setToolTipText(nameAndTip[1]);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.FILE_CHANGED, nameAndTip, null));
    }

    public String[] getCurrentModuleName() {
        String tip;
        String name;
        if (this.currentFile != null) {
            name = this.currentFile.getName();
            tip = NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.existingRecordTitle.tip", (Object)this.currentFile.getAbsolutePath());
        } else {
            name = NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.newRecordTitle");
            tip = NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.newRecordTitle.tip");
        }
        return new String[]{name, tip};
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setTranscriber(MainPanelTranscriber transcriber) {
        this.setCurrentFile(this.currentFile);
        this.updateTranscriber(transcriber);
    }

    public void updateTranscriber(MainPanelTranscriber transcriber) {
        int recordIndex = switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0 -> this.panelBirth.getCurrentRecordIndex();
            case 1 -> this.panelMarriage.getCurrentRecordIndex();
            case 2 -> this.panelDeath.getCurrentRecordIndex();
            case 3 -> this.panelMisc.getCurrentRecordIndex();
            default -> this.panelAll.getCurrentRecordIndex();
        };
        if (transcriber != null) {
            transcriber.setDataManager(this.dataManager, this, this.panelBirth.getCurrentRecordIndex(), this.panelMarriage.getCurrentRecordIndex(), this.panelDeath.getCurrentRecordIndex(), this.panelMisc.getCurrentRecordIndex(), this.panelAll.getCurrentRecordIndex(), this.jTabbedPane1.getSelectedIndex());
            transcriber.selectRecord(this.dataManager, this.jTabbedPane1.getSelectedIndex(), recordIndex);
        }
    }

    public void selectRecord(MainPanelTranscriber transcriber, int recordIndex) {
        transcriber.selectRecord(this.dataManager, this.jTabbedPane1.getSelectedIndex(), recordIndex);
    }

    private void resizeAllTableColumns() {
        this.panelBirth.resizeColumns();
        this.panelMarriage.resizeColumns();
        this.panelDeath.resizeColumns();
        this.panelMisc.resizeColumns();
        this.panelAll.resizeColumns();
    }

    @Override
    public void showRecord(int panelIndex, int recordIndex) {
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.SELECT_RECORD_IN_MAIN_TRANSCRIBER, this, recordIndex));
    }

    @Override
    public void recordSelectionChanged() {
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.panelBirth = new RelevePanel();
        this.panelMarriage = new RelevePanel();
        this.panelDeath = new RelevePanel();
        this.panelMisc = new RelevePanel();
        this.panelAll = new RelevePanel();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setVerifyInputWhenFocusTarget(false);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainPanelRegister.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.panelBirth.setMinimumSize(new Dimension(100, 100));
        this.panelBirth.setName("");
        this.panelBirth.setRequestFocusEnabled(false);
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelBirth.TabConstraints.tabTitle"), this.panelBirth);
        this.jTabbedPane1.setTabComponentAt(0, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelBirth.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Birth.png")), 2));
        this.panelMarriage.setMinimumSize(new Dimension(100, 100));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelMarriage.TabConstraints.tabTitle"), this.panelMarriage);
        this.jTabbedPane1.setTabComponentAt(1, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelMarriage.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Marriage.png")), 2));
        this.panelDeath.setMinimumSize(new Dimension(100, 100));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelDeath.TabConstraints.tabTitle"), this.panelDeath);
        this.jTabbedPane1.setTabComponentAt(2, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelDeath.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Death.png")), 2));
        this.panelMisc.setMinimumSize(new Dimension(100, 100));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelMisc.TabConstraints.tabTitle"), this.panelMisc);
        this.jTabbedPane1.setTabComponentAt(3, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelMisc.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/misc.png")), 2));
        this.panelAll.setMinimumSize(new Dimension(100, 100));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelAll.TabConstraints.tabTitle"), this.panelAll);
        this.jTabbedPane1.setTabComponentAt(4, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelAll.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/All.png")), 2));
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.TAB_CHANGED, this.jTabbedPane1, null));
    }

    public static class ButtonFactory {
        public static JButton create(MainPanelRegister panel, String name, String methodName, String iconname) throws NoSuchMethodException {
            Method actionMethod = MainPanelRegister.class.getMethod(methodName, null);
            name = NbBundle.getMessage(MainPanelRegister.class, (String)("ReleveTopComponent.menu." + name));
            JButton button = new JButton(new ImageIcon(MainPanelRegister.class.getResource("/ancestris/modules/releve/images/" + iconname)));
            button.setToolTipText(name);
            button.setMargin(new Insets(2, 4, 2, 4));
            button.addActionListener(e -> {
                try {
                    actionMethod.invoke((Object)panel, (Object[])null);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
            return button;
        }
    }
}

