/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.util.WordBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FormattingIcsOptions {
    public boolean isOutputICal = false;
    private Writer writer;
    private File file;
    private static final SimpleDateFormat FORMATDTSTAMP = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final SimpleDateFormat FORMATDTSTART = new SimpleDateFormat("yyyyMMdd");
    private final String tzid = TimeZone.getDefault().getID();
    private int sequence = 60000;

    public void createFile(Report report, String title, boolean internal, List<? extends CalendarRecord> records) {
        String header = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Ancestris//" + title + "/EN\r\nMETHOD:PUBLISH";
        String footer = "END:VCALENDAR";
        String timestamp = this.toISO(System.currentTimeMillis(), true);
        FORMATDTSTAMP.setTimeZone(TimeZone.getTimeZone("GMT"));
        FORMATDTSTART.setTimeZone(TimeZone.getDefault());
        if (internal) {
            report.println((Object)header);
            for (CalendarRecord calendarRecord : records) {
                if (!calendarRecord.isDatePrecise()) continue;
                report.println((Object)this.getCalendarString(calendarRecord.getEntity(), calendarRecord.getProperty(), calendarRecord.getName(), calendarRecord.getDate(), calendarRecord.getPit(), calendarRecord.getPlace(), timestamp));
            }
            report.println((Object)footer);
        } else {
            boolean ok = this.outputHeader(report, header + "\r\n");
            if (ok) {
                for (CalendarRecord calendarRecord : records) {
                    if (calendarRecord.isDatePrecise() && !(ok = this.outputRecord(this.getCalendarString(calendarRecord.getEntity(), calendarRecord.getProperty(), calendarRecord.getName(), calendarRecord.getDate(), calendarRecord.getPit(), calendarRecord.getPlace(), timestamp)))) break;
                }
                if (ok) {
                    ok = this.outputFooter(footer + "\r\n");
                }
            }
            report.println();
            this.display(report, ok);
            report.println();
        }
    }

    public String toISO(long timeMillis, boolean time) {
        if (time) {
            timeMillis += (long)this.sequence;
            this.sequence += 60000;
        }
        Date date = new Date(timeMillis);
        return time ? ";TZID=" + this.tzid + ":" + FORMATDTSTAMP.format(date) : ";VALUE=DATE:" + FORMATDTSTART.format(date);
    }

    private boolean outputHeader(Report report, String header) {
        this.file = report.getFileFromUser(NbBundle.getMessage(FormattingIcsOptions.class, (String)"ChooseICSFile"), AbstractAncestrisAction.TXT_OK, true, "ics", "");
        if (this.file == null) {
            return false;
        }
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        try {
            this.writer.write(header);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean outputRecord(String recordString) {
        try {
            this.writer.write(recordString);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean outputFooter(String footer) {
        try {
            this.writer.write(footer);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        try {
            this.writer.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }

    private void display(Report report, boolean ok) {
        if (this.file != null) {
            report.println((Object)("================== " + NbBundle.getMessage(FormattingIcsOptions.class, (String)(ok ? "SuccessICS" : "FailureICS"), (Object)this.file.getAbsolutePath()) + " =================="));
        } else {
            report.println((Object)("================== " + NbBundle.getMessage(FormattingIcsOptions.class, (String)"Cancelled") + " =================="));
        }
    }

    public String getCalendarString(Entity entity, PropertyEventDetails event, String name, String date, PointInTime pit, String place, String timestamp) {
        String type;
        WordBuffer result = new WordBuffer("\r\n");
        result.append("BEGIN:VEVENT");
        String uid = entity.getGedcom().getName().replace(".ged", "") + "|" + entity.getId() + "|" + event.getTag();
        try {
            MessageDigest salt = MessageDigest.getInstance("SHA-256");
            salt.update(UUID.randomUUID().toString().getBytes("UTF-8"));
            uid = uid + "|" + this.encodeHexString(salt.digest());
        }
        catch (NoSuchAlgorithmException salt) {
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        result.append("UID:" + uid);
        result.append("DTSTAMP" + timestamp);
        result.append("CATEGORIES:" + name);
        if (date != null && pit != null) {
            String dtstartstop = "";
            try {
                dtstartstop = this.toISO(pit.getTimeMillis(), false);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            result.append("DTSTART" + dtstartstop);
            result.append("DTSTOP" + dtstartstop);
        }
        result.append("SUMMARY:" + name + " - " + this.icalescape(entity.getDisplayTitle(false)));
        String description = event.getDisplayValue();
        Property p = event.getProperty("TYPE");
        String string = type = p != null ? p.getDisplayValue() : "";
        if (!description.isBlank() || !type.isBlank()) {
            Object text = name;
            if (!description.isBlank()) {
                text = (String)text + " " + description;
            }
            if (!type.isBlank()) {
                text = description.isBlank() ? (String)text + " " + type : (String)text + " (" + type + ")";
            }
            result.append("DESCRIPTION:" + (String)text);
        }
        if (!"".equals(place)) {
            result.append("LOCATION:" + this.icalescape(place));
        }
        result.append("RRULE:FREQ=YEARLY");
        result.append("END:VEVENT");
        return result.toString();
    }

    private String encodeHexString(byte[] byteArray) {
        StringBuilder hexStringBuilder = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            hexStringBuilder.append(this.byteToHex(byteArray[i]));
        }
        return hexStringBuilder.toString();
    }

    private String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    private String icalescape(String string) {
        return string.replaceAll(",", "\\\\,");
    }

    public static interface CalendarRecord {
        public Entity getEntity();

        public PropertyEventDetails getProperty();

        public String getName();

        public String getDate();

        public PointInTime getPit();

        public String getPlace();

        public boolean isDatePrecise();
    }
}

